/***************************************************************************
                          ps_resolv.h  -  description
                             -------------------
    begin                : Sat Aug 24 2002
    copyright            : (C) 2002 by Jan Fernquist, Florian Boor
    email                : boor@unix-ag.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __PSRESOLV_H__
#define __PSRESOLV_H__

// This file is adapted cde from ethereal. Thanks!

/* resolv.h
 * Definitions for network object lookup
 *
 * $Id: ps_resolv.h,v 1.1.1.1 2003/05/22 10:28:21 florian Exp $
 *
 * Laurent Deniel <deniel@worldnet.fr>
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@ethereal.com>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef MAXNAMELEN
#define MAXNAMELEN  	64	/* max name length (hostname and port name) */
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <glib.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>

/*
 * Flag controlling what names to resolve.
 */
extern guint32 g_resolv_flags;

/* 32 types are sufficient (as are 640k of RAM) */
/* FIXME: Maybe MANUF/m, IP/i, IP6/6, IPX/x, UDP+TCP/t etc would be
   more useful/consistent */
#define RESOLV_NONE		0x0
#define RESOLV_MAC		0x1
#define RESOLV_NETWORK		0x2
#define RESOLV_TRANSPORT	0x4
#define RESOLV_ALL		0xFFFFFFFF

/* global variables */

extern gchar *g_ethers_path;
extern gchar *g_pethers_path;
extern gchar *g_pipxnets_path;

/* Functions in ps_resolv.c */

/* Set the flags controlling what names to resolve */
extern void resolv_set_flags(guint32 flags);

/* get_manuf_name returns the vendor name or "%02x:%02x:%02x" if not known */
extern const guchar *get_manuf_name(const guint8 *addr);
gchar*     ether_to_str(const guint8 *);
gchar*     ether_to_str_punct(const guint8 *, char);

#endif
