/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.MemberInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.visitor.MemberInfoVisitor;

public abstract class ProgramMemberInfo
implements MemberInfo {
    public int u2accessFlags;
    public int u2nameIndex;
    public int u2descriptorIndex;
    public int u2attributesCount;
    public AttrInfo[] attributes;
    public Object visitorInfo;

    protected ProgramMemberInfo() {
    }

    public String getLineNumberRange(ClassFile classFile) {
        CodeAttrInfo codeAttrInfo = (CodeAttrInfo)this.getAttribute(classFile, "Code");
        if (codeAttrInfo == null) {
            return null;
        }
        LineNumberTableAttrInfo lineNumberTableAttrInfo = (LineNumberTableAttrInfo)codeAttrInfo.getAttribute(classFile, "LineNumberTable");
        if (lineNumberTableAttrInfo == null) {
            return null;
        }
        return "" + lineNumberTableAttrInfo.getLineNumber(0) + ":" + lineNumberTableAttrInfo.getLineNumber(Integer.MAX_VALUE);
    }

    private AttrInfo getAttribute(ClassFile classFile, String string) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            AttrInfo attrInfo = this.attributes[i];
            if (!attrInfo.getAttributeName(classFile).equals(string)) continue;
            return attrInfo;
        }
        return null;
    }

    public abstract void accept(ProgramClassFile var1, MemberInfoVisitor var2);

    public abstract void attributesAccept(ProgramClassFile var1, AttrInfoVisitor var2);

    protected void read(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2accessFlags = dataInput.readUnsignedShort();
        this.u2nameIndex = dataInput.readUnsignedShort();
        this.u2descriptorIndex = dataInput.readUnsignedShort();
        this.u2attributesCount = dataInput.readUnsignedShort();
        if (this.u2attributesCount > 0) {
            this.attributes = new AttrInfo[this.u2attributesCount];
            for (int i = 0; i < this.u2attributesCount; ++i) {
                this.attributes[i] = AttrInfo.create(dataInput, classFile);
            }
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2accessFlags);
        dataOutput.writeShort(this.u2nameIndex);
        dataOutput.writeShort(this.u2descriptorIndex);
        dataOutput.writeShort(this.u2attributesCount);
        for (int i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i].write(dataOutput);
        }
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    public String getName(ClassFile classFile) {
        return classFile.getCpString(this.u2nameIndex);
    }

    public String getDescriptor(ClassFile classFile) {
        return classFile.getCpString(this.u2descriptorIndex);
    }

    public void accept(ClassFile classFile, MemberInfoVisitor memberInfoVisitor) {
        this.accept((ProgramClassFile)classFile, memberInfoVisitor);
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

