/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;

public class MultiAttrInfoVisitor
implements AttrInfoVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private AttrInfoVisitor[] attrInfoVisitors;
    private int attrInfoVisitorCount;

    public MultiAttrInfoVisitor() {
    }

    public MultiAttrInfoVisitor(AttrInfoVisitor[] attrInfoVisitorArray) {
        this.attrInfoVisitors = attrInfoVisitorArray;
        this.attrInfoVisitorCount = attrInfoVisitorArray.length;
    }

    public void addAttrInfoVisitor(AttrInfoVisitor attrInfoVisitor) {
        this.ensureArraySize();
        this.attrInfoVisitors[this.attrInfoVisitorCount++] = attrInfoVisitor;
    }

    private void ensureArraySize() {
        if (this.attrInfoVisitors == null) {
            this.attrInfoVisitors = new AttrInfoVisitor[5];
        } else if (this.attrInfoVisitors.length == this.attrInfoVisitorCount) {
            AttrInfoVisitor[] attrInfoVisitorArray = new AttrInfoVisitor[this.attrInfoVisitorCount + 5];
            System.arraycopy(this.attrInfoVisitors, 0, attrInfoVisitorArray, 0, this.attrInfoVisitorCount);
            this.attrInfoVisitors = attrInfoVisitorArray;
        }
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitUnknownAttrInfo(classFile, unknownAttrInfo);
        }
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitInnerClassesAttrInfo(classFile, innerClassesAttrInfo);
        }
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitEnclosingMethodAttrInfo(classFile, enclosingMethodAttrInfo);
        }
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitConstantValueAttrInfo(classFile, fieldInfo, constantValueAttrInfo);
        }
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitExceptionsAttrInfo(classFile, methodInfo, exceptionsAttrInfo);
        }
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
        }
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitLineNumberTableAttrInfo(classFile, methodInfo, codeAttrInfo, lineNumberTableAttrInfo);
        }
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitLocalVariableTableAttrInfo(classFile, methodInfo, codeAttrInfo, localVariableTableAttrInfo);
        }
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitLocalVariableTypeTableAttrInfo(classFile, methodInfo, codeAttrInfo, localVariableTypeTableAttrInfo);
        }
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitSourceFileAttrInfo(classFile, sourceFileAttrInfo);
        }
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitSourceDirAttrInfo(classFile, sourceDirAttrInfo);
        }
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitDeprecatedAttrInfo(classFile, deprecatedAttrInfo);
        }
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitSyntheticAttrInfo(classFile, syntheticAttrInfo);
        }
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitSignatureAttrInfo(classFile, signatureAttrInfo);
        }
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitRuntimeVisibleAnnotationAttrInfo(classFile, runtimeVisibleAnnotationsAttrInfo);
        }
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitRuntimeInvisibleAnnotationAttrInfo(classFile, runtimeInvisibleAnnotationsAttrInfo);
        }
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitRuntimeVisibleParameterAnnotationAttrInfo(classFile, runtimeVisibleParameterAnnotationsAttrInfo);
        }
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitRuntimeInvisibleParameterAnnotationAttrInfo(classFile, runtimeInvisibleParameterAnnotationsAttrInfo);
        }
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        for (int i = 0; i < this.attrInfoVisitorCount; ++i) {
            this.attrInfoVisitors[i].visitAnnotationDefaultAttrInfo(classFile, annotationDefaultAttrInfo);
        }
    }
}

