/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

class ShortestUsageMark {
    private boolean certain;
    private String reason;
    private int depth;
    private ClassFile classFile;
    private MethodInfo methodInfo;

    public ShortestUsageMark(String string) {
        this.certain = true;
        this.reason = string;
        this.depth = 0;
    }

    public ShortestUsageMark(ShortestUsageMark shortestUsageMark, String string, int n, ClassFile classFile) {
        this(shortestUsageMark, string, n, classFile, null);
    }

    public ShortestUsageMark(ShortestUsageMark shortestUsageMark, String string, int n, ClassFile classFile, MethodInfo methodInfo) {
        this.certain = true;
        this.reason = string;
        this.depth = shortestUsageMark.depth + n;
        this.classFile = classFile;
        this.methodInfo = methodInfo;
    }

    public ShortestUsageMark(ShortestUsageMark shortestUsageMark, boolean bl) {
        this.certain = bl;
        this.reason = shortestUsageMark.reason;
        this.depth = shortestUsageMark.depth;
        this.classFile = shortestUsageMark.classFile;
        this.methodInfo = shortestUsageMark.methodInfo;
    }

    public boolean isCertain() {
        return this.certain;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isShorter(ShortestUsageMark shortestUsageMark) {
        return this.depth < shortestUsageMark.depth;
    }

    public boolean isCausedBy(ClassFile classFile) {
        return classFile.equals(this.classFile);
    }

    public void acceptClassFileVisitor(ClassFileVisitor classFileVisitor) {
        if (this.classFile != null && this.methodInfo == null) {
            this.classFile.accept(classFileVisitor);
        }
    }

    public void acceptMethodInfoVisitor(MemberInfoVisitor memberInfoVisitor) {
        if (this.classFile != null && this.methodInfo != null) {
            this.methodInfo.accept(this.classFile, memberInfoVisitor);
        }
    }

    public String toString() {
        return "certain=" + this.certain + ", depth=" + this.depth + ": " + this.reason + (this.classFile != null ? this.classFile.getName() : "(none)") + ": " + (this.methodInfo != null ? this.methodInfo.getName(this.classFile) : "(none)");
    }
}

