/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintStream;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.ShortestUsageMarker;

public class ShortestUsagePrinter
implements ClassFileVisitor,
MemberInfoVisitor {
    private ShortestUsageMarker shortestUsageMarker;
    private boolean verbose;
    private PrintStream ps;

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker) {
        this(shortestUsageMarker, true);
    }

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean bl) {
        this(shortestUsageMarker, bl, System.out);
    }

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean bl, PrintStream printStream) {
        this.shortestUsageMarker = shortestUsageMarker;
        this.verbose = bl;
        this.ps = printStream;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.ps.println(ClassUtil.externalClassName(programClassFile.getName()));
        this.printReason(programClassFile);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        this.ps.println(ClassUtil.externalClassName(libraryClassFile.getName()));
        this.ps.println("  is a library class.\n");
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        String string = programFieldInfo.getName(programClassFile);
        String string2 = programFieldInfo.getDescriptor(programClassFile);
        this.ps.println(ClassUtil.externalClassName(programClassFile.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, string, string2) : "." + string) + ShortestUsagePrinter.lineNumberRange(programClassFile, programFieldInfo));
        this.printReason(programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        String string = programMethodInfo.getName(programClassFile);
        String string2 = programMethodInfo.getDescriptor(programClassFile);
        this.ps.println(ClassUtil.externalClassName(programClassFile.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(programClassFile.getName(), 0, string, string2) : "." + string) + ShortestUsagePrinter.lineNumberRange(programClassFile, programMethodInfo));
        this.printReason(programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        String string = libraryFieldInfo.getName(libraryClassFile);
        String string2 = libraryFieldInfo.getDescriptor(libraryClassFile);
        this.ps.println(ClassUtil.externalClassName(libraryClassFile.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, string, string2) : "." + string));
        this.ps.println("  is a library field.\n");
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        String string = libraryMethodInfo.getName(libraryClassFile);
        String string2 = libraryMethodInfo.getDescriptor(libraryClassFile);
        this.ps.println(ClassUtil.externalClassName(libraryClassFile.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(libraryClassFile.getName(), 0, string, string2) : "." + string));
        this.ps.println("  is a library method.\n");
    }

    private void printReason(VisitorAccepter visitorAccepter) {
        if (this.shortestUsageMarker.isUsed(visitorAccepter)) {
            ShortestUsageMark shortestUsageMark = this.shortestUsageMarker.getShortestUsageMark(visitorAccepter);
            this.ps.print("  " + shortestUsageMark.getReason());
            shortestUsageMark.acceptClassFileVisitor(this);
            shortestUsageMark.acceptMethodInfoVisitor(this);
        } else {
            this.ps.println("  is not being kept.\n");
        }
    }

    private static String lineNumberRange(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        String string = programMemberInfo.getLineNumberRange(programClassFile);
        return string != null ? " (" + string + ")" : "";
    }
}

