/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.RefCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.InnerClassesInfoVisitor;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class UsageMarker
implements ClassFileVisitor,
MemberInfoVisitor,
CpInfoVisitor,
AttrInfoVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor,
InstructionVisitor {
    private static final Object POSSIBLY_USED = new Object();
    private static final Object USED = new Object();
    private MyInterfaceUsageMarker interfaceUsageMarker = new MyInterfaceUsageMarker();
    private MyPossiblyUsedMethodUsageMarker possiblyUsedMethodUsageMarker = new MyPossiblyUsedMethodUsageMarker();

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if (this.shouldBeMarkedAsUsed(programClassFile)) {
            this.markAsUsed(programClassFile);
            this.markProgramClassBody(programClassFile);
        }
    }

    protected void markProgramClassBody(ProgramClassFile programClassFile) {
        this.markCpEntry(programClassFile, programClassFile.u2thisClass);
        if (programClassFile.u2superClass != 0) {
            this.markCpEntry(programClassFile, programClassFile.u2superClass);
        }
        programClassFile.hierarchyAccept(false, false, true, false, this.interfaceUsageMarker);
        programClassFile.methodAccept("<clinit>", "()V", this);
        programClassFile.methodAccept("<init>", "()V", this);
        programClassFile.methodsAccept(this.possiblyUsedMethodUsageMarker);
        programClassFile.attributesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        if (this.shouldBeMarkedAsUsed(libraryClassFile)) {
            ClassFile[] classFileArray;
            this.markAsUsed(libraryClassFile);
            ClassFile classFile = libraryClassFile.superClass;
            if (classFile != null) {
                classFile.accept(this);
            }
            if ((classFileArray = libraryClassFile.interfaceClasses) != null) {
                for (int i = 0; i < classFileArray.length; ++i) {
                    if (classFileArray[i] == null) continue;
                    classFileArray[i].accept(this);
                }
            }
            libraryClassFile.methodsAccept(this);
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (this.shouldBeMarkedAsUsed(programFieldInfo)) {
            this.markAsUsed(programFieldInfo);
            this.markCpEntry(programClassFile, programFieldInfo.u2nameIndex);
            this.markCpEntry(programClassFile, programFieldInfo.u2descriptorIndex);
            programFieldInfo.attributesAccept(programClassFile, this);
            programFieldInfo.referencedClassesAccept(this);
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (this.shouldBeMarkedAsUsed(programMethodInfo)) {
            if (this.isUsed(programClassFile)) {
                this.markAsUsed(programMethodInfo);
                this.markProgramMethodBody(programClassFile, programMethodInfo);
                this.markMethodHierarchy(programClassFile, programMethodInfo);
            } else if (this.shouldBeMarkedAsPossiblyUsed(programMethodInfo)) {
                this.markAsPossiblyUsed(programMethodInfo);
                this.markMethodHierarchy(programClassFile, programMethodInfo);
            }
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        if (this.shouldBeMarkedAsUsed(libraryMethodInfo)) {
            this.markAsUsed(libraryMethodInfo);
            this.markMethodHierarchy(libraryClassFile, libraryMethodInfo);
        }
    }

    protected void markProgramMethodBody(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.markCpEntry(programClassFile, programMethodInfo.u2nameIndex);
        this.markCpEntry(programClassFile, programMethodInfo.u2descriptorIndex);
        programMethodInfo.attributesAccept(programClassFile, this);
        programMethodInfo.referencedClassesAccept(this);
    }

    protected void markMethodHierarchy(ClassFile classFile, MethodInfo methodInfo) {
        classFile.methodImplementationsAccept(methodInfo, false, this);
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
        if (this.shouldBeMarkedAsUsed(integerCpInfo)) {
            this.markAsUsed(integerCpInfo);
        }
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
        if (this.shouldBeMarkedAsUsed(longCpInfo)) {
            this.markAsUsed(longCpInfo);
        }
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
        if (this.shouldBeMarkedAsUsed(floatCpInfo)) {
            this.markAsUsed(floatCpInfo);
        }
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
        if (this.shouldBeMarkedAsUsed(doubleCpInfo)) {
            this.markAsUsed(doubleCpInfo);
        }
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        if (this.shouldBeMarkedAsUsed(stringCpInfo)) {
            this.markAsUsed(stringCpInfo);
            this.markCpEntry(classFile, stringCpInfo.u2stringIndex);
            stringCpInfo.referencedClassAccept(this);
        }
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
        if (this.shouldBeMarkedAsUsed(utf8CpInfo)) {
            this.markAsUsed(utf8CpInfo);
        }
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        this.visitRefCpInfo(classFile, fieldrefCpInfo);
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        this.visitRefCpInfo(classFile, interfaceMethodrefCpInfo);
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.visitRefCpInfo(classFile, methodrefCpInfo);
    }

    private void visitRefCpInfo(ClassFile classFile, RefCpInfo refCpInfo) {
        if (this.shouldBeMarkedAsUsed(refCpInfo)) {
            this.markAsUsed(refCpInfo);
            this.markCpEntry(classFile, refCpInfo.u2classIndex);
            this.markCpEntry(classFile, refCpInfo.u2nameAndTypeIndex);
            refCpInfo.referencedClassAccept(this);
            refCpInfo.referencedMemberInfoAccept(this);
        }
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        if (this.shouldBeMarkedAsUsed(classCpInfo)) {
            this.markAsUsed(classCpInfo);
            this.markCpEntry(classFile, classCpInfo.u2nameIndex);
            classCpInfo.referencedClassAccept(this);
        }
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
        if (this.shouldBeMarkedAsUsed(nameAndTypeCpInfo)) {
            this.markAsUsed(nameAndTypeCpInfo);
            this.markCpEntry(classFile, nameAndTypeCpInfo.u2nameIndex);
            this.markCpEntry(classFile, nameAndTypeCpInfo.u2descriptorIndex);
        }
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
        this.markAsUsed(unknownAttrInfo);
        this.markCpEntry(classFile, unknownAttrInfo.u2attrNameIndex);
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
        innerClassesAttrInfo.innerClassEntriesAccept(classFile, this);
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        this.markAsUsed(enclosingMethodAttrInfo);
        this.markCpEntry(classFile, enclosingMethodAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, enclosingMethodAttrInfo.u2classIndex);
        if (enclosingMethodAttrInfo.u2nameAndTypeIndex != 0) {
            this.markCpEntry(classFile, enclosingMethodAttrInfo.u2nameAndTypeIndex);
        }
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
        this.markAsUsed(constantValueAttrInfo);
        this.markCpEntry(classFile, constantValueAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, constantValueAttrInfo.u2constantValueIndex);
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
        this.markAsUsed(exceptionsAttrInfo);
        this.markCpEntry(classFile, exceptionsAttrInfo.u2attrNameIndex);
        exceptionsAttrInfo.exceptionEntriesAccept((ProgramClassFile)classFile, this);
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        this.markAsUsed(codeAttrInfo);
        this.markCpEntry(classFile, codeAttrInfo.u2attrNameIndex);
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
        codeAttrInfo.attributesAccept(classFile, methodInfo, this);
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
        this.markAsUsed(lineNumberTableAttrInfo);
        this.markCpEntry(classFile, lineNumberTableAttrInfo.u2attrNameIndex);
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        this.markAsUsed(localVariableTableAttrInfo);
        this.markCpEntry(classFile, localVariableTableAttrInfo.u2attrNameIndex);
        localVariableTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        this.markAsUsed(localVariableTypeTableAttrInfo);
        this.markCpEntry(classFile, localVariableTypeTableAttrInfo.u2attrNameIndex);
        localVariableTypeTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
        this.markAsUsed(sourceFileAttrInfo);
        this.markCpEntry(classFile, sourceFileAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, sourceFileAttrInfo.u2sourceFileIndex);
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
        this.markAsUsed(sourceDirAttrInfo);
        this.markCpEntry(classFile, sourceDirAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, sourceDirAttrInfo.u2sourceDirIndex);
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
        this.markAsUsed(deprecatedAttrInfo);
        this.markCpEntry(classFile, deprecatedAttrInfo.u2attrNameIndex);
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
        this.markAsUsed(syntheticAttrInfo);
        this.markCpEntry(classFile, syntheticAttrInfo.u2attrNameIndex);
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        this.markAsUsed(signatureAttrInfo);
        this.markCpEntry(classFile, signatureAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, signatureAttrInfo.u2signatureIndex);
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        this.markAsUsed(runtimeVisibleAnnotationsAttrInfo);
        this.markCpEntry(classFile, runtimeVisibleAnnotationsAttrInfo.u2attrNameIndex);
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        this.markAsUsed(runtimeInvisibleAnnotationsAttrInfo);
        this.markCpEntry(classFile, runtimeInvisibleAnnotationsAttrInfo.u2attrNameIndex);
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        this.markAsUsed(runtimeVisibleParameterAnnotationsAttrInfo);
        this.markCpEntry(classFile, runtimeVisibleParameterAnnotationsAttrInfo.u2attrNameIndex);
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        this.markAsUsed(runtimeInvisibleParameterAnnotationsAttrInfo);
        this.markCpEntry(classFile, runtimeInvisibleParameterAnnotationsAttrInfo.u2attrNameIndex);
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        this.markAsUsed(annotationDefaultAttrInfo);
        this.markCpEntry(classFile, annotationDefaultAttrInfo.u2attrNameIndex);
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        this.markAsUsed(exceptionInfo);
        if (exceptionInfo.u2catchType != 0) {
            this.markCpEntry(classFile, exceptionInfo.u2catchType);
        }
    }

    public void visitInnerClassesInfo(ClassFile classFile, InnerClassesInfo innerClassesInfo) {
        if (innerClassesInfo.u2innerClassInfoIndex == 0 && classFile.getName().equals(classFile.getCpClassNameString(innerClassesInfo.u2innerClassInfoIndex))) {
            this.markAsUsed(innerClassesInfo);
            if (innerClassesInfo.u2innerClassInfoIndex != 0) {
                this.markCpEntry(classFile, innerClassesInfo.u2innerClassInfoIndex);
            }
            if (innerClassesInfo.u2outerClassInfoIndex != 0) {
                this.markCpEntry(classFile, innerClassesInfo.u2outerClassInfoIndex);
            }
            if (innerClassesInfo.u2innerNameIndex != 0) {
                this.markCpEntry(classFile, innerClassesInfo.u2innerNameIndex);
            }
        }
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        this.markCpEntry(classFile, localVariableInfo.u2nameIndex);
        this.markCpEntry(classFile, localVariableInfo.u2descriptorIndex);
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        this.markCpEntry(classFile, localVariableTypeInfo.u2nameIndex);
        this.markCpEntry(classFile, localVariableTypeInfo.u2signatureIndex);
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        this.markCpEntry(classFile, annotation.u2typeIndex);
        annotation.referencedClassFileAccept(this);
        annotation.elementValuesAccept(classFile, this);
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
        if (constantElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, constantElementValue.u2elementName);
            constantElementValue.referencedMethodInfoAccept(this);
        }
        this.markCpEntry(classFile, constantElementValue.u2constantValueIndex);
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        if (enumConstantElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, enumConstantElementValue.u2elementName);
            enumConstantElementValue.referencedMethodInfoAccept(this);
        }
        this.markCpEntry(classFile, enumConstantElementValue.u2typeNameIndex);
        this.markCpEntry(classFile, enumConstantElementValue.u2constantNameIndex);
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        if (classElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, classElementValue.u2elementName);
            classElementValue.referencedMethodInfoAccept(this);
        }
        this.markCpEntry(classFile, classElementValue.u2classInfoIndex);
        classElementValue.referencedClassesAccept(this);
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        if (annotationElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, annotationElementValue.u2elementName);
            annotationElementValue.referencedMethodInfoAccept(this);
        }
        annotationElementValue.annotationAccept(classFile, this);
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        if (arrayElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, arrayElementValue.u2elementName);
            arrayElementValue.referencedMethodInfoAccept(this);
        }
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        this.markCpEntry(classFile, cpInstruction.cpIndex);
    }

    protected void markAsUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(USED);
    }

    protected boolean shouldBeMarkedAsUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() != USED;
    }

    protected boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == USED;
    }

    protected void markAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(POSSIBLY_USED);
    }

    protected boolean shouldBeMarkedAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() != USED && visitorAccepter.getVisitorInfo() != POSSIBLY_USED;
    }

    protected boolean isPossiblyUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == POSSIBLY_USED;
    }

    protected void markAsUnused(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(null);
    }

    private void markCpEntry(ClassFile classFile, int n) {
        classFile.constantPoolEntryAccept(n, this);
    }

    private class MyPossiblyUsedMethodUsageMarker
    implements MemberInfoVisitor {
        private MyPossiblyUsedMethodUsageMarker() {
        }

        public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        }

        public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
            if (UsageMarker.this.isPossiblyUsed(programMethodInfo)) {
                UsageMarker.this.markAsUsed(programMethodInfo);
                UsageMarker.this.markProgramMethodBody(programClassFile, programMethodInfo);
            }
        }

        public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        }

        public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        }
    }

    private class MyInterfaceUsageMarker
    implements ClassFileVisitor {
        private MyInterfaceUsageMarker() {
        }

        public void visitProgramClassFile(ProgramClassFile programClassFile) {
            if (UsageMarker.this.shouldBeMarkedAsPossiblyUsed(programClassFile)) {
                UsageMarker.this.markAsPossiblyUsed(programClassFile);
            }
        }

        public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
            UsageMarker.this.visitLibraryClassFile(libraryClassFile);
        }
    }
}

