/*
    FileOperationPreferences.m

    Implementation of the FileOperationPreferences class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "FileOperationPreferences.h"

#import <Foundation/NSString.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSBundle.h>

#import <AppKit/NSNibLoading.h>
#import <AppKit/NSButton.h>

@implementation FileOperationPreferences

+ (NSString *) name
{
  return _(@"File Operations");
}

- (void) dealloc
{
  TEST_RELEASE(view);

  [super dealloc];
}

- (void) awakeFromNib
{
  NSUserDefaults * df = [NSUserDefaults standardUserDefaults];

  [view retain];
  [view removeFromSuperview];
  DESTROY(bogusWindow);

  [askWhenCopying setState: ![df boolForKey: @"DontAskWhenCopying"]];
  [askWhenMoving setState: ![df boolForKey: @"DontAskWhenMoving"]];
  [askWhenLinking setState: ![df boolForKey: @"DontAskWhenLinking"]];
}

- (NSView *) view
{
  if (view == nil)
    {
      [NSBundle loadNibNamed: @"FileOperations" owner: self];
    }

  return view;
}

- (void) changeCopying: sender
{
  [[NSUserDefaults standardUserDefaults]
    setBool: ![sender state] forKey: @"DontAskWhenCopying"];
}

- (void) changeMoving: sender
{
  [[NSUserDefaults standardUserDefaults]
    setBool: ![sender state] forKey: @"DontAskWhenMoving"];
}

- (void) changeLinking: sender
{
  [[NSUserDefaults standardUserDefaults]
    setBool: ![sender state] forKey: @"DontAskWhenLinking"];
}

@end
