/***************************************************************************
                          job_modifyfavourite.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_modifyfavourite.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

#ifdef EMBEDDED 
  #include <mysql.h>
#endif

Job_ModifyFavourite::Job_ModifyFavourite(int _id, bool _state)
  : id(_id), state(_state)
{}

void Job_ModifyFavourite::run()
{
  int error;

  if (verbose==8) qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

#ifdef EMBEDDED 
  mysql_thread_init(); 
#endif
  database->lock();
  app->lock();

  database->modifyFavouriteArtist(id, state);

  datadispatcher->eventNewFavouritesBasis(database->getFavouritesBasis());

  error = database->getError();

  app->unlock();
  database->unlock();

  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
#ifdef EMBEDDED 
  mysql_thread_end(); 
#endif

  if (verbose==8) qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

  exit();
}

Job_ModifyFavourite::~Job_ModifyFavourite() {}
