/***************************************************************************
                          mextras_log.h  -  description
                             -------------------
    begin                : 24 April 2004
    copyright            : (C) 2004 by Paul-henri Ferme
    email                : paul-henri.ferme@noos.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <qlayout.h>
#include <qvbox.h>
#include <qmessagebox.h>
#include <qregexp.h>

#include "mextras_log.h"

const char* MUSICEXTRAS_LOG="/.musicextras/debug.log";

MextrasLog::MextrasLog(QWidget *parent, const char *name): QDialog(parent, name)
{
  resize( 600, 400 );
  
  QGridLayout *grid = new QGridLayout(this, 2, 2);
    
  text = new QTextEdit(this);
  text->setTextFormat( Qt::LogText );
  //  text->setMaxLogLines ( 1000 );

  but1 = new QPushButton(_("Delete Musicextras Logfile"), this);
  but2 = new QPushButton(_("Close Window"), this);

  grid->addMultiCellWidget(text, 0, 0, 0, 1);
  grid->addWidget(but1, 1, 0);
  grid->addWidget(but2, 1, 1);

  connect(but1, SIGNAL(clicked()),
          this, SLOT(actionnuke()));
  connect(but2, SIGNAL(clicked()),
          this, SLOT(reject()));

  proc = new QProcess( this );
  proc->setCommunication(QProcess::Stdout|QProcess::Stderr|QProcess::DupStderr);
  proc->addArgument( "tail" );
  proc->addArgument( "-n300" );
  proc->addArgument( "-f" );
  proc->addArgument( QDir::home().path() + MUSICEXTRAS_LOG );

  connect( proc, SIGNAL(readyReadStdout()),
	   this, SLOT(readFromStdout()) );

  proc->start();
}

void MextrasLog::actionnuke() {

  QFile logfile( QDir::home().path() + MUSICEXTRAS_LOG );

  qApp->lock();
  int userResponse =  QMessageBox::warning(NULL, 
				  "Musicextras",
				  _("OK to erase Musicextras log file?")
				  ,QMessageBox::Yes, QMessageBox::No);
  qApp->unlock();

  if ( userResponse == QMessageBox::Yes ) {
    bool OK = logfile.remove() && logfile.open(IO_ReadWrite); // recreate an empty log file
    if ( !OK) {
      qApp->lock();
      QMessageBox::critical(NULL, 
			    "Musicextras",
			    _("Cannot empty Musicextras log file....")
			    );
      qApp->unlock();
    } else   {
      logfile.close();
      text->clear();
      proc->kill();
      proc->start();
    }
  }
}

void MextrasLog::reject() {
  proc->kill();
  delete proc;
  QDialog::reject();
}


void MextrasLog::readFromStdout() {

  QByteArray input=proc->readStdout();

  // let's colorize our log a little bit....
  
  QRegExp rx("(Running as:[^\n]*)"); 
  QString line = input;
  line.replace( rx, "<font color=green>\\1<\\green>");

  rx.setPattern("(Program Exiting[^\n]*)"); 
  line.replace( rx, "<font color=green>\\1<\\green>");

  rx.setPattern("(retrieve_data successful[^\n]*)"); 
  line.replace( rx, "<font color=blue>\\1<\\blue>");

  text->append( line );
  text->scrollToBottom();
}

MextrasLog::~MextrasLog() {
}
