/***************************************************************************
                 job_callmusicextras.cpp  -  description
                             -------------------
    begin                : Wed Jan 7 2004
    copyright            : (C) 2003 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>
#include <qxml.h>
#include <iostream>
#include <exception>
#include <qtimer.h>

#include "musicextraswrapper.h"
#include "qmdcodec.h"
#include "job_callmusicextras.h"
#include "gui_playlist.h"
#include "gui.h"

using namespace std;

MusicextrasWrapper::MusicextrasWrapper():Track(NULL),terminated(false) {
  proc=NULL;
}

MusicextrasWrapper::~MusicextrasWrapper() {
}

EXTRADATA* MusicextrasWrapper::get(TRACK* track, EXTRA_STATUS status)
{
  if (verbose == 7)
    qWarning( "MusicextrasWrapper::get(TRACK* track) begins");

  extraData = new EXTRADATA();
  Track = track;

  //some more logging....
 
  log_gui("===searching for====");
  log_gui("<b>" + track->artist);
  log_gui(track->album);
  log_gui(track->title + "</b>");

  // search only if user enables fetcher and no info in prokyon database.
  // logic inverted, true =  no search
  status.artist = status.artist || !config->getcheckartist();
  status.cover = status.cover || !config->getcheckcover();
  status.lyrics = status.lyrics || !config->getchecklyrics();
  status.album_review = status.album_review || !config->getcheckalbum();
  status.album_tracks = status.album_tracks || !config->getchecktracks();
  status.biography = status.biography || !config->getcheckbiography();
  status.years_active = status.years_active || !config->getcheckyears();

  if ( !status.artist)
    log_gui(" Search artist image ...");
  if ( !status.cover)
    log_gui(" Search cover image ...");
  if ( !status.lyrics)
    log_gui(" Search lyrics ...");
  if ( !status.years_active)
    log_gui(" Search years active ...");
  if ( !status.album_review)
    log_gui(" Search album review ...");
  if ( !status.album_tracks)
    log_gui(" Search album tracks ...");
  if ( !status.biography)
    log_gui(" Search biography ...");

  // nothing to fetch. we are done.

  if ( status.artist && status.cover && status.lyrics && status.years_active && status.album_review && status.album_tracks && status.biography) {
    if (verbose == 7) qWarning("nothing to do");
    return extraData;
  };

  // if there is no info on the track it doesn't make any sense to start musicextras
  if ( track->artist.stripWhiteSpace().isEmpty() && 
       track->album.stripWhiteSpace().isEmpty() && 
       track->title.stripWhiteSpace().isEmpty() ) {
    if (verbose == 7) qWarning("got only empty track info, skipping musicextra lookup.");
    return extraData;
  };
 
  proc = new QProcess( QString("musicextras"), this );
  // if tag comment include TESTMUSICEXTRAS , run all comment as signle argument to musicextras.
  if ( track->comment.find( TESTMUSICEXTRAS)   != 0 ) {
    if (!track->artist.stripWhiteSpace().isEmpty()) proc->addArgument( "-a" + track->artist );
    if (!track->album.stripWhiteSpace().isEmpty())  proc->addArgument( "-l" + track->album );
    if (!track->title.stripWhiteSpace().isEmpty())  proc->addArgument( "-t" + track->title );
    QString st1 = QString(status.lyrics ? "":"lyrics,") + QString(status.artist ? "":"artist_image,") 
      + QString(status.cover ? "":"album_cover,") + QString(status.years_active ? "":"years_active,")
      + QString(status.album_review ? "":"album_review,") + QString(status.album_tracks ? "":"album_tracks,")
      + QString(status.biography ? "":"biography,");
    st1.truncate(st1.length()-1);  // remove trailing ","
    if(verbose == 9) qWarning("execute musicextras to look for: %s", st1.local8Bit().data());
    proc->addArgument( "-i" + st1 );
    proc->addArgument("-s");
  } else {
    QString ss(track->comment.right( track->comment.length() - strlen( TESTMUSICEXTRAS )));
    QStringList st = QStringList::split(ss[0], ss);
    for ( QStringList::Iterator it = st.begin(); it != st.end(); ++it )
      proc->addArgument( ("-" + *it).stripWhiteSpace() );
  }

  connect( proc, SIGNAL(readyReadStdout()),
  	   this, SLOT(slot_readFromStdout()) );
  connect( proc, SIGNAL(readyReadStderr()),
  	   this, SLOT(slot_readFromStderr()) );

  qApp->lock();
  bool  procres = proc->start();
  qApp->unlock();

  if (verbose == 7) {
    QStringList list = proc->arguments();
    QStringList::Iterator it = list.begin();
    while( it != list.end() ) {
      cout << (*it).local8Bit().data() << " ";
      ++it;
    }
    cout << endl;
    qWarning( "launched PID:%i success:%i",  proc->processIdentifier(), procres );
  }

  if ( !procres )
    {
	log_gui( QString( _("Could not find  \"musicextras\".\n"
			    "Please install from http://kapheine.hypa.net/musicextras.\n"
			    "And make sure it is in your $PATH" )) ,Qt::red);
    }
  else
    {   
      bool procrun = true;
      while ( procrun  && !terminated) {
	if (verbose == 7)
	  qWarning( "PID:%i goes to sleep", proc->processIdentifier());
	// time to sleep... 10ms slot min 
	Job_CallMusicextras::JobSleep(10);
	if (verbose == 7)
	  qWarning( "PID:%i wakes up", proc->processIdentifier());
	qApp->lock();
	procrun = proc ? proc->isRunning() : false;
	qApp->unlock();
      }

      if ( proc && !proc->normalExit() && !terminated )
 	{
 	  log_gui( QString(_("Fatal Musicextras error!\n"
 			     "May be a version incompatibility?\nError:\n%1\n")).arg(qsxmlerr), Qt::red);
 	}

      if ( !terminated) 
	if ( proc && proc->exitStatus() ) 
	  {
	    log_gui(  QString(QString(_("Fatal Musicextras error!\n")) +
			      QString(_("Error")) + ": %1\n%2\n").arg(proc->exitStatus()).arg(qsxmlerr), Qt::red);
	  } else 
	    // We are calling directly the xmlparser rather than relying on signal processExited().
	    // The later  does not seem to work reliably when qProcess is called from a qThread.... 
	    parseXML();
    }

  if (terminated) {
    /**************************************
       This tries to terminate the process the nice way. If the process is still running after 5 seconds, 
       it terminates the process the hard way. The timeout should be chosen depending on the time the process 
       needs to do all its cleanup: use a higher value if the process is likely to do a lot of computation or I/O on cleanup. 
    ****************************************/
    if (proc && proc->isRunning()) {
      proc->tryTerminate();
      QTimer::singleShot( 5000, proc, SLOT( kill() ) );
      log_gui(_("terminating  Musicextras...."));
      proc = 0;
    }
  }

  if (verbose == 7)
    qWarning( "MusicextrasWrapper::get(TRACK* track) ends... with PID:%i", proc->processIdentifier ());
  return extraData;
}

void MusicextrasWrapper::slot_readFromStdout()
{
  if (verbose == 7)
    qWarning( "MusicextrasWrapper::slot_readFromStdout() starts... with PID:%i", proc->processIdentifier ());

  if (proc)   {
    QString temp(proc->readStdout());
    qsxml = qsxml + temp;
  }
  if (verbose == 7) {
    qWarning("qsxml size: %d", qsxml.length());
    qWarning( "MusicextrasWrapper::slot_readFromStdout() ends... with PID:%i", proc->processIdentifier ());
  }
}

void MusicextrasWrapper::slot_readFromStderr()
{
  if (verbose == 7)
    qWarning( "MusicextrasWrapper::slot_readFromStderr() starts... with PID:%i", proc->processIdentifier ());

  if (proc)   {
    QString temp(proc->readStderr());
    qsxmlerr = qsxmlerr + temp;
  }

  if (verbose == 7) {
    qWarning("qsxmlerr size: %d", qsxmlerr.length());
    if (!qsxmlerr.isEmpty()) qWarning( qsxmlerr.local8Bit().data() );
    qWarning( "MusicextrasWrapper::slot_readFromStderr() ends... with PID:%i", proc->processIdentifier ());
  }
}



void MusicextrasWrapper::parseXML()
{
  if (verbose == 7) {
    qWarning("qsxml size: %d", qsxml.length());
	qWarning("%s", qsxml.local8Bit().data());
  }
   
  MusicextrasHandler handler;
  handler.setLogger(this);
  handler.setExtraData(extraData);
  handler.setTrack(Track);
  QXmlInputSource source;
  source.setData(qsxml);
  QXmlSimpleReader reader;
  reader.setContentHandler( &handler );
  reader.parse( source );
}


/*
void MusicextrasWrapper::strip_nondata_xml(  QCString& s) {
  // strip char generating an xml parser exception
  // this a temporary work around as musicextras should only return valid Xml char
  // see http://www.w3.org/TR/REC-xml/#NT-Char
  // also note the defaut encoding for xml parser is UTF-8 
  // non valid UTF-8 encoded char will also stop parsing
  for ( int i = 0; i < s.length(); i++)
    if ( s[i]< 0x20 && s[i] != 0x09 && s[i] != 0x0a && s[i] != 0x0d )
      s[i]= 'X';
}
*/

void MusicextrasWrapper::log_gui(QString ss, QColor col) 
  //post an event to main GUI event loop for log display.
{
  if (col == Qt::blue)  
    ss = "<font color=blue>" + ss +"</font>";
  else if   (col == Qt::red) 
    ss = "<font color=red>" + ss +"</font>";
  else if (col == Qt::green)  
    ss = "<font color=green>" + ss +"</font>";

  LogEvent* le = new LogEvent(ss);
  QApplication::postEvent( gui->getPlaylisting(), le );  // Qt will delete event  when done

};

void MusicextrasHandler::setExtraData( EXTRADATA *data )
{
    extraData = data;
}

void MusicextrasHandler::setTrack( TRACK *track )
{
    Track = track;
}

void MusicextrasHandler::setLogger( MusicextrasWrapper *object )
{
    logger = object;
}

bool MusicextrasHandler::startElement( const QString&, const QString&,
                                    const QString& qName,
                                    const QXmlAttributes& )
{
    if (verbose == 7) { qWarning(qName.latin1()); }
    currentTag = qName;
    return TRUE;
}

bool MusicextrasHandler::endElement( const QString&, const QString&, const QString& )
{
    currentTag = "";
    return TRUE;
}

bool MusicextrasHandler::characters( const QString& content)
{
	if(QString::compare("artist_image", currentTag) == 0) {
	    QByteArray out;
	    QCodecs::base64Decode(static_cast <QByteArray> (content.local8Bit()), out);
	    extraData->artist_image = out;
	    extraData->artist_image.detach();
	    if (!extraData->artist_image.isNull())
            logger->log_gui(QString(_("image \"%1\": OK")).arg(Track->artist), Qt::blue);
	    else
	       logger->log_gui(QString(_("image \"%1\": empty")).arg(Track->artist));
	}
	else if(QString::compare("album_cover", currentTag) == 0) {
	    QByteArray out;
	    QCodecs::base64Decode(static_cast <QByteArray> (content.local8Bit()), out);
        extraData->cover_image = out;
        extraData->cover_image.detach();
        if (!extraData->cover_image.isNull())
            logger->log_gui(QString(_("cover \"%1:%2\":OK")).arg(Track->artist).arg(Track->album), Qt::blue);
        else
            logger->log_gui(QString(_("cover \"%1:%2\":empty")).arg(Track->artist).arg(Track->album));
    }
    else if(QString::compare("album_tracks", currentTag) == 0) {
        extraData->album_tracks = content;
        if ( !album_tracks_isEmpty( extraData->album_tracks ) ) 
            logger->log_gui(QString(_("Album tracks \"%1:%2\":OK")).arg(Track->artist).arg(Track->album), Qt::blue);
       else
            logger->log_gui(QString(_("Album tracks \"%1:%2\":empty")).arg(Track->artist).arg(Track->album));
    }
    else if(QString::compare("album_review", currentTag) == 0) {
        extraData->album_review = content;
        if ( !album_review_isEmpty( extraData->album_review ) ) 
            logger->log_gui(QString(_("Album review \"%1:%2\":OK")).arg(Track->artist).arg(Track->album), Qt::blue);
       else
            logger->log_gui(QString(_("Album review \"%1:%2\":empty")).arg(Track->artist).arg(Track->album));
    }
    else if(QString::compare("lyrics", currentTag) == 0) {
        extraData->lyrics = content;
	    if ( !lyrics_isEmpty( extraData->lyrics ) ) 
           logger->log_gui(QString(_("Lyrics \"%1:%2\":OK")).arg(Track->artist).arg(Track->title), Qt::blue);
	    else
           logger->log_gui(QString(_("Lyrics \"%1:%2\":empty")).arg(Track->artist).arg(Track->title));
    }
    else if(QString::compare("years_active", currentTag) == 0) {
        extraData->years_active = content;
        if ( !years_active_isEmpty( extraData->years_active ) ) 
            logger->log_gui(QString(_("Years active \"%1\":OK")).arg(Track->artist), Qt::blue);
        else
            logger->log_gui(QString(_("Years active \"%1\":empty")).arg(Track->artist));
    }
    else if(QString::compare("biography", currentTag) == 0) {
        extraData->biography = content;
        if ( !biography_isEmpty( extraData->biography ) ) 
            logger->log_gui(QString(_("Biography \"%1\":OK")).arg(Track->artist), Qt::blue);
        else
            logger->log_gui(QString(_("Biography \"%1\":empty")).arg(Track->artist));
    }

    return TRUE;
}

