/**
 ** Simplistic terminal emulator
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under GNU General Public License.
 **/

#include "vconsole.h"

#include "hconsole.h"

static void vcon_i_cursfeed(struct vconterm *t);
static void vcon_i_backflush(struct vconterm *t);

struct hconsole hcons0;

int vcon_init(struct vconterm *t, unsigned int a0)
{
	struct hconsole *hconp;

	hconp = &hcons0;	/* XXX We have no malloc() */
	if (hcon_init(hconp, a0) != 0) {
		return -1;
	}
	t->impl = hconp;

	t->vc_x = 0;    t->vc_y = 0;
	t->backp = 0;    t->backc = 0;

	hcon_clear(hconp, 0, 0, hconp->ydim_, hconp->xdim_);
	return 0;
}

int vcon_write(struct vconterm *t, char *data, int leng)
{
	int l = leng;
	struct hconsole *hconp = t->impl;
	char c;

	for (;;) {
		if (l <= 0) break;
		c = *data++;    --l;

		switch (c) {
		case 0x07:		/* Bell */
			vcon_i_backflush(t);
			break;
		case 0x0A:		/* Linefeed */
			vcon_i_backflush(t);
			vcon_i_cursfeed(t);
			break;
		case 0x0D:		/* Return */
			vcon_i_backflush(t);
			t->vc_x = 0;
			break;
		default:
			if (t->backp == 0) {
				t->backc = 1;
				t->backp = data-1;
			} else {
				t->backc++;
			}
			if (t->vc_x + t->backc >= hcon_qxdim(hconp)) {
				vcon_i_backflush(t);
				t->vc_x = 0;
				vcon_i_cursfeed(t);
			}
		}
	}
	vcon_i_backflush(t);
	return leng - l;
}

static void vcon_i_cursfeed(struct vconterm *t) {
	struct hconsole *hconp = t->impl;

	if (++t->vc_y >= hcon_qydim(hconp)) {
		t->vc_y = hcon_qydim(hconp)-1;
		hcon_scroll(hconp, 0, hcon_qydim(hconp), SM_UP, 1);
	}
}

/*
 * Flush buffered printables. We do not change cursor position here.
 */
static void vcon_i_backflush(struct vconterm *t) {
	if (t->backp != 0 && t->backc != 0) {
		hcon_putcs(t->impl, t->backp, t->backc, t->vc_y, t->vc_x);
		t->vc_x += t->backc;
	}
	t->backp = 0;    t->backc = 0;
}

int vcon_putch(struct vconterm *t, char c)
{
	return -1;
}

int vcon_read(struct vconterm *t, char *data, int leng)
{
	return 0;
}

int vcon_getch(struct vconterm *t)
{
	return -1;
}

void vcon_fini(struct vconterm *t)
{
	/* violent crash in the end */
	;
}
