package AtomicData::Boolean;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Boolean.pm,v 1.1 2000/11/23 23:36:15 muaddib Exp $

use strict;

=head1 NAME

AtomicData::Boolean - boolean.

=head1 SYNOPSIS

see AtomicData.pm

=head1 DESCRIPTION

Implements data encapsulation for any arbitrary string of data.

=cut

use AtomicData::Text;
@AtomicData::Boolean::ISA = qw (AtomicData::Text);

=head1 METHODS

see AtomicData.pm for further methods.

=head2 parameters

see parent class, this package adds no parameters of its own

=head2 _canonicalize

 instance/private
 (int $value) _canonicalize (int $raw_value)

DESCRIPTION:

Will accept a value and return the canonical form or return undef and
set C<$this->{_can_failed}>.

=cut

sub _canonicalize {
  my ($this, $val) = @_;

  # perform text canonicalization.
  $val = $this->SUPER::_canonicalize($val);

  # blank is already canonical.
  $val eq "" and return $val;

  if      ($val =~ /^(1|true|on|good|yes|y)$/i) {
    $val = 1;
  } elsif ($val =~ /^(0|false|off|bad|no|n)$/i) {
    $val = 0;
  } else {
    $this->{_can_failed} = ['Unrecognized boolean string.'];
    return undef;
  }

  return $val;
}

=head2 _format

 instance/private
 (int $value) _format (int $can_value)

DESCRIPTION:

Will accept a value and return the canonical form or return undef and
set C<$this->{_can_failed}>.

=cut

sub _format {
  my ($this, $value) = @_;
  $value eq "" and return $value;
  return $value ? "true" : "false";
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
