package AtomicData::PAN;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: PAN.pm,v 1.1 2000/11/23 23:36:15 muaddib Exp $

use strict;

=head1 NAME

AtmoicData::PAN - data encapsulator for personoal account numbers

=head1 SYNOPSIS

see AtomicData.pm

=head1 DESCRIPTION

Implements data encapsulation for tax ID numbers. See
AtomicData.pm for further details.

=cut

use AtomicData::Integer;
@AtomicData::PAN::ISA = qw (AtomicData::Integer);

=head1 METHODS

see AtomicData.pm for further methods.

=head2 _canonicalize

 instance/private
 (int $value) _canonicalize (int $raw_value)

DESCRIPTION:

Will accept a value and return the cannonical form or undef and set
C<$this->{_can_failed}>.

=cut

sub _canonicalize {
  my ($this, $val) = @_;

  # remove the valid things that would break integer.
  $val =~ s/$AtomicData::deliminators//g;

  # we run canonical to get integer
  $val = $this->SUPER::_canonicalize($val);
  defined $val or return;

  if ($val && !($val =~ /^(\d{0,19})?/)) { #should be blank or 19 digits
    $this->{_can_failed} = ['Invalid PAN.'];
    return;
  }

  return $val;
}

=head2 verify

see root class for documentation; this is overidden to set
min/max_length properly.

=cut

sub _verify {
  my ($this, @args) = @_;
  
  $this->{_parameters}->{min_length} = 0;
  $this->{_parameters}->{max_length} = 19;

  return $this->SUPER::_verify(@args);
}

=head2 _format

 instance/private
 (string $tax_id) _format (int $value)

DESCRIPTION:

Will format per formatting options.

=cut

sub _format {
  my ($this, $value) = @_;

  return $value;
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
