package HTMLIO::TextArea;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: TextArea.pm,v 1.1 2000/11/23 23:36:16 muaddib Exp $

use strict;

=head1 NAME

HTMLIO::TextArea - for gathering and managing data through HTML text area boxes

=head1 SYNOPSIS

see HTMLIO

=head1 DESCRIPTION

see HTMLIO

=cut

use HTMLIO;
use HTMLIO::Utils qw(html_tag);

@HTMLIO::TextArea::ISA = qw(HTMLIO);

=head1 METHODS

see HTMLIO for further methods

=head2 html_input

 instance
 (string $html) html_input ([variable \@index, string $join])

DESCRIPTION:

Will return the appropriat HTML necessary to set up user input through
a text box. C<@index> specifies which data members (by index, see
C<HTMLIO> for ordering) to set for defualt or which keys to set for
default if this is constrained.*

*: This type does not support constraining here at this time

=cut

sub html_input {
  my ($this, $name, $data_obj, $slice, $join) = @_;

  $join ||= "\n";
  my $orig_attr = $this->attributes();
  my $data = [ $data_obj->value() ];

  # derive our data slice from $data and $slice.
  my $sliced_data;
  if ($slice) {
    $sliced_data = [];
    for my $index (@$slice) {
      if ($index > $#{$data} or !defined $data->[$index]) {
	push @$sliced_data, undef;
      } else {
	push @$sliced_data, $data->[$index];
      }
    }
    @$sliced_data or push @$sliced_data, "";
  } else {
    $sliced_data = @$data ? $data : [ "" ];
  }

  my @html;
  for my $data (@$sliced_data) {
    my %attr = %$orig_attr;
    $attr{name} = $name;
    $attr{value} = $data if defined $data;
    push @html, html_tag('textarea',\%attr,[qw(name value)])."</textarea>";
  }

  return join $join, @html;
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
