# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: Makefile.PL,v 1.6 2001/01/20 08:43:07 muaddib Exp $

require 5.004;
use strict;
use ExtUtils::MakeMaker;

my @MODULES = qw(
  FieldSpace.pm
  Generic.pm
  Session.pm
  SideMenu.pm
  Error.pm
  Error/Field.pm
  Error/Group.pm
  Error/Verify.pm
  FieldSpace/Ephemeral.pm
  FieldSpace/Group.pm
  FieldSpace/Propagation.pm
  Parser/FieldSpace.pm
  Parser/Group.pm
  Parser/Message.pm
  Parser/PreScan.pm
  Parser/Table.pm
);

my %PM = map { $_ => '$(INST_LIBDIR)/PSP/'.$_ } @MODULES;

WriteMakefile(
    'NAME'    => 'PSP-Tools',
    'VERSION' => '0.504',
    'PM'      => \%PM,
    'dist'    => { COMPRESS => 'gzip -9f', SUFFIX => 'gz' }
);

