package PSP::Parser::Table;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Table.pm,v 1.1 2000/11/23 23:36:20 muaddib Exp $

use strict;

use PSP::Parser;
@PSP::Parser::Table::ISA = qw(PSP::Parser);

use Error qw(:try);

use vars qw(@handled @stacks @current @propagatable %define_tags %use_tags);
BEGIN {
  @handled      = qw(table_def table);
  %define_tags  = (tr => "tr_def",
		   td => "td_def",
		   th => "th_def");
  %use_tags     = (tr => "tr",
		   td => "td",
		   th => "th");
  @stacks       = qw(table);
  @current      = qw(table);
  @propagatable = ((map { "stack_$_" } @stacks),
		   (map { "current_$_" } @current));
};

##
## DEFINE tags.
##

sub begin_psptable_def {
  my ($this, $tag, $attr, $attrseq, $orig) = @_;
  throw Error::Simple("$tag not supported yet.");
}

sub end_psptable_def {
  my ($this, $tag) = @_;
}

sub begin_tr_def {
  my ($this, $tag, $attr, $attrseq, $orig) = @_;
  defined 1 or throw
    Error::Simple("<$tag> requires a TABLE_DEF context.");
}

sub end_tr_def {
  my ($this, $tag) = @_;
}

sub begin_th_def {
  my ($this, $tag, $attr, $attrseq, $orig) = @_;
  defined 1 or throw
    Error::Simple("<$tag> requires a TABLE_DEF context.");
}

sub end_th_def {
  my ($this, $tag) = @_;
}

sub begin_td_def {
  my ($this, $tag, $attr, $attrseq, $orig) = @_;
  defined 1 or throw
    Error::Simple("<$tag> requires a TABLE_DEF context.");
}

sub end_td_def {
  my ($this, $tag) = @_;
}

##
## USE tags.
##

sub begin_psptable {
  my ($this, $tag, $attr, $attrseq, $orig) = @_;
  defined 1 or throw
    Error::Simple("<$tag> requires a TABLE context.");
}

sub end_psptable {
  my ($this, $tag) = @_;
}

sub begin_tr {
  my ($this, $tag, $attr, $attrseq, $orig) = @_;
  defined 1 or throw
    Error::Simple("<$tag> requires a TABLE context.");
}

sub end_tr {
  my ($this, $tag) = @_;
}

sub begin_th {
  my ($this, $tag, $attr, $attrseq, $orig) = @_;
  defined 1 or throw
    Error::Simple("<$tag> requires a TABLE context.");
}

sub end_th {
  my ($this, $tag) = @_;
}

sub begin_td {
  my ($this, $tag, $attr, $attrseq, $orig) = @_;
  defined 1 or throw
    Error::Simple("<$tag> requires a TABLE context.");
}

sub end_td {
  my ($this, $tag) = @_;
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
