## mainwindow.py
## 
## Copyright (C) 2005-2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import pygtk
pygtk.require('2.0')
import gtk
import gobject
import string
import os
import time
from os import system, getenv

import dialog
import options
import config
import threads
import monitor
import bookmarks
import groups 
import handlers
import pyNeighborhood

class MainWindow:

    #
    # close the window and quit
    #
    def delete_event(self):
        home = getenv("HOME")
        conflocation = string.join([home, "/.pyNeighborhood"], '')
        os.chdir(conflocation)
        gtk.main_quit()
        self.monitor_thr.quit = True
        os._exit(99)
        return False

    #
    # create a main menu
    #
    def get_main_menu(self, window):
        actions = gtk.ActionGroup("Actions")
        actions.add_actions(self.menu_entries)

        ui = gtk.UIManager()
        ui.insert_action_group(actions, 0)
        window.add_accel_group(ui.get_accel_group())
        try:
            mergeid = ui.add_ui_from_string(self.ui_info)
        except gobject.GError, msg:
            print "building menus failed: %s" % msg


        return ui
    
    #
    # global handlers
    #
    def delete_event_handler(self, widget, event, data=None):
        self.delete_event()

    def umount(self):
        #
        # It is really necessary to move this handler here -
        # because "monitor" and "bookmarks" objects are to be passed
        #
        treeselection = self.bookmarks.treeview.get_selection()
        (model, iter) = treeselection.get_selected()
        if iter != None and self.notebook.get_current_page() == 0:
            thr = threads.Umount_Thread(self.notebook, 
                                        self.treeview, 
                                        self.treestore, 
                                        self.treeview_mon, 
                                        self.treestore_mon,
                                        self.treeview_groups,
                                        self.treestore_groups)
            thr.start()

        if self.notebook.get_current_page() == 1:
            thr = threads.Umount_Thread(self.notebook, 
                                        self.treeview, 
                                        self.treestore, 
                                        self.treeview_mon, 
                                        self.treestore_mon,
                                        self.treeview_groups,
                                        self.treestore_groups)
            thr.start()

    #
	# handlers for running menuitems
    #
    def scan_menu_handler(self, action):
        handlers.scan(self, self, False)

    def remove_menu_handler(self, action):
        handlers.remove(self, self)

    def filemanager_menu_handler(self, action):
        handlers.filemanager(self, self, pyNeighborhood.parser.file_managers[0])
    		
    def mount_menu_handler(self, action):
        handlers.mount(self, self, pyNeighborhood.set_default_mount_type(), False)

    def umount_menu_handler(self, action):
        self.umount()

    def about_menu_handler(self, action):
        dialog.about(self.window)
    		
    def addmach_menu_handler(self, action):
        handlers.add(self, self)

    #
    # After new interface implementing!!!!!!!!!!!!!!
    #
    def preferences_menu_handler(self, action):
        prefs = options.OptionsDialog(self.window)
        newoptdict = prefs.options()
        if newoptdict != None:
            pyNeighborhood.parser.write(newoptdict)
        return

    def quit_menu_handler(self, action):
        self.delete_event()

    #
    # constructor
    #
    def __init__(self):
        #
        # create a new window
        #
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.window.set_title("pyNeighborhood")
        try:
            self.window.set_icon_from_file("icons/pyneighborhood.png")
        except:
            self.window.set_icon_from_file(string.join([config.config(), '/', 'share', '/', 
                                           'pyNeighborhood', '/', 'icons', '/','pyneighborhood.png'], ''))
        x_size = 800
        y_size = 450
        self.window.set_default_size(x_size, y_size)
        self.window.connect("delete_event", self.delete_event_handler, self.window)
        self.window.connect("destroy", self.delete_event_handler, self.window)
        #
        # create menu
        #
        self.menu_vbox = gtk.VBox(False, 1)
        self.menu_vbox.set_border_width(1)

        self.menu_entries = (
            ("FileMenu", None, "_File"),
            ("ActionMenu", None, "_Action"),
            ("EditMenu", None, "_Edit"),
            ("HelpMenu", None, "_Help"),
            ("Quit", gtk.STOCK_QUIT,
             None, "<control>Q", None,
             self.quit_menu_handler),
            ("Scan", "SCAN", 
             "_Scan", None, None,
             self.scan_menu_handler),
            ("Mount", "MOUNT", 
             "_Mount", None, None,
             self.mount_menu_handler),
            ("Unmount", "UNMOUNT", 
             "_Unmount", None, None,
             self.umount_menu_handler),
            ("FileManager","FILEMANAGER", 
             "_File Manager", None, None,
             self.filemanager_menu_handler),
            ("AddMachine", gtk.STOCK_ADD, 
             "_Add Machine...", "<control>A", None,
             self.addmach_menu_handler),
            ("Remove", gtk.STOCK_REMOVE, 
             None, "<control>R", None,
             self.remove_menu_handler),
            ("Preferences", gtk.STOCK_PREFERENCES, 
             None, None, None,
             self.preferences_menu_handler),
            ("Help", gtk.STOCK_ABOUT, 
             None, None, None,
             self.about_menu_handler)
        )

        self.ui_info = \
        """
        <ui>
          <menubar name = "MenuBar">
            <menu action = "FileMenu">
              <menuitem action = "Quit"/>
            </menu>
            <menu action = "ActionMenu">
              <menuitem action = "Scan"/>
              <menuitem action = "Mount"/>
              <menuitem action = "Unmount"/>
              <menuitem action = "FileManager"/>
            </menu>
            <menu action = "EditMenu">
              <menuitem action = "AddMachine"/>
              <menuitem action = "Remove"/>
              <menuitem action = "Preferences"/>
            </menu>
            <menu action = "HelpMenu">
              <menuitem action = "Help"/>
            </menu>
          </menubar>
        </ui>
        """
        menubar = self.get_main_menu(self.window)
        self.menu_vbox.show()
        self.menu_vbox.pack_start(menubar.get_widget("/MenuBar"), False, False, 0)
        
        #
        # create a new notebook, place the position of the tabs
        #
        self.notebook = gtk.Notebook()
        label_1 = gtk.Label()
        label_1.set_text("Network")
        label_2 = gtk.Label()
        label_2.set_text("Mounts")
        
        #
        # vbox with notebook
        #
        # Network
        self.note_vbox = gtk.VBox(False, 1)
        self.note_vbox.set_border_width(1)
        self.note_vbox.show()

        # Mounts
        self.note_vbox_mou = gtk.VBox(False, 1)
        self.note_vbox_mou.set_border_width(1)
        self.note_vbox_mou.show()

        #
        # create "Bookmarks", "Groups" and "Mounts" widgets
        #
        # create bookmarks treeview
        self.bookmarks = bookmarks.Bookmarks_Widget(self)
        self.scrolledwindow, self.treestore, self.treeview = self.bookmarks.Bookmarks()
        # create groups treeview
        self.groups = groups.Groups_Widget(self)
        self.scrolledwindow_groups, self.treestore_groups, self.treeview_groups = self.groups.Groups()
        # create monitor treeview
        self.pyn_monitor = monitor.Monitor_Widget(self)
        self.scrolledwindow_mon, self.treestore_mon, self.treeview_mon = self.pyn_monitor.Monitor()

        #
        # add widgets to notebook
        #
        # Network
        hpaned = gtk.HPaned()
        frame_bookmarks = gtk.Frame()
        frame_bookmarks.set_size_request(x_size*2/3, -1)
        frame_groups = gtk.Frame()
        frame_groups.set_size_request(x_size/3, -1)
        hpaned.add1(frame_groups)
        hpaned.add2(frame_bookmarks)
        frame_bookmarks.add(self.scrolledwindow)
        frame_groups.add(self.scrolledwindow_groups)
        self.note_vbox.pack_start(hpaned, True, True, 0)
        self.notebook.append_page(self.note_vbox, label_1)

        # Mounts
        self.note_vbox_mou.pack_start(self.scrolledwindow_mon, True, True, 0)
        self.notebook.append_page(self.note_vbox_mou, label_2)

        #
        # show the notebook
        #
        self.notebook.set_show_tabs(True)
        self.notebook.show()

        #
        # start a thread with the mounts monitor
        #
        self.monitor_thr = threads.Monitor_Thread(self.treestore_mon)
        self.monitor_thr.start()

        #
        # add progressbar
        #
        align = gtk.Alignment()
        align.set(0, 0.8, 0, 0)
        pyNeighborhood.progressbar.set_size_request(200, 15)
        align.add(pyNeighborhood.progressbar)
        pyNeighborhood.statusbar.pack_end(align, False, False, 0)

        #
        # pack everything into the table and show all
        #
        self.menu_vbox.pack_start(self.notebook, True, True, 0)

        table = gtk.Table(1, 4, False)

        self.window.add(table)
        table.attach(self.menu_vbox,
            # X direction #          # Y direction
            0, 1,                      0, 1,
            gtk.EXPAND | gtk.FILL,     gtk.EXPAND | gtk.FILL,
            0,                         0);

        table.attach(pyNeighborhood.statusbar,
            # X direction           Y direction
            0, 1,                   3, 4,
            gtk.EXPAND | gtk.FILL,  0,
            0,                      0)
        
        #
        # Set initial progressbar value
        #
        pyNeighborhood.update_statusbar(pyNeighborhood.statusbar, "Ready")

        self.window.show_all()

def main():
    gobject.threads_init()
    gtk.main()

