## monitor.py
## 
## Copyright (C) 2005-2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import pygtk
pygtk.require('2.0')
import gtk
import gobject 

import mainwindow
import handlers
import mainwindow
import pyNeighborhood

class Monitor_Widget:

    def instance(self):
        return self

    def menuaction_handler_umount(self, parm1):
        self.mainwindow.umount()

    def menuaction_handler_filemngr(self, parm1, label):
        handlers.filemanager(self, self.mainwindow, label)

    def widget_popup(self):
        popup = gtk.Menu()
        separator = gtk.SeparatorMenuItem()
        item1 = gtk.ImageMenuItem("UNMOUNT")
        item2 = gtk.ImageMenuItem("FILEMANAGER")
        menu = gtk.Menu()
        if len(pyNeighborhood.parser.file_managers) > 1:
            for file_mngr in pyNeighborhood.parser.file_managers:
               item_file = gtk.MenuItem(file_mngr)
               item_file.connect("activate", self.menuaction_handler_filemngr, file_mngr)
               menu.add(item_file)
               item_file.show()
            item2.set_submenu(menu)
        else:
            item2.connect("activate", self.menuaction_handler_filemngr, pyNeighborhood.parser.file_managers[0])

        popup.append(item1)
        popup.append(item2)

        item1.connect("activate", self.menuaction_handler_umount)
        menu = popup
        return menu

    def button_clicked(self, widget, event):
        try:
            if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
                menu = self.widget_popup()
                menu.popup(None, None, None, 3, gtk.get_current_event_time())
                menu.show_all()
        except:
            return

    def Monitor(self):
        c_names = ["Type" , "Resource", "Mountpoint"]
        cell = gtk.CellRendererText()

        tvcolumn = [None] * len(c_names)
        tvcolumn[0] = gtk.TreeViewColumn(c_names[0], cell)
        tvcolumn[1] = gtk.TreeViewColumn(c_names[1], cell)
        tvcolumn[2] = gtk.TreeViewColumn(c_names[2], cell)

        tvcolumn[0].add_attribute(cell, 'text', 0)
        tvcolumn[1].add_attribute(cell, 'text', 1)
        tvcolumn[2].add_attribute(cell, 'text', 2)

        self.treeview.append_column(tvcolumn[0])
        self.treeview.append_column(tvcolumn[1])
        self.treeview.append_column(tvcolumn[2])

        tvcolumn[0].set_resizable(True)
        tvcolumn[1].set_resizable(True)
        tvcolumn[2].set_resizable(True)

        self.treeview.set_expander_column(self.treeview.get_column(1))

        self.treeview.set_search_column(1)

        self.treeview.connect("button_press_event", self.button_clicked)

        scrolledwindow = gtk.ScrolledWindow()
        scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolledwindow.add(self.treeview)
        return scrolledwindow, self.treestore, self.treeview

    def __init__(self, MainWindow):
        self.treestore = gtk.TreeStore(str, str, str)
        self.treeview = gtk.TreeView(self.treestore)
        self.mainwindow = MainWindow
 
