'''OpenGL extension EXT.blend_color

Overview (from the spec)
	
	Blending capability is extended by defining a constant color that can
	be included in blending equations.  A typical usage is blending two
	RGB images.  Without the constant blend factor, one image must have
	an alpha channel with each pixel set to the desired blend factor.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/blend_color.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_CONSTANT_COLOR_EXT = constant.Constant( 'GL_CONSTANT_COLOR_EXT', 0x8001 )
GL_ONE_MINUS_CONSTANT_COLOR_EXT = constant.Constant( 'GL_ONE_MINUS_CONSTANT_COLOR_EXT', 0x8002 )
GL_CONSTANT_ALPHA_EXT = constant.Constant( 'GL_CONSTANT_ALPHA_EXT', 0x8003 )
GL_ONE_MINUS_CONSTANT_ALPHA_EXT = constant.Constant( 'GL_ONE_MINUS_CONSTANT_ALPHA_EXT', 0x8004 )
GL_BLEND_COLOR_EXT = constant.Constant( 'GL_BLEND_COLOR_EXT', 0x8005 )
glget.addGLGetConstant( GL_BLEND_COLOR_EXT, (4,) )
glBlendColorEXT = platform.createExtensionFunction( 
	'glBlendColorEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLclampf, constants.GLclampf, constants.GLclampf, constants.GLclampf,),
	doc = 'glBlendColorEXT( GLclampf(red), GLclampf(green), GLclampf(blue), GLclampf(alpha) ) -> None',
	argNames = ('red', 'green', 'blue', 'alpha',),
)


def glInitBlendColorEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_EXT_blend_color' )
