'''OpenGL extension EXT.cmyka

Overview (from the spec)
	
	This extension provides a simple method for OpenGL to read and store
	images whose pixels have CMYK or CMYKA formats.  The algorithms used to
	convert to RGBA from CMYKA and to convert back from RGBA to CMYKA are of
	the "black-box" nature, meaning that the application has little control
	over how the conversion is done.  Also, this black-box mechanism is
	available only for transfers to or from memory, not for internal copies
	of pixel data (such as invoked by CopyPixels, CopyTexImage1D, etc.)
	However, the defined mechanism nicely handles 5-component CMYKA images,
	and it is very easy to use.
	
	A more configurable and potentially higher quality color conversion can
	be implemented using the color tables, the color matrix, and possibly 3D
	and 4D texture lookup.  Such a color conversion also applies to copied
	pixel data.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/cmyka.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_CMYK_EXT = constant.Constant( 'GL_CMYK_EXT', 0x800C )
GL_CMYKA_EXT = constant.Constant( 'GL_CMYKA_EXT', 0x800D )
GL_PACK_CMYK_HINT_EXT = constant.Constant( 'GL_PACK_CMYK_HINT_EXT', 0x800E )
glget.addGLGetConstant( GL_PACK_CMYK_HINT_EXT, (1,) )
GL_UNPACK_CMYK_HINT_EXT = constant.Constant( 'GL_UNPACK_CMYK_HINT_EXT', 0x800F )
glget.addGLGetConstant( GL_UNPACK_CMYK_HINT_EXT, (1,) )


def glInitCmykaEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_EXT_cmyka' )
