#! -*- coding: iso8859-1 -*- 

"""setup.py Pyragua

Con este script se podrn crear distribuciones en diversos formatos,
como un comprimido (zip o tar.gz), una versin ejecutable, un instalador
para windows y un paquete rpm.

En caso de agregar un nuevo mdulo del Pyragua se debe agregar en la lista
pyragua_modulos para que se genere la salida adecuada. 

Distribucin de cdigo fuente

De esta forma el script crear un paquete comprimido en un formato que
depende del Sistema operativo (tar.gz en UNIX, zip en gin2)

En la linea de comandos se debe ejecutar:

- python setup.py sdist

Se puede especificar el formato de salida con la opcin --formats

- python setup.py sdist --formats=gztar,zip,bztar,ztar,tar

Claro, esta opcin requiere tener instalado los programas correspondientes
en el sistema operativo.

**En la creacin de una distribucin de cdigo fuente es importante tener
en cuenta el archivo MANIFEST y MANIFEST.in.  El primero es generado
automaticamente por distutils al ejecutarse el comando, y en el caso de
que se modifique el script para agregar nuevos mdulos se debe eliminar
para que este lo genere nuevamente.  El segundo archivo contiene
instrucciones para agregar a la distribucin de cdigo fuente archivos que
no son de extensin 'py', como las imgenes y docmentos de texto.
"""

from distutils.core import setup
import py2exe
import os

#Aqu se deben agregar los mdulos nuevos del pyragua
pyragua_modulos=[
                            'ClassBrowser',
                            'Proyectos'
                            ] 

#Sacada del About
descripcion_larga = """Pyragua es un entorno de desarrollo para
                                 la manipulacin de cdigo en lenguaje Python
                                 diseado por los integrantes del grupo de
                                 investigacin Pyrox de la Universidad
                                 Tecnolgica de Pereira, cuyo fin es explorar e
                                 implementar nuevas tecnologas basadas en este
                                 potente lenguaje."""


setup (name='Pyragua', 
           version='0.2.1',
           description='Entorno de Desarrollo Integrado', 
           long_description=descripcion_larga,
           author='Pyrox',
           author_email='python@gda.utp.edu.co', 
           url='http://pyrox.utp.edu.co',    
           scripts=['pyragua.py'], 
           packages=pyragua_modulos,
           
           data_files= [ ('imagenes',['imagenes/about_02.png',
                                            'imagenes/archivo.png',
                                            'imagenes/licencia_about02.png',
                                            'imagenes/pyragua_about02.png',
                                            'imagenes/pyrox_about02.png',
                                            'imagenes/clase.png',
                                            'imagenes/metodo.png',
                                            'imagenes/pyragua.ico',
                                            'imagenes/pyragua_splash.png']),
                                ('locale/es',['locale/es/pyragua.po'] )],
           windows=[
            {
            "script": 'pyragua.py',
            "icon_resources": [(1, os.path.join("imagenes", "pyragua.ico"))]  #Esto es para py2exe
            }
        ]
          )
