dnl
dnl Discovers which is the prefix of the default cracklib dictionary database
dnl
dnl usage:
dnl
dnl     AC_CRACKLIB_DICTPATH
dnl
dnl results:
dnl
dnl     DEFAULT_DICTPATH output variable containing the prefix
dnl

AC_DEFUN(AC_CRACKLIB_DICTPATH,
[
	AC_ARG_VAR([DEFAULT_DICTPATH], [full path name + filename prefix of the default cracklib dictionary database])

	AC_MSG_CHECKING([for prefix of the default cracklib dictionary database])

	if test -n "$DEFAULT_DICTPATH"; then
		AC_MSG_RESULT($DEFAULT_DICTPATH)
	else
		AC_CACHE_VAL(ac_default_dictpath,
		[
			cat > dictpath-test.c << EOF
#include <crack.h>

int main()
{
	printf(CRACKLIB_DICTPATH);
	return 0;
}
EOF

			${CC-cc} -o dictpath-test $CFLAGS dictpath-test.c >/dev/null 2>&1

			if test -e dictpath-test; then
				ac_default_dictpath=`./dictpath-test`
				AC_MSG_RESULT($ac_default_dictpath)
			else
				AC_MSG_RESULT(unknown)
				AC_MSG_ERROR([crack.h does not define CRACKLIB_DICTPATH. Please use DEFAULT_DICTPATH, see ./configure --help])
			fi

			rm -f dictpath-test* core core.dictpath-test
		])

		DEFAULT_DICTPATH=$ac_default_dictpath
	fi
])

AC_DEFUN(AC_PYTHON_CPPFLAGS, [
	AC_REQUIRE([AM_PATH_PYTHON])

	AC_CACHE_CHECK([for python CPPFLAGS], ac_cv_python_cppflags, [
		ac_cv_python_cppflags="-I/usr/include/python$PYTHON_VERSION"
	])
	AC_SUBST(PYTHON_CPPFLAGS, $ac_cv_python_cppflags)
])

AC_DEFUN(AC_PYTHON_EXTENSION, [
	AC_REQUIRE([AM_PATH_PYTHON])
	AC_REQUIRE([AC_PYTHON_CPPFLAGS])

	AC_CACHE_CHECK([for python extension LDFLAGS], ac_cv_python_extension_ldflags, [
		cat > tmp_python_ext_ldflags.py <<EOF
from distutils import sysconfig
print sysconfig.get_config_var('LINKFORSHARED')
EOF
		ac_cv_python_extension_ldflags=`$PYTHON tmp_python_ext_ldflags.py`
		rm -f tmp_python_ext_ldflags.py
	])
	AC_SUBST(PYTHON_EXTENSION_LDFLAGS, $ac_cv_python_extension_ldflags)
])

AC_DEFUN(AC_PYTHON_EMBEDDED, [
	AC_REQUIRE([AM_PATH_PYTHON])
	AC_REQUIRE([AC_PYTHON_CPPFLAGS])

	AC_MSG_CHECKING(for python embedded LDFLAGS)
    AC_CACHE_VAL(ac_cv_python_lib, [ac_cv_python_lib="python$PYTHON_VERSION"])
	AC_CACHE_VAL(ac_cv_python_config, [ac_cv_python_config="/usr/lib/python$PYTHON_VERSION/config"])
    AC_CACHE_VAL(ac_cv_python_embedded_ldflags, [
		ac_cv_python_embedded_ldflags="-L$ac_cv_python_config -l$ac_cv_python_lib -ldl -lutil"
		])
	AC_MSG_RESULT($ac_cv_python_embedded_ldflags)
	AC_SUBST(PYTHON_EMBEDDED_LDFLAGS, $ac_cv_python_embedded_ldflags)
])

AC_DEFUN(AC_PYTHON_FULL, [
	AC_REQUIRE([AM_PATH_PYTHON])
	AC_REQUIRE([AC_PYTHON_CPPFLAGS])
	AC_REQUIRE([AC_PYTHON_EMBEDDED])
	AC_REQUIRE([AC_PYTHON_EXTENSION])
])
