#
#     Copyright 2007-2008 Jim Bublitz <jbublitz@nwinternet.com>
#

# This software is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.

# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public
# License along with this library; see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


import os, os.path

def parseLine (line):
    parts = line [3:].split (" | ")
    if len (parts) == 1:
        parts.append ("")
    return line [0], parts [0].strip (), parts [1].strip ()

def documentation (basepath):
    indexPath = os.path.join (basepath, "doc", "index.txt")
    m = open (indexPath, "r")

    docs = {}
    docTitles = []
    
    for line in m:
        category, title, file = parseLine (line)
        docs [title] = file
        docTitles.append (title)

    m.close ()
    return docs, docTitles

def tutorials (basepath):    
    indexPath = os.path.join (basepath, "tutorials", "index.txt")
    m = open (indexPath, "r")

    titles = {}
    titleList = []
    topics = []
    topicFile = {}
    
    for line in m:
        category, title, file = parseLine (line)
        if category == 't':
            if topics:
                titles [currentTitle] = (path,topics)
                topics = []
                titleList.append (currentTitle)
                        
            currentTitle = title
            path = file
        
        elif category == "f":
            topics.append (title)
            topicFile [title] = file
            
    m.close ()
    return titles, titleList, topicFile
    
def user (basepath):    
    indexPath = os.path.join (basepath, "userindex.txt")
    m = open (indexPath, "r")
    
    titles = {}
    titleList = []
    bookmarks = []
    bookmarkFile = {}
    currentTitle = ""    
    
    for line in m:
        category, title, file = parseLine (line)
        if category == "g":
            if currentTitle:
                bookmarks.sort ()
                titles [currentTitle] = (path, bookmarks)
                bookmarks = []
                titleList.append (currentTitle)
                
            currentTitle = title
            path = file
                
        elif category == "b":
            bookmarks.append (title)
            bookmarkFile [title] = file
            
    m.close ()
    return titles,  titleList,  bookmarkFile
    
def writeUser (basepath, titles, titleList,  bookmarkFile):
    indexPath = os.path.join (basepath, "userindex.txt.new")
    m = open (indexPath, "w")
    
    for title in titleList:
        m.write ("g: %s | %s\n" % (title, titles [title][0]))
        for bookmark in titles [title][1]:
            m.write ("b: %s | %s\n" % (bookmark,  bookmarkFile [bookmark]))

    m.write ("g: $end | \n")
    m.close ()
    os.unlink (os.path.join (basepath, "userindex.txt"))
    os.rename (os.path.join (basepath, "userindex.txt.new"),  os.path.join (basepath, "userindex.txt"))
    
    
