# Copyright (c) 2006 Bea Lam. All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

import os.path
import stat
import types

import _lightbluecommon
import _obexutil    # python extension


# public attributes
__all__ = ("sendfile", "recvfile")


def sendfile(address, channel, source):
    if not isinstance(source, (types.StringTypes, types.FileType)):
        raise TypeError("source must be string or built-in file object")
	
    if isinstance(source, types.StringTypes):
        if not os.path.isfile(source):
            raise IOError("File '%s' not found" % source)
        fileobj = file(source, "rb")
    
        # basename() ensures we send a filename not a path; remote 
        # device may refuse the PUT if obex name header has a path
        try:
            _sendfile(address, channel, os.path.basename(source), 
                fileobj, os.stat(source)[stat.ST_SIZE])
        finally:
            fileobj.close()
    else:
        # given a file object
        pos = source.tell()
        source.seek(0, 2)    # seek to end of file
        filesize = source.tell()
        source.seek(pos)    # back to original pos
        _sendfile(address, channel, source.name, source, filesize)

def _sendfile(address, channel, name, fileobj, filesize):
    try:
        _obexutil.send_file(address, channel, name, fileobj, filesize)
    except IOError, exc:    # _obexutil throws IOErrors
        raise _lightbluecommon.BluetoothError(str(exc))


# given sock must be a server socket.
def recvfile(sock, dest):
    if not isinstance(dest, (types.StringTypes, types.FileType)):
        raise TypeError("dest must be string or built-in file object")    
    
    if isinstance(dest, types.StringTypes):
        # will overwrite existing file
        fileobj = file(dest, "wb")
        try:
            _recvfile(sock, fileobj)
        finally:
            fileobj.close()
    else:
        # given a file object
        _recvfile(sock, dest)

def _recvfile(sock, fileobj):
    try:
        _obexutil.recv_file(sock.fileno(), fileobj)
    except IOError, exc:    # _obexutil throws IOErrors
        raise _lightbluecommon.BluetoothError(str(exc))
