# Builds the lightblue C++ extension on each platform.
# To build for each platform, a copy of the src\_lightblueutil folder (which contains
# the python extensions) must be placed in the root folder for each platform.
# e.g. for 1st edition, it might be placed at C:\Symbian\6.1\Series60\_lightblueutil


import sys
import os
import shutil


# This doesn't actually work for building for all systems in one go - need something
# to set the default SDK for each platform before you build, using the "devices" 
# command in ms-dos. But it wouldn't work for all of them anyway since the 1.2 SDK 
# conflicts with the 3rd Edition SDK.


# build info for each SDK:
#   - SDK root path
#   - drive where SDK is located
#   - virtual drive to use for the build
#   - where to place the built extension file
#   - the platform to build for (armi for pre-3rdEdition, gcce for 3rdEdition)
SDK_BUILD_INFO = [
    (r"\Symbian\6.1\Series60",      "C:", "L:", r"C:\lightblue\dev\build\s60-1stEd-FP1", "armi"),
    #(r"\Symbian\7.0s\Series60_v20", "C:", "M:", r"C:\lightblue\dev\build\s60-2ndEd",     "armi"),
    #(r"\Symbian\8.0a\S60_2nd_FP2",  "C:", "O:", r"C:\lightblue\dev\build\s60-2ndEd-FP2", "armi"),
    #(r"\Symbian\8.1a\S60_2nd_FP3",  "C:", "P:", r"C:\lightblue\dev\build\s60-2ndEd-FP3", "armi"),
    #(r"\Symbian\9.1\S60_3rd_MR_2",    "C:", "Q:", r"C:\lightblue\dev\build\s60-3rdEd",      "gcce"),
    ]
    

def setup():
    print ">> Setting up..."
    
    # set environment variables
    #os.system(r'"C:\Program Files\Microsoft Visual Studio\VC98\Bin\VCVARS32.BAT"')
    os.environ["PATH"] += r"C:\Program Files\Microsoft Visual Studio 8\VC\bin;"
    os.environ["PATH"] += r"C:\Program Files\Microsoft Visual Studio 8\Common7\IDE;"
    
    # set EPOCROOT (apparently don't always need this, but I got errors)
    os.environ["EPOCROOT"] = "\\"       # change is not persistent, which is fine

    
def build(platform):    
    print ">> Building extensions at %s" % os.getcwd()
    os.system("bldmake bldfiles")
    os.system("abld build %s urel" % platform)
    os.system("abld freeze %s" % platform)
    os.system("abld build %s urel" % platform)    

        
def run():
    setup()
    
    #os.chdir("..\src\_lightblueutil")
 
    for rootpath, drive, virtualdrive, builtfiledest, platform in SDK_BUILD_INFO:
        fullsdkpath = os.path.join(drive, rootpath)    
        print ">> Building for SDK at %s..." % fullsdkpath
        
        os.system("subst %s %s" % (virtualdrive, fullsdkpath))
        
        # assume a copy of the src\_lightblueutil folder (containing python 
        # extensions) is placed in the root of the virtual drive
        os.chdir(os.path.join(virtualdrive, os.path.sep, "_lightblueutil"))
        
        build(platform)
        
        # root path for finding the built extension
        builtextpath = r"\Epoc32\release\%s\urel" % platform
        
        # name of built extension
        builtfilename = "_lightblueutil.pyd"
        
        shutil.copyfile(os.path.join(builtextpath, builtfilename),    
                        os.path.join(builtfiledest, builtfilename))


if __name__ == "__main__":
    run()
    
    