#!/usr/bin/env python
""" bank03: Many non-random Customers """
from SimPy.Simulation  import *

class Source(Process):                          
    """ Source generates customers regularly"""

    def generate(self,number,interval):         
        for i in range(number):
            c = Customer(name = "Customer%02d"%(i,)) 
            activate(c,c.visit(timeInBank=12.0))
            yield hold,self,interval            

class Customer(Process):
    """ Customer arrives, looks round and leaves """
        
    def visit(self,timeInBank=0):       
        print "%7.4f %s: Here I am"%(now(),self.name)
        yield hold,self,timeInBank
        print "%7.4f %s: I must leave"%(now(),self.name)

def model():
    initialize()
    source=Source()                              
    activate(source,source.generate(5,10.0),0.0) 
    simulate(until=400.0)

model()
 
