#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sched.h>
#include <sys/mman.h>
#include <qsignal.h>
#include <qthread.h>
#include <qwaitcondition.h>
#include "recdata.h"
#include "diskwrite.h"

DiskWrite::DiskWrite(RecData *p_recdata) {

  recdata = p_recdata;
  wavdata = (unsigned char *)malloc(WAVBUFSIZE);
}

DiskWrite::~DiskWrite(){        

}

void DiskWrite::run() {

  int l1, tmpint;
  unsigned char outbuf[8];
  
  if (!recdata->pauseFlag) {
    if (!(wavfile = fopen(recdata->currentFile.latin1(), "w"))) {
      recdata->doRecord = false;
    } else {
      recdata->wavDataSize = 0;
      outbuf[0] = 0x52; outbuf[1] = 0x49; outbuf[2] = 0x46; outbuf[3] = 0x46; // "RIFF"
      fwrite(outbuf, 1, 4, wavfile);
      outbuf[0] = 0x24; outbuf[1] = 0x00; outbuf[2] = 0xff; outbuf[3] = 0x00; // ChunkSize
      fwrite(outbuf, 1, 4, wavfile);
      outbuf[0] = 0x57; outbuf[1] = 0x41; outbuf[2] = 0x56; outbuf[3] = 0x45; // "WAVE"
      fwrite(outbuf, 1, 4, wavfile);
      outbuf[0] = 0x66; outbuf[1] = 0x6d; outbuf[2] = 0x74; outbuf[3] = 0x20; // "fmt "
      fwrite(outbuf, 1, 4, wavfile);
      outbuf[0] = 0x10; outbuf[1] = 0x00; outbuf[2] = 0x00; outbuf[3] = 0x00; // Subchunk1Size
      fwrite(outbuf, 1, 4, wavfile);
      outbuf[0] = 0x01; outbuf[1] = 0x00; // AudioFormat
      fwrite(outbuf, 1, 2, wavfile);
      outbuf[0] = 0x02; outbuf[1] = 0x00; // NumChannels
      fwrite(outbuf, 1, 2, wavfile);
      outbuf[3] = recdata->rate >> 24;  // SampleRate
      outbuf[2] = (recdata->rate >> 16) - ((recdata->rate >> 24) << 8);
      outbuf[1] = (recdata->rate >> 8) - ((recdata->rate >> 16) << 8); 
      outbuf[0] = (unsigned char)recdata->rate;
      fwrite(outbuf, 1, 4, wavfile);
      tmpint = recdata->rate * recdata->framesize;
      outbuf[3] = tmpint >> 24;  // ByteRate
      outbuf[2] = (tmpint >> 16) - ((tmpint >> 24) << 8);
      outbuf[1] = (tmpint >> 8) - ((tmpint >> 16) << 8); 
      outbuf[0] = (unsigned char)tmpint;
      fwrite(outbuf, 1, 4, wavfile);
      outbuf[0] = recdata->framesize; outbuf[1] = 0x00; // BlockAlign
      fwrite(outbuf, 1, 2, wavfile);
      outbuf[0] = 8 * recdata->samplesize; outbuf[1] = 0x00; // BitsPerSample
      fwrite(outbuf, 1, 2, wavfile);
      outbuf[0] = 0x64; outbuf[1] = 0x61; outbuf[2] = 0x74; outbuf[3] = 0x61; // "data"
      fwrite(outbuf, 1, 4, wavfile);
      outbuf[0] = 0x00; outbuf[1] = 0x00; outbuf[2] = 0xff; outbuf[3] = 0x00; // Subchunk2Size
      fwrite(outbuf, 1, 4, wavfile);
    }  
  } else {
    recdata->pauseFlag = false;
  }
  recdata->readOfs = recdata->writeOfs;
  if (recdata->readOfs >= recdata->ringBufSize) recdata->readOfs -= recdata->ringBufSize;
  recdata->validByteCount = 0;
  while(recdata->doRecord) {
    while (recdata->doRecord && (recdata->validByteCount < WAVBUFSIZE)) {
      recdata->waitForData.wait();
    }
//    fprintf(stderr, ">> validByteCount: %d\n", recdata->validByteCount);
    for (l1 = 0; l1 < WAVBUFSIZE; l1++) {
      wavdata[l1] = recdata->ringBuf[recdata->readOfs++];
      if (recdata->readOfs >= recdata->ringBufSize) recdata->readOfs -= recdata->ringBufSize;      
    }
    recdata->validByteCount -= WAVBUFSIZE;
    fwrite(wavdata, 1, WAVBUFSIZE, wavfile);
    recdata->wavDataSize += WAVBUFSIZE;
  }
  if (wavfile) { 
    while(recdata->validByteCount > WAVBUFSIZE) {
      fprintf(stderr, "validByteCount: %ld\n", recdata->validByteCount);
      for (l1 = 0; l1 < WAVBUFSIZE; l1++) {
        wavdata[l1] = recdata->ringBuf[recdata->readOfs++];
        if (recdata->readOfs >= recdata->ringBufSize) recdata->readOfs -= recdata->ringBufSize;
      }
      recdata->validByteCount -= WAVBUFSIZE;
      fwrite(wavdata, 1, WAVBUFSIZE, wavfile);
      recdata->wavDataSize += WAVBUFSIZE;
    }
//    fprintf(stderr, "--> validByteCount: %d\n", recdata->validByteCount);
    for (l1 = 0; l1 < recdata->validByteCount; l1++) {
      wavdata[l1] = recdata->ringBuf[recdata->readOfs++];
      if (recdata->readOfs >= recdata->ringBufSize) recdata->readOfs -= recdata->ringBufSize;
    }
    fwrite(wavdata, 1, recdata->validByteCount, wavfile);
    recdata->wavDataSize += recdata->validByteCount;
    recdata->validByteCount = 0;
    tmpint = recdata->wavDataSize + 36;
    outbuf[3] = tmpint >> 24;  // ChunkSize
    outbuf[2] = (tmpint >> 16) - ((tmpint >> 24) << 8);
    outbuf[1] = (tmpint >> 8) - ((tmpint >> 16) << 8);
    outbuf[0] = (unsigned char)tmpint;
    fseek(wavfile, 4, SEEK_SET);
    fwrite(outbuf, 1, 4, wavfile);
    tmpint = recdata->wavDataSize;
    outbuf[3] = tmpint >> 24;  // Subchunk2Size
    outbuf[2] = (tmpint >> 16) - ((tmpint >> 24) << 8);
    outbuf[1] = (tmpint >> 8) - ((tmpint >> 16) << 8);
    outbuf[0] = (unsigned char)tmpint;
    fseek(wavfile, 40, SEEK_SET);
    fwrite(outbuf, 1, 4, wavfile);
    fseek(wavfile, 0, SEEK_END);
    fflush(wavfile);
  }
}
