/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "qchat.h"

#include <QSplashScreen>
#include <QTime>

#include "chatcore.h"
#include "chatwgt.h"
#include "globals.h"

QChat::QChat(QObject *parent)
 : QObject(parent),
  m_chat(NULL),
  m_core(NULL)
{

}

QChat::~QChat()
{
  qDebug("[QChat::~QChat]\n");

  m_core->slot_saveSettings();

  delete m_chat;
  delete m_core;
}

void QChat::start(int argc, char *argv[], QApplication* app)
{
//   QSplashScreen *splash = new QSplashScreen(QPixmap(":/images/splash.png"));

//   splash->show();
  QTime t, tt;

  t.start();
  tt.start();

  m_app = app;

  app->setQuitOnLastWindowClosed(false);

  m_core = new ChatCore;

  qDebug("Time elapsed: %d ms", t.restart());
  qDebug("QChat: [Loading settings...]\n");
//   splash->showMessage(tr("Loading settings..."), Qt::AlignBottom | Qt::AlignCenter, Qt::red);

  CmdArgs* args = m_core->processCmdArgs(argc, argv);

  m_core->initSettings();
  m_core->slot_loadSettings();

  if(args->port_in > 0)
    Globals::prefs()->setPortIn(args->port_in);

  if(args->port_out > 0)
    Globals::prefs()->setPortOut(args->port_out);

  delete args;

  qDebug("Time elapsed: %d ms", t.restart());
  qDebug("QChat: [Creating Main Window...]\n");
//   splash->showMessage(tr("Creating Main Window..."), Qt::AlignBottom | Qt::AlignCenter, Qt::red);

  m_chat = new ChatWgt(m_core);
  m_chat->setCursor(QCursor(Qt::WaitCursor));

  m_core->setChatWgt(m_chat);
  m_chat->fillProfilesCmbx(m_core->profiles(), m_core->currentProfile());

  qDebug("Time elapsed: %d ms", t.restart());
  qDebug("QChat: [Starting threads...]\n");
//   splash->showMessage(QObject::tr("Starting threads..."), Qt::AlignBottom | Qt::AlignCenter, Qt::red);

  m_core->startThreads();

  connect(m_chat, SIGNAL(     singleMessageOut  (QString, QHostAddress)),
          m_core, SLOT  (slot_singleMessage     (QString, QHostAddress)));

  connect(m_core, SIGNAL(     singleMessageIn   (Message*)),
          m_chat, SLOT  (slot_singleMessageIn   (Message*)));


  connect(m_core, SIGNAL(     privateChatRequest(QString, QHostAddress)),
          m_chat, SLOT  (slot_privateChat       (QString, QHostAddress)));

  connect(m_core, SIGNAL(chatDataReceived(QC_DatagramHeader*)),
          m_chat, SLOT  (slot_processData(QC_DatagramHeader*)));

  connect((QObject*)m_core->receiver(), SIGNAL(wantReceiveFile (QString, quint16, quint64)),
          m_chat            , SLOT  (slot_receiveFile(QString, quint16, quint64)));

  connect(app   , SIGNAL(focusChanged(QWidget*, QWidget*)),
          m_chat, SLOT  (slot_focusChanged(QWidget*, QWidget*)));

  connect(m_chat, SIGNAL(closed()),
          app   , SLOT  (quit()));

//   connect(m_chat, SIGNAL(wantReloadStyleSheet()), this, SLOT(reloadStyleSheet()));

  connect(m_chat, SIGNAL(wantChangeStyleSheet(QString)), this, SLOT(setStyleSheet(QString)));

  qDebug("Time elapsed: %d ms", t.restart());
  qDebug("QChat: [Creating channel 'Main'...]\n");
//   splash->showMessage(QObject::tr("Creating channel 'Main'..."), Qt::AlignBottom | Qt::AlignCenter, Qt::red);

  m_chat->slot_addChannell("Main");

  qDebug("Time elapsed: %d ms", t.restart());
  qDebug("QChat: [Restoring Window Geometry...]\n");
//   splash->showMessage(tr("Restoring Window Geometry..."), Qt::AlignBottom | Qt::AlignCenter, Qt::red);

  m_chat->restoreAndShow();

  qDebug("Time elapsed: %d ms", t.restart());
  qDebug("QChat: [Ready to Chat :)]\n");
//   splash->showMessage(tr("Ready to Chat :)"), Qt::AlignBottom | Qt::AlignCenter, Qt::red);

//   splash->finish(m_chat);
  m_chat->setCursor(QCursor(Qt::ArrowCursor));

  qDebug("Starting Time: %d ms", tt.elapsed());
}

void QChat::reloadStyleSheet()
{
  m_app->setStyleSheet(m_styleSheet);
}

void QChat::setStyleSheet(const QString & filename)
{
  QFile file(filename);
  QByteArray ba;

  file.open(QFile::ReadOnly | QFile::Unbuffered);

  // etogo bolee chem dostatochno, i v sluchae esli budet vybran ochen' bol'shoi fail
  // ne budet popytki zagruzit' ego tselikom v pamyat'
  if(file.size() < 1024 * 1024)
    ba = file.readAll();

  file.close();

  m_styleSheet = QString().fromUtf8(ba);

  m_app->setStyleSheet(m_styleSheet);
}
