/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the accessibility project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef ACCESSIBLENULLINTERFACE_H
#define ACCESSIBLENULLINTERFACE_H

#include <QtGui/qaccessible.h>

class AccessibleNullInterface: public QAccessibleInterface
{
public:
    inline bool isValid() const
    { return false; }
    inline QObject *object() const
    { return 0; }
    inline int childCount() const
    { return 0; }
    inline int indexOfChild(const QAccessibleInterface *) const
    { return -1; }
    inline Relation relationTo(int, const QAccessibleInterface *, int) const
    { return Unrelated; }
    inline int childAt(int, int) const
    { return -1; }
    inline int navigate(RelationFlag, int, QAccessibleInterface **iface) const
    { *iface = 0; return -1; }
    inline QString text(Text, int) const
    { return QString(); }
    inline void setText(Text, int, const QString &)
    {}
    inline QRect rect(int) const
    { return QRect(); }
    inline Role role(int) const
    { return NoRole; }
    inline State state(int) const
    { return Normal; }
    inline int userActionCount(int) const
    { return 0; }
    inline QString actionText(int, Text, int) const
    { return QString(); }
    inline bool doAction(int, int, const QVariantList & = QVariantList())
    { return false; }
};

#endif
