#!/usr/bin/env python
# coding=utf-8

##    Qemulator - a qemu gui written in python and GTK/Glade.
##    Copyright (C) 2006  rainer haage
##
##    This program is free software; you can redistribute it and/or
##    modify it under the terms of the GNU General Public License
##    as published by the Free Software Foundation; either version 2
##    of the License, or (at your option) any later version.
##    
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##    
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
from os import path
import os
import sys
import pickle
import time
import string
import re
import mimetypes
from copy import copy
import gobject
import gettext
import locale

import pygtk

import gtk
import gtk.glade

#import qemulator
import qml_filehandlers
from qml_tools import GTK_tools

encoding = locale.getpreferredencoding()
utf8conv = lambda x : unicode(x, encoding).encode('utf8')
    
#for param in os.environ.keys():
#    print "%20s %s" % (param,os.environ[param])
    
current_path = os.path.realpath(__file__)
basedir = os.path.dirname(os.path.realpath(__file__))
if not os.path.exists(os.path.join(basedir, "main.py")):
    if os.path.exists(os.path.join(os.getcwd(), "main.py")):
        basedir = os.getcwd()
sys.path.insert(0, basedir)
os.chdir(basedir)  
#print "basedir: " + basedir
basedir = basedir.replace ( '/bin', '' ) 
basedir = basedir.replace ( '/lib/qemulator', '' ) 
sys.path.append(basedir)   
bindir = basedir + "/bin"
#print "bindir: " + bindir
libdir = basedir + "/lib/qemulator"
#print "libdir: " + libdir
sharedir = basedir + "/share/qemulator"
#print "sharedir: " + sharedir
pixmapdir = basedir + "/share/pixmaps/qemulator"
#print "pixmapdir: " + pixmapdir     
homedir = os.path.expanduser('~/.qemulator')
configdir = homedir + "/config"
#print "configdir: " + configdir           
icondirs = [sharedir + "/icons",homedir + "/icons"] 

APP = 'Qemulator'
#DIR = 'locale'
DIR = basedir + '/share/locale'
#print "DIR: " + DIR
locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain(APP, DIR)
gettext.textdomain(APP)
_ = gettext.gettext

gtk.glade.bindtextdomain(APP, DIR)
gtk.glade.textdomain(APP)
tooltips = gtk.Tooltips() 
tipmap = {}

class Audio_environment:
    def __init__(self, callback_func=None):
        #self.removable_media = {}
        self.env_vars = {}
        self.fetchcommand = 'qemu -audio-help'
        self.helpout = []
        self.helplist = []
        self.valuedict = {}
        self.valuedict["audioparams"] = {}
        self.valuedict["driverparams"] = {}
        self.valuedict["driverdescs"] = {}
        self.audioparams = {}
        self.driverparams = {}
        self.driverdescs = {}
        self.gladefile = libdir + "/qemulator.glade"
        self.callback_func = callback_func
        #print 'audio settings: ' + str(audiosettings)
    
        #self.init_gui()
        
    def init_gui(self, audiosettings):
        #print 'audio settings: ' + str(audiosettings)
        if audiosettings == 'Default' or audiosettings == {}:
            self.audiosettings = {}
            self.audiosettings['audioparams'] = {}
            self.audiosettings['driver'] = {}
            self.audiosettings['driverparams'] = {}
        else:
            self.audiosettings = copy(audiosettings)
            #print 'using stored audio settings' + str(audiosettings)      
        self.GTK_tools = GTK_tools()
        self.wTree = gtk.glade.XML(self.gladefile, "dialog_audioparams", APP)
        self.dialog_audioparams = self.wTree.get_widget("dialog_audioparams")
        self.treeview_audioparams = self.wTree.get_widget("treeview_audioparams")
        self.treeview_driverparams = self.wTree.get_widget("treeview_driverparams")
        self.resetbutton = self.wTree.get_widget("resetbutton")
        self.combobox_driver = self.wTree.get_widget("combobox_driver")
        self.eventbox_audiodriver = self.wTree.get_widget("eventbox_audiodriver")
        #self.treeview_qemupaths = self.wTree.get_widget("treeview_qemupaths")
        
        #audiodata = self.get_fullist_audio()
        #amodel = self.create_model_audioparams(audiodata)
        #self.add_columns_audioparams(self.treeview_audioparams, amodel)
                
        dic = {"on_resetbutton_clicked" : self.on_resetbutton_clicked
            , "on_dialog_audioparams_response" : self.dialog_audioparams_response
            , "on_combobox_driver_changed" : self.select_driver
        }
        self.wTree.signal_autoconnect(dic)
        
        
        if self.audiosettings['audioparams'] != {}:
            amodel = self.create_model_audioparams(self.audiosettings['audioparams'])
        else:
            amodel = self.create_model_audioparams('')
            
        self.treeview_audioparams.set_model(amodel)
        self.add_columns_audioparams(self.treeview_audioparams, amodel)              
        if self.audiosettings['audioparams'] == {}:
            self.on_resetbutton_clicked()
            
        dmodel = self.create_model_audioparams('')  
        self.treeview_driverparams.set_model(dmodel)
        self.add_columns_audioparams(self.treeview_driverparams, dmodel)  
        #treeview_driverparams
        
        descs = self.get_driverdescs()
        self.init_driverlist(descs)
                
        ## Select the driver and setup GUI   
        print 'driver: ' + str(self.audiosettings['driver']) 
        find_driverentry = self.GTK_tools.search_combolist(self.combobox_driver, self.audiosettings['driver'])
        print 'Selected driver entry: ' + str(find_driverentry)
        
        if find_driverentry != None:
            self.combobox_driver.set_active(find_driverentry)
        else:
            self.combobox_driver.set_active(0) 
            
        self.load_driverdata(self.audiosettings['driver'])
            
        self.dialog_audioparams.present()                      
            

        
    def on_resetbutton_clicked(self, *widget):
        #print "resetting data: "
        audiodata = self.get_fullist_audio()
        self.audiosettings['audioparams'] = audiodata
        #print "audiodata: " + str(audiodata)
        amodel = self.treeview_audioparams.get_model() 
        try:
            amodel.clear()
        except:
            pass
        amodel = self.create_model_audioparams(audiodata)
        self.treeview_audioparams.set_model(amodel)
        
        ## resetting driversettings
        self.audiosettings['driver'] = {}
        self.audiosettings['driverparams'] = {}
        self.reset_driverdata('none')
        #if self.audiosettings['driver'] != {}:
        #    self.reset_driverdata(self.audiosettings['driver'])
#            driverdata = self.get_fullist_drivers(self.audiosettings['driver'])
#            self.audiosettings['driverparams'] = driverdata
#            print "driverdata: " + str(driverdata)
#            dmodel = self.treeview_driverparams.get_model() 
#            try:
#                dmodel.clear()
#            except:
#                pass
#            dmodel = self.create_model_driverlist(self.treeview_driverparams, driverdata)
#            self.treeview_driverparams.set_model(dmodel)        
        
        descs = self.get_driverdescs()
        self.init_driverlist(descs)  
        ## Select the driver and setup GUI    
           
        
    def create_model_audioparams(self, data):
        store = gtk.ListStore(gobject.TYPE_STRING,
                          gobject.TYPE_STRING,
                          gobject.TYPE_STRING,
                          gobject.TYPE_STRING)
        #data.sort()
        try:
            skeys = data.keys()
            skeys.sort()            
            for key in skeys:    
                outval = data[key]
                print str(key) + ' = ' + str(outval)            
                var = str(key)
                type = outval['type']
                defaultval = outval['defaultval']
                options = outval['examples']
                iter = store.append()
                store.set(iter, 0, var, 1, type, 2, defaultval, 3, options)         
        except:
            print "recieved no correct data for treemodel creation"
        return store  
            
    def add_columns_audioparams(self, treeview, model):
        renderer = gtk.CellRendererToggle()
        valuerender = gtk.CellRendererText()
        valuerender.set_property('editable', True)
        if treeview == self.treeview_audioparams:
            callbackfunc = self.edited_audioparams
        else:
            callbackfunc = self.edited_driverparams  
                      
        valuerender.connect('edited', callbackfunc, (model, 2))
        columns = []
        columns.append(gtk.TreeViewColumn(_('Variable'), gtk.CellRendererText(), text=0))
        columns.append(gtk.TreeViewColumn(_('Type'), gtk.CellRendererText(), text=1))
        columns.append(gtk.TreeViewColumn(_('Value'), valuerender, text=2))
        columns.append(gtk.TreeViewColumn(_('Description'), gtk.CellRendererText(), text=3))

        for column in columns:
            column.set_resizable(True)
            treeview.append_column(column)    
            
    def edited_audioparams(self, cell, path, new_text, user_data):
        print "path: " + str(path)
        print "cell: " + str(cell)
        print "new_text: " + str(new_text)
        print "user_data: " + str(user_data)
        model, column = user_data
        model = self.treeview_audioparams.get_model() 
        print "model: " + str(model)
        print "column: " + str(column)
        model[path][column] = new_text
        name = model[path][0]
        print "name: " + str(name)
        self.audiosettings['audioparams'][name]['defaultval'] = new_text
        return
    
    def edited_driverparams(self, cell, path, new_text, user_data):
        print "path: " + str(path)
        print "cell: " + str(cell)
        print "new_text: " + str(new_text)
        print "user_data: " + str(user_data)
        model, column = user_data
        model = self.treeview_driverparams.get_model() 
        print "model: " + str(model)
        print "column: " + str(column)
        model[path][column] = new_text
        name = model[path][0]
        print "name: " + str(name)
        self.audiosettings['driverparams'][name]['defaultval'] = new_text
        return    
    
    def init_driverlist(self, data):    
        #print 'data: ' + str(data)
        if data != {}:
            model = self.create_model_driverlist(self.combobox_driver, data)
        else:
            model = self.create_model_driverlist(self.combobox_driver, '')        
        self.combobox_driver.set_model(model)

        #find_driverentry = self.GTK_tools.search_combolist(self.combobox_driver, self.audiosettings['driver'])
        #if find_driverentry != None:
        #    self.combobox_driver.set_active(find_driverentry)
        #else:
       #     self.combobox_driver.set_active(0)         
            
    def create_model_driverlist(self, widget, data):
        cb = widget
        store = gtk.ListStore(gobject.TYPE_STRING)
        renderer = gtk.CellRendererText()
        #cb.pack_start(renderer)                
        try:
            skeys = data.keys()
            skeys.sort()
            for key in skeys:    
                outval = data[key]
                print 'Keys:' + str(key) + ' = ' + str(outval)            
                name = str(key)
                desc = outval['desc']
                iter = store.append()
                #iter = store.append_text()
                store.set(iter, 0, name)   
            #cb.set_active(0)            
        except:
            print "recieved no correct data for treemodel creation"
        return store

    def select_driver(self, widget):    
        active = widget.get_active()
        model = widget.get_model()
        row = model[active]
        item = row[0]          
        self.audiosettings['driver'] = item  
        #self.load_driverdata(self.audiosettings['driver'])
        self.reset_driverdata(self.audiosettings['driver'])
        
        
    def reset_driverdata(self, drivername):
        #print "resetting data: "
        data = self.get_fullist_drivers(drivername)
        #self.audiosettings['driverparams']
        self.audiosettings['driverparams'] = data
        #print "driverparams: " + str(data)
        #amodel = self.create_model_audioparams(audiodata)
        #print "amodel: " + str(amodel)
        #self.add_columns_audioparams(self.treeview_audioparams, amodel)
        model = self.treeview_driverparams.get_model() 
        try:
            model.clear()
        except:
            pass
        model = self.create_model_audioparams(data)
        self.treeview_driverparams.set_model(model)
        self.treeview_driverparams.show_all()        
        
        
    def load_driverdata(self, drivername):
        #print "resetting data: "
        #data = self.get_fullist_drivers(drivername)
        data = self.audiosettings['driverparams']
        #self.audiosettings['driverparams'] = data
        #print "driverparams: " + str(data)
        #amodel = self.create_model_audioparams(audiodata)
        #print "amodel: " + str(amodel)
        #self.add_columns_audioparams(self.treeview_audioparams, amodel)
        amodel = self.treeview_driverparams.get_model() 
        try:
            amodel.clear()
        except:
            pass
        amodel = self.create_model_audioparams(data)
        self.treeview_driverparams.set_model(amodel)
        self.treeview_driverparams.show_all()
        #descs = self.get_driverdescs()
        #self.init_driverlist(descs)        

    def cell_layout_data_func(self, cell_view, cell_renderer, model, iter):
        idx = model.get_path(iter)[0]
        item_text = model.get_value(iter, 0)
        cell_renderer.set_property('text', item_text)
        tip_text = "tooltip for ComboBox Entry '%s'"%item_text
        cv_parent = cell_view.get_parent()
        if isinstance(cv_parent, gtk.MenuItem) and (cv_parent not in  
    tipmap
    or tipmap[cv_parent] != tip_text):
            tipmap[cv_parent] = tip_text
            tooltips.set_tip(cv_parent, tip_text)             
    
    def dialog_audioparams_response(self, widget, response, *entry):
    
        if response == gtk.RESPONSE_OK or response == gtk.RESPONSE_APPLY:
            
            #self.audiosettings["settings_autoshow"] = self.checkbutton_autoshow_settings.get_active()



            #storetofile(self.settings, "mainsettings")
            #print "settings saved!"
            #self.refresh_ilist()
            #time.sleep(0.2)
            if self.callback_func != None:
                self.callback_func(self.audiosettings)
        
        #print 'entrypath: ' + entry_path
        if response == gtk.RESPONSE_OK:
            print "settings stored"
            widget.destroy ()
                
        if response == gtk.RESPONSE_CANCEL:
            print "aborted!"        
            widget.destroy ()    
                
                    
    def fetch_defaultsettings(self):
        self.helpout = qml_filehandlers.run_command(self.fetchcommand)
        #listexp1 = re.compile('([0-9]+)(\W+)(\w+)(\W+)(\w+)(\W+)([0-9]{4}-[0-9]{2}-[0-9]{2}\W{1}[0-9]{2}:[0-9]{2}:[0-9]{2})(\W+)([0-9:\.]+)')
        exp_sectiontitle_audioopts = re.compile('(Audio options:)')
        outstr_sectiontitle_audioopts = "\g<1>"
        
        exp_sectiontitle_drivers = re.compile('(Available drivers:)')
        outstr_sectiontitle_drivers = "\g<1>"
        
        exp_drivers_name = re.compile('(Name:)(\W)([a-zA-Z\W]+)')
        outstr_drivers_name = "\g<1>,\g<3>"
        
        exp_drivers_desc = re.compile('(Description:)(\W)(.+)')
        outstr_drivers_desc = "\g<1>,\g<3>"
        
        exp_sectiontitle_driveropts = re.compile('(Options:)')
        outstr_sectiontitle_driveropts = "\g<1>"
        
        #exp_envar_comment = re.compile('(Name:\W)([a-zA-Z\W]+)')
        
        exp_envar = re.compile('(\W+)([A-Z_]+)(:\W)([a-z]+)(,\W)(default)(\W=\W)(.+)')
        outstr_envar = "\g<2>,\g<4>,\g<6>,\g<8>"
        
        exp_envar_audio = re.compile('(\W+)(QEMU_AUDIO_[A-Z_]+)(:\W)([a-z]+)(,\W)(default)(\W=\W)(.+)')
        outstr_envar_audio = "\g<2>,\g<4>,\g<6>,\g<8>"
        
        exp_envar_commented = re.compile('(\W+)([A-Z_]+)(:\W)([a-z]+)(,\W)(default)( = )([/a-zA-Z0-9]+)(,*\w*\W+)(\W*)(\w+)')
        outstr_envar_commented = "\g<2>,\g<4>,\g<6>,\g<8>,\g<11>"
        
        exp_envar_comment = re.compile('(\W+)(\w+)')
        outstr_envar_comment = "\g<2>"
        
        outlist = filter(None, self.helpout)
        
        checked_audioopts = False
        checked_drivers = False
        last_driver = None
        
        for line in outlist:
            check_sectiontitle_audioopts = exp_sectiontitle_audioopts.search(line)
            check_envar_commented = exp_envar.search(line)
            check_envar_audio = exp_envar_audio.search(line)
            check_sectiontitle_drivers = exp_sectiontitle_drivers.search(line)
            check_drivers_name = exp_drivers_name.search(line)
            check_drivers_desc = exp_drivers_desc.search(line)
            
            if check_sectiontitle_audioopts != None and check_sectiontitle_audioopts != '':
                checked_audioopts = True
                checkstr = check_sectiontitle_audioopts.group()
                checksub = exp_sectiontitle_audioopts.sub(outstr_sectiontitle_audioopts, checkstr)
                datalist = checksub.split(",")
                self.helplist.append(datalist)
                
            else:
                #print "other:"
                if check_sectiontitle_drivers == None or check_sectiontitle_drivers == '':    
                    if check_envar_commented != None and check_envar_commented != '':
                        checkstr = check_envar_commented.group()
                        checksub = exp_envar.sub(outstr_envar, checkstr)
                        datalist = checksub.split(",")
                        self.helplist.append(datalist)
                        #print 'check_envar_commented: ' + str(datalist)
                        if check_envar_audio != None:
                            #print str(datalist)
                            valuelist = copy(datalist)
                            del valuelist[0]
                            #self.valuedict["audioparams"][datalist[0]] = valuelist
                            self.audioparams[datalist[0]] = valuelist
                            #print "self.valuedict[\"audioparams\"][" + datalist[0] + "] = " + str(valuelist)
                        elif checked_drivers == True and last_driver != None:
                            valuelist = copy(datalist)
                            del valuelist[0]
                            #self.valuedict[last_driver]["driverparams"][datalist[0]] = valuelist 
                            if self.driverparams.has_key(last_driver):
                                self.driverparams[last_driver].append(datalist)
                            else:
                                self.driverparams[last_driver] = [datalist]
                            
                else:  
                    checked_drivers = True 
                    checkstr = check_sectiontitle_drivers.group()
                    checksub = exp_sectiontitle_drivers.sub(outstr_sectiontitle_drivers, checkstr)
                    datalist = checksub.split(",")
                    self.helplist.append(datalist)
                if check_drivers_name != None and check_drivers_name != '':
                    checkstr = check_drivers_name.group()
                    checksub = exp_drivers_name.sub(outstr_drivers_name, checkstr)
                    datalist = checksub.split(",")
                    self.helplist.append(datalist)
                    last_driver = string.strip(str(datalist[1]))
                elif check_drivers_desc != None and check_drivers_desc != '':
                    checkstr = check_drivers_desc.group()
                    checksub = exp_drivers_desc.sub(outstr_drivers_desc, checkstr)
                    datalist = checksub.split(",")
                    self.helplist.append(datalist)  
                    if checked_drivers == True and last_driver != None:
                        valuelist = copy(datalist)
                        del valuelist[0]
                        #self.valuedict.append([last_driver]['driverdesc'][datalist[0]] = valuelist
                        self.driverdescs[last_driver] = datalist
                        
        self.valuedict['audioparams'] = self.audioparams
        self.valuedict['driverparams'] = self.driverparams
        self.valuedict["driverdescs"] = self.driverdescs
        #self.valuedict.sort()
                                     
        return self.valuedict 
    
    def get_value(self, var): 
        returnval = None
        #runenv = Audio_environment()
        audioenvironment = self.fetch_defaultsettings() 
        for key in audioenvironment['audioparams'].keys():
            if var == key:
                returnval = str(audioenvironment['audioparams'][key][2])
        if returnval == None:
            for vars in audioenvironment['driverparams'].keys():
                #print 'vars: ' + str(vars)
                for data in audioenvironment['driverparams'][vars]:
                    name = str(data[0])
                    outval = str(data[3])
                    if var == name:
                        #print 'data: ' + str(data)
                        #print 'result: ' + name
                        returnval = outval
        return returnval    
    
    def get_defaults_audio(self): 
        #returnval = None
        returndict = {}
        #runenv = Audio_environment()
        audioenvironment = self.fetch_defaultsettings() 
        for key in audioenvironment['audioparams'].keys():
            returndict[key] = str(audioenvironment['audioparams'][key][2])
        return returndict    
    
    def get_fullist_audio(self):
        returndict = {}
        #runenv = Audio_environment()
        audioenvironment = self.fetch_defaultsettings() 
        for key in audioenvironment['audioparams'].keys():
            
            #returndict[key] = ('type' : str(audioenvironment['audioparams'][key][0])
            type = str(audioenvironment['audioparams'][key][0])
            defaultval = str(audioenvironment['audioparams'][key][2])
            try:
                examples = str(audioenvironment['audioparams'][key][3])
            except:
                examples = ''
            dic = {"type" : type, "defaultval" : defaultval, "examples" : examples}
            returndict[key] = dic
        return returndict      
    
    def get_defaults_drivers(self, driver='All'): 
        returndict = {}
        #runenv = Audio_environment()    
    
    def get_defaults_drivers(self, driver='All'): 
        returndict = {}
        #runenv = Audio_environment()
        audioenvironment = self.fetch_defaultsettings() 
        for vars in audioenvironment['driverparams'].keys():
            #print 'vars: ' + str(vars)
            for data in audioenvironment['driverparams'][vars]:
                #if exists(driver):
                if driver != 'All':
                    #print 'driver search: ' + str(driver)
                    if driver == vars:
                        name = str(data[0])
                        outval = str(data[3])
                        returndict[name] = outval
                        
                else:
                    name = str(data[0])
                    outval = str(data[3])
                    returndict[name] = outval
        return returndict 
    
    def get_fullist_drivers(self, driver='All'): 
        returndict = {}
        audioenvironment = self.fetch_defaultsettings() 
        for vars in audioenvironment['driverparams'].keys():
            #print 'vars: ' + str(vars)
            for data in audioenvironment['driverparams'][vars]:
                name = str(data[0])
                type = str(data[1])
                defaultval = str(data[3])
                try:
                    examples = str(data[4])
                except:
                    examples = ''
                dic = {"type" : type, "defaultval" : defaultval, "examples" : examples}             
                if driver != 'All':
                    #print 'driver search: ' + str(driver)
                    if driver == vars:
                        returndict[name] = dic
                else:
                    returndict[name] = dic
        return returndict  
    
    def get_driverdescs(self): 
        returndict = {}
        audioenvironment = self.fetch_defaultsettings() 
        for vars in audioenvironment['driverdescs'].keys():
            #print 'vars: ' + str(vars)
            for data in audioenvironment['driverdescs'][vars]:
                name = str(vars)
                #type = str(data[1])
                desc = str(data)
                
                dic = {"desc" : desc,}             
                returndict[name] = dic
        return returndict       
    
    def get_driverlist(self): 
        #returndict = {}
        returnlist = []
        #runenv = Audio_environment()
        audioenvironment = self.fetch_defaultsettings() 
        for dvar in audioenvironment['driverparams'].keys():
            #self.valuedict["driverdescs"]
            desc = audioenvironment['driverdescs'][dvar][1]
            print 'vars: ' + str(dvar) + ' - ' + str(desc)
            returnval = [dvar, desc]
            returnlist.append(returnval)
            
        return returnlist        
           
        
runenv = Audio_environment()
audioenvironment = runenv.fetch_defaultsettings()
#
#testval = runenv.get_value('QEMU_OSS_DEBUG')
#print '??????????????????????????????'
#print "testsearch: " + str(testval)
#print '??????????????????????????????'
#
#for key in audioenvironment.keys():
#    var = key
#    datalist = audioenvironment[key]
#    print '-------------------------------------------'
#    print str(var) + ": "
#    #print str(datalist)
#    #for data in datalist:
#    for key in datalist.keys():
#        print key + ' : ' + str(datalist[key])
        
#print '--------------- driverdescs ----------------------------'
#testvars_driverdescs = runenv.get_driverdescs()
##print 'testvars: ' + str(testvars)
##for data in testvars:
#for key in testvars_driverdescs.keys():    
#    outval = testvars_driverdescs[key]
#    print key + ' = ' + str(outval)           
#print '--------------- full audioparams ----------------------------'
#testvars = runenv.get_fullist_audio()
##print 'testvars: ' + str(testvars)
##for data in testvars:
#for key in testvars.keys():    
#    outval = testvars[key]
#    print key + ' = ' + str(outval)
#
#print '--------------- default audioparams ----------------------------'
#testdrives = runenv.get_defaults_audio()
##print 'testvars: ' + str(testvars)
##for data in testvars:
#for key in testdrives.keys():    
#    outval = testdrives[key]
#    print key + ' = ' + str(outval)  
#        
#print '--------------- full driverparams ----------------------------'
#testvars_alldrivers = runenv.get_fullist_drivers()
##print 'testvars: ' + str(testvars)
##for data in testvars:
#for key in testvars_alldrivers.keys():    
#    outval = testvars_alldrivers[key]
#    print key + ' = ' + str(outval)    
#print '--------------- default driverparams ----------------------------'
#testdrives = runenv.get_defaults_drivers()
##print 'testvars: ' + str(testvars)
##for data in testvars:
#for key in testdrives.keys():    
#    outval = testdrives[key]
#    print key + ' = ' + str(outval)               
