/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#ifndef CGOOGLETOOLVIEW_H
#define CGOOGLETOOLVIEW_H

#include <QWidget>
#include <QByteArray>

#include "ui_IToolViewGoogle.h"

class QHttp;
class QMenu;

class CToolViewGoogle : public QWidget, private Ui::IToolViewGoogle
{
    Q_OBJECT
        public:
        CToolViewGoogle(QWidget * parent);
        virtual ~CToolViewGoogle();

    protected slots:
        void slotReturnPressed();
        void slotRequestStarted(int id);
        void slotRequestFinished(int id, bool error);
        void slotSelectQueryItem(QListWidgetItem * item);
        void slotProxyChanged();

        void slotContextMenu(const QPoint& pos);

        void slotAddWaypoint();

    protected:
        QHttp * google;
        QStringList lastSearchItems;

        QMenu * contextMenu;

};
#endif                           //CGOOGLETOOLVIEW_H
