/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "GarminIcons.h"

#include <QtGui>
/*
    Based on information provided by Ian Cowley, Sigurd Humerfelt, Robert Lipe
    and Garmin MapSource
*/
const char * wptDefault = ":/icons/wpt/flag15x15.png";

garmin_icon_t GarminIcons[] =
{
    /*	  mps    pcx    desc */
    { wptDefault, 16384, "Airport" },
    { wptDefault,  8204, "Amusement Park" },
    { wptDefault,   169, "Ball Park" },
    { wptDefault,     6, "Bank" },
    { wptDefault,    13, "Bar" },
    { wptDefault,  8244, "Beach" },
    { wptDefault,     1, "Bell" },
    { wptDefault,   150, "Boat Ramp" },
    { wptDefault,  8205, "Bowling" },
    { wptDefault,  8233, "Bridge" },
    { wptDefault,  8234, "Building" },
    { wptDefault,   151, "Campground" },
    { ":/icons/wpt/car15x15.png",   170, "Car" },
    { wptDefault,  8206, "Car Rental" },
    { wptDefault,  8207, "Car Repair" },
    { wptDefault,  8235, "Cemetery" },
    { wptDefault,  8236, "Church" },
    { wptDefault,   179, "Circle with X" },
    { ":/icons/wpt/capitol_city15x15.png",  8203, "City (Capitol)" },
    { ":/icons/wpt/large_city15x15.png",  8200, "City (Large)" },
    { ":/icons/wpt/medium_city15x15.png",  8199, "City (Medium)" },
    { ":/icons/wpt/small_city15x15.png",  8198, "City (Small)" },
    { ":/icons/wpt/small_city15x15.png",  8198, "Small City" },
    { wptDefault,  8237, "Civil" },
    { wptDefault,  8262, "Contact, Afro" },
    { wptDefault,  8272, "Contact, Alien" },
    { wptDefault,  8258, "Contact, Ball Cap" },
    { wptDefault,  8259, "Contact, Big Ears" },
    { wptDefault,  8271, "Contact, Biker" },
    { wptDefault,  8273, "Contact, Bug" },
    { wptDefault,  8274, "Contact, Cat" },
    { wptDefault,  8275, "Contact, Dog" },
    { wptDefault,  8263, "Contact, Dreadlocks" },
    { wptDefault,  8264, "Contact, Female1" },
    { wptDefault,  8265, "Contact, Female2" },
    { wptDefault,  8266, "Contact, Female3" },
    { wptDefault,  8261, "Contact, Goatee" },
    { wptDefault,  8268, "Contact, Kung-Fu" },
    { wptDefault,  8276, "Contact, Pig" },
    { wptDefault,  8270, "Contact, Pirate" },
    { wptDefault,  8267, "Contact, Ranger" },
    { wptDefault,  8257, "Contact, Smiley" },
    { wptDefault,  8260, "Contact, Spike" },
    { wptDefault,  8269, "Contact, Sumo" },
    { wptDefault,   165, "Controlled Area" },
    { wptDefault,  8220, "Convenience Store" },
    { ":/icons/wpt/crossing15x15.png",  8238, "Crossing" },
    { wptDefault,   164, "Dam" },
    { ":/icons/wpt/danger15x15.png",   166, "Danger Area" },
    { wptDefault,  8218, "Department Store" },
    { wptDefault,     4, "Diver Down Flag 1" },
    { wptDefault,     5, "Diver Down Flag 2" },
    { wptDefault,   154, "Drinking Water" },
    { wptDefault,   177, "Exit" },
    { wptDefault,  8208, "Fast Food" },
    { wptDefault,     7, "Fishing Area" },
    { wptDefault,  8209, "Fitness Center" },
    { wptDefault,   178, "Flag" },
    { ":/icons/wpt/tree15x15.png",  8245, "Forest" },
    { wptDefault,     8, "Gas Station" },
    { ":/icons/wpt/geocache15x15.png",  8255, "Geocache" },
    { ":/icons/wpt/geocache_fnd15x15.png",  8256, "Geocache Found" },
    { wptDefault,  8239, "Ghost Town" },
    { wptDefault, 16393, "Glider Area" },
    { wptDefault,  8197, "Golf Course" },
    { wptDefault,2, "Green Diamond" },
    { wptDefault,    15, "Green Square" },
    { wptDefault, 16388, "Heliport" },
    { wptDefault,     9, "Horn" },
    { wptDefault,   171, "Hunting Area" },
    { ":/icons/wpt/info15x15.png",   157, "Information" },
    { wptDefault,  8240, "Levee" },
    { wptDefault,    12, "Light" },
    { wptDefault,  8221, "Live Theater" },
    { wptDefault,   173, "Lodging" },
    { wptDefault,   173, "Hotel" },
    { wptDefault,    21, "Man Overboard" },
    { wptDefault,     0, "Marina" },
    { wptDefault,   156, "Medical Facility" },
    { ":/icons/wpt/mile_marker15x15.png",  8195, "Mile Marker" },
    { wptDefault,  8241, "Military" },
    { wptDefault,   174, "Mine" },
    { wptDefault,  8210, "Movie Theater" },
    { wptDefault,  8211, "Museum" },
    { wptDefault,    22, "Navaid, Amber" },
    { wptDefault,    23, "Navaid, Black" },
    { wptDefault,    24, "Navaid, Blue" },
    { wptDefault,    25, "Navaid, Green" },
    { wptDefault,    26, "Navaid, Green/Red" },
    { wptDefault,    27, "Navaid, Green/White" },
    { wptDefault,    28, "Navaid, Orange" },
    { wptDefault,    29, "Navaid, Red" },
    { wptDefault,    30, "Navaid, Red/Green" },
    { wptDefault,    31, "Navaid, Red/White" },
    { wptDefault,    32, "Navaid, Violet" },
    { wptDefault,    33, "Navaid, White" },
    { wptDefault,    34, "Navaid, White/Green" },
    { wptDefault,    35, "Navaid, White/Red" },
    { wptDefault,  8242, "Oil Field" },
    { wptDefault, 16395, "Parachute Area" },
    { wptDefault,   159, "Park" },
    { ":/icons/wpt/parking15x15.png",   158, "Parking Area" },
    { wptDefault,  8212, "Pharmacy" },
    { wptDefault,   160, "Picnic Area" },
    { wptDefault,  8213, "Pizza" },
    { wptDefault,  8214, "Post Office" },
    { wptDefault, 16389, "Private Field" },
    { wptDefault,    37, "Radio Beacon" },
    { wptDefault,  3, "Red Diamond" },
    { wptDefault,    16, "Red Square" },
    { ":/icons/wpt/house15x15.png",    10, "Residence" },
    { ":/icons/wpt/house15x15.png",    10, "House" },
    { wptDefault,    11, "Restaurant" },
    { wptDefault,   167, "Restricted Area" },
    { wptDefault,   152, "Restroom" },
    { wptDefault,  8215, "RV Park" },
    { wptDefault,  8226, "Scales" },
    { wptDefault,   161, "Scenic Area" },
    { wptDefault,  8216, "School" },
    { wptDefault, 16402, "Seaplane Base" },
    { wptDefault,    19, "Shipwreck" },
    { wptDefault,   172, "Shopping Center" },
    { wptDefault, 16392, "Short Tower" },
    { wptDefault,   153, "Shower" },
    { wptDefault,   162, "Skiing Area" },
    { wptDefault,    14, "Skull and Crossbones" },
    { wptDefault, 16390, "Soft Field" },
    { ":/icons/wpt/stadium15x15.png",  8217, "Stadium" },
    { ":/icons/wpt/summit15x15.png",  8246, "Summit" },
    { wptDefault,   163, "Swimming Area" },
    { wptDefault, 16391, "Tall Tower" },
    { wptDefault,   155, "Telephone" },
    { ":/icons/wpt/toll15x15.png",  8227, "Toll Booth" },
    { wptDefault,  8196, "TracBack Point" },
    { wptDefault,   175, "Trail Head" },
    { wptDefault,   176, "Truck Stop" },
    { wptDefault,  8243, "Tunnel" },
    { wptDefault, 16394, "Ultralight Area" },
    {                            /* new in MapSource V5 */
        wptDefault,  8282, "Water Hydrant"
    },
    { wptDefault,    18, "Waypoint" },
    { wptDefault,    17, "White Buoy" },
    { wptDefault,    36, "White Dot" },
    { wptDefault,  8219, "Zoo" },

    /* Custom icons.   The spec reserves 7680-8191 for the custom
     * icons on the C units, Quest, 27xx, 276, 296,  and other units.
     * Note that firmware problems on the earlier unit result in these
     * being mangled, so be sure you're on a version from at least
     * late 2005.
     * {    -2,  7680, "Custom 0" },
     * ....
     * {    -2,  8192, "Custom 511" },
     */
    { ":/icons/wpt/custom15x15.bmp",  7680, "Custom 1" },
    { ":/icons/wpt/custom15x15.bmp",  7681, "Custom 2" },
    { ":/icons/wpt/custom15x15.bmp",  7682, "Custom 3" },
    { ":/icons/wpt/custom15x15.bmp",  7683, "Custom 4" },
    { ":/icons/wpt/custom15x15.bmp",  7684, "Custom 5" },
    { ":/icons/wpt/custom15x15.bmp",  7685, "Custom 6" },
    { ":/icons/wpt/custom15x15.bmp",  7686, "Custom 7" },
    { ":/icons/wpt/custom15x15.bmp",  7687, "Custom 8" },
    { ":/icons/wpt/custom15x15.bmp",  7688, "Custom 9" },
    { ":/icons/wpt/custom15x15.bmp",  7689, "Custom 10" },
    { ":/icons/wpt/custom15x15.bmp",  7690, "Custom 11" },
    { ":/icons/wpt/custom15x15.bmp",  7691, "Custom 12" },
    { ":/icons/wpt/custom15x15.bmp",  7692, "Custom 13" },
    { ":/icons/wpt/custom15x15.bmp",  7693, "Custom 14" },
    { ":/icons/wpt/custom15x15.bmp",  7694, "Custom 15" },
    { ":/icons/wpt/custom15x15.bmp",  7695, "Custom 16" },
    { ":/icons/wpt/custom15x15.bmp",  7696, "Custom 17" },
    { ":/icons/wpt/custom15x15.bmp",  7697, "Custom 18" },
    { ":/icons/wpt/custom15x15.bmp",  7698, "Custom 19" },
    { ":/icons/wpt/custom15x15.bmp",  7699, "Custom 20" },
    { ":/icons/wpt/custom15x15.bmp",  7700, "Custom 21" },
    { ":/icons/wpt/custom15x15.bmp",  7701, "Custom 22" },
    { ":/icons/wpt/custom15x15.bmp",  7702, "Custom 23" },
    { ":/icons/wpt/custom15x15.bmp",  7703, "Custom 24" },

    {                            /* icon for "Toll Booth" */
        ":/icons/wpt/toll15x15.png",  8227, "Micro-Cache"
    },
    {                            /* icon for "Scenic Area" */
        wptDefault,   161, "Virtual cache"
    },
    {                            /* icon for "Stadium" */
        ":/icons/wpt/box_blue15x15.png",  8217, "Multi-Cache"
    },
    {                            /* icon for "Information" */
        wptDefault,   157, "Unknown Cache"
    },
    {                            /* Icon for "Flag" */
        wptDefault,   178, "Locationless (Reverse) Cache"
    },
    {                            /* Icon for "Post Office" */
        wptDefault,  8214, "Post Office"
    },
    {                            /* Icon for "Event" */
        wptDefault,   160, "Event Cache"
    },
    {                            /* Icon for "Live Theatre" */
        wptDefault,  8221, "Webcam Cache"
    },

    /* MapSource V6.x */

    { ":/icons/wpt/flag_pin_red15x15.png",  8286, "Flag, Red" },
    { ":/icons/wpt/flag_pin_blue15x15.png",  8284, "Flag, Blue" },
    { ":/icons/wpt/flag_pin_green15x15.png",  8285, "Flag, Green" },
    { ":/icons/wpt/pin_red15x15.png",  8289, "Pin, Red" },
    { ":/icons/wpt/pin_blue15x15.png",  8287, "Pin, Blue" },
    { ":/icons/wpt/pin_green15x15.png",  8288, "Pin, Green" },
    { ":/icons/wpt/box_red15x15.png",  8292, "Block, Red" },
    { ":/icons/wpt/box_blue15x15.png",  8290, "Block, Blue" },
    { ":/icons/wpt/box_green15x15.png",  8291, "Block, Green" },
    { wptDefault,  8293, "Bike Trail" },
    { wptDefault,   181, "Fishing Hot Spot Facility" },
    { wptDefault,  8249, "Police Station"},
    { wptDefault,  8251, "Ski Resort" },
    { wptDefault,  8252, "Ice Skating" },
    { wptDefault,  8253, "Wrecker" },
    { wptDefault,   184, "Anchor Prohibited" },
    { wptDefault,   185, "Beacon" },
    { wptDefault,   186, "Coast Guard" },
    { wptDefault,   187, "Reef" },
    { wptDefault,   188, "Weed Bed" },
    { wptDefault,   189, "Dropoff" },
    { wptDefault,   190, "Dock" },

    /* New in Garmin protocol spec from June 2006.  Extracted from
     * spec and fed through some horrible awk to add ones we didn't
     * have before but normalized for consistency. */
    { wptDefault,  8359, "Asian Food" },
    { wptDefault,  8296, "Blue Circle" },
    { wptDefault,  8299, "Blue Diamond" },
    { wptDefault,  8317, "Blue Letter A" },
    { wptDefault,  8318, "Blue Letter B" },
    { ":/icons/wpt/letter_c_blue15x15.png",  8319, "Blue Letter C" },
    { wptDefault,  8320, "Blue Letter D" },
    { wptDefault,  8341, "Blue Number 0" },
    { wptDefault,  8342, "Blue Number 1" },
    { wptDefault,  8343, "Blue Number 2" },
    { wptDefault,  8344, "Blue Number 3" },
    { wptDefault,  8345, "Blue Number 4" },
    { wptDefault,  8346, "Blue Number 5" },
    { wptDefault,  8347, "Blue Number 6" },
    { wptDefault,  8348, "Blue Number 7" },
    { wptDefault,  8349, "Blue Number 8" },
    { wptDefault,  8350, "Blue Number 9" },
    { wptDefault,  8302, "Blue Oval" },
    { wptDefault,  8305, "Blue Rectangle" },
    { wptDefault,  8308, "Blue Square" },
    { wptDefault,  8351, "Blue Triangle" },
    { wptDefault,  8254, "Border Crossing (Port Of Entry)" },
    { wptDefault,   182, "Bottom Conditions" },
    { wptDefault,  8360, "Deli" },
    { wptDefault,  8228, "Elevation point" },
    { wptDefault,  8229, "Exit without services" },
    { wptDefault, 16398, "First approach fix" },
    { wptDefault,  8250, "Gambling/casino" },
    { wptDefault,  8232, "Geographic place name, land" },
    { wptDefault,  8230, "Geographic place name, Man-made" },
    { wptDefault,  8231, "Geographic place name, water" },
    { wptDefault,  8295, "Green circle" },
    { wptDefault,  8313, "Green Letter A" },
    { wptDefault,  8315, "Green Letter B" },
    { wptDefault,  8314, "Green Letter C" },
    { wptDefault,  8316, "Green Letter D" },
    { wptDefault,  8331, "Green Number 0" },
    { wptDefault,  8332, "Green Number 1" },
    { wptDefault,  8333, "Green Number 2" },
    { wptDefault,  8334, "Green Number 3" },
    { wptDefault,  8335, "Green Number 4" },
    { wptDefault,  8336, "Green Number 5" },
    { wptDefault,  8337, "Green Number 6" },
    { wptDefault,  8338, "Green Number 7" },
    { wptDefault,  8339, "Green Number 8" },
    { wptDefault,  8340, "Green Number 9" },
    { wptDefault,  8301, "Green Oval" },
    { wptDefault,  8304, "Green Rectangle" },
    { wptDefault,  8352, "Green Triangle" },
    { wptDefault, 16385, "Intersection" },
    { wptDefault,  8201, "Intl freeway hwy" },
    { wptDefault,  8202, "Intl national hwy" },
    { wptDefault,  8361, "Italian food" },
    { wptDefault,  8248, "Large exit without services" },
    { wptDefault,  8247, "Large Ramp intersection" },
    { wptDefault, 16399, "Localizer Outer Marker" },
    { wptDefault, 16400, "Missed approach point" },
    { wptDefault, 16386, "Non-directional beacon" },
    { wptDefault,   168, "Null" },
    { wptDefault,   180, "Open 24 Hours" },
    { wptDefault,  8222, "Ramp intersection" },
    { wptDefault,  8294, "Red circle" },
    { wptDefault,  8309, "Red Letter A" },
    { wptDefault,  8310, "Red Letter B" },
    { wptDefault,  8311, "Red Letter C" },
    { wptDefault,  8312, "Red Letter D" },
    { wptDefault,  8321, "Red Number 0" },
    { wptDefault,  8322, "Red Number 1" },
    { wptDefault,  8323, "Red Number 2" },
    { wptDefault,  8324, "Red Number 3" },
    { wptDefault,  8325, "Red Number 4" },
    { wptDefault,  8326, "Red Number 5" },
    { wptDefault,  8327, "Red Number 6" },
    { wptDefault,  8328, "Red Number 7" },
    { wptDefault,  8329, "Red Number 8" },
    { wptDefault,  8330, "Red Number 9" },
    { wptDefault,  8300, "Red Oval" },
    { wptDefault,  8303, "Red Rectangle" },
    { wptDefault,  8353, "Red Triangle" },
    { wptDefault,  8362, "Seafood" },
    { wptDefault,  8194, "State Hwy" },
    { wptDefault,  8363, "Steak" },
    { wptDefault,  8223, "Street Intersection" },
    { wptDefault, 16401, "TACAN" },
    { wptDefault,   183, "Tide/Current PRediction Station" },
    { wptDefault,   191, "U Marina" },
    { wptDefault,  8193, "US hwy" },
    { wptDefault,   193, "U stump" },
    { wptDefault, 16387, "VHF Omni-range" },
    { wptDefault, 16397, "VOR-DME" },
    { wptDefault, 16396, "VOR/TACAN" },
    { 0,    -1, 0 },
};

QPixmap loadIcon(const QString& path)
{
    QFileInfo finfo(path);
    if(finfo.completeSuffix() != "bmp") {
        return QPixmap(path);
    }
    else {
        QImage img = QPixmap(path).toImage().convertToFormat(QImage::Format_Indexed8);
        img.setColor(0,qRgba(0,0,0,0));
        return QPixmap::fromImage(img);
    }

    return QPixmap();
}


void InitCustomIcons()
{
    QSettings cfg;
    cfg.beginGroup("icons");

    for(int i = 0; i < N_CUSTOM_ICONS; ++i) {
        garmin_icon_t * desc = GarminIcons;
        while(desc->icon != 0) {
            if(desc->id == (CUSTOM_ICONS_ID0 + i)) {
                desc->icon = cfg.value(QString("Custom%1").arg(i),":/icons/wpt/custom15x15.bmp").toString();
                break;
            }
            ++desc;
        }
    }

    cfg.endGroup();
}


void FreeCustomIcons()
{
    QSettings cfg;
    cfg.beginGroup("icons");

    for(int i = 0; i < N_CUSTOM_ICONS; ++i) {
        garmin_icon_t * desc = GarminIcons;
        while(desc->icon != 0) {
            if(desc->id == (CUSTOM_ICONS_ID0 + i)) {
                cfg.setValue(QString("Custom%1").arg(i), desc->icon);
                break;
            }
            ++desc;
        }
    }

    cfg.endGroup();
}


void setWptIconById(const uint16_t id, const QString& src)
{
    garmin_icon_t * desc = GarminIcons;
    while(desc->icon != 0) {
        if(desc->id == id) {
            desc->icon = src;
            return;
        }
        ++desc;
    }
}


void getWptIconById(const uint16_t id, QPixmap& pix)
{
    garmin_icon_t * desc = GarminIcons;
    while(desc->icon != 0) {
        if(desc->id == id) {
            pix = loadIcon(desc->icon);
            return;
        }
        ++desc;
    }
}


void getWptIconById(const uint16_t id, QPixmap& pix, QString& lbl)
{
    garmin_icon_t * desc = GarminIcons;
    while(desc->icon != 0) {
        if(desc->id == id) {
            pix = loadIcon(desc->icon);
            lbl = desc->name;
            return;
        }
        ++desc;
    }
}


void getWptIconById(const uint16_t id, QPixmap& pix, QString& lbl, QString& src)
{
    garmin_icon_t * desc = GarminIcons;
    while(desc->icon != 0) {
        if(desc->id == id) {
            pix = loadIcon(desc->icon);
            lbl = desc->name;
            src = desc->icon;
            return;
        }
        ++desc;
    }
}


extern void getWptIconByName(const QString& name, uint16_t& id)
{
    garmin_icon_t * desc = GarminIcons;
    while(desc->icon != 0) {
        if(name == desc->name) {
            id  = desc->id;
            return;
        }
        ++desc;
    }
    qDebug() << "getWptIconByName" << name << "not found";
}


extern void getWptIconByName(const QString& name, uint16_t& id, QPixmap& pix)
{
    garmin_icon_t * desc = GarminIcons;
    while(desc->icon != 0) {
        if(name == desc->name) {
            id  = desc->id;
            pix = loadIcon(desc->icon);
            return;
        }
        ++desc;
    }
    qDebug() << "getWptIconByName" << name << "not found";
}
