#include <stdio.h>      
#include <stdlib.h>     
#include <unistd.h>
#include <getopt.h>  
#include <qapplication.h>
#include <qmainwindow.h>
#include <qmenubar.h>   
#include <qpopupmenu.h>
#include "gui.h"

static struct option options[] =
        {{"help", 0, 0, 'h'},
         {"channel", 1, 0, 'c'},
         {"num_controller", 1, 0, 'n'},
         {"offset", 1, 0, 'o'},
         {0, 0, 0, 0}};

int main(int argc, char *argv[])  
{
  QApplication *qApp = new QApplication(argc, argv);
  QMainWindow *top = new QMainWindow();
  top->setCaption("QMidiControl");
  int getopt_return;
  int option_index; 
  int offset = 1;
  int channel = 0;
  int number = 16;

  while((getopt_return = getopt_long(argc, argv, "hc:o:n:", options, &option_index)) >= 0) {
    switch(getopt_return) {
    case 'c':
        channel = atoi(optarg);
        break;
    case 'o':
        offset = atoi(optarg);
        break;
    case 'n':
        number = atoi(optarg);
        break;
    case 'h':
        printf("\n%s\n", aboutText.latin1());
        printf("--channel <num>          MIDI Channel [0]\n");
        printf("--num_controller <num>   Number of Controllers [16]\n");
        printf("--offset <num>           Offset for Controller [1]\n\n");
        exit(EXIT_SUCCESS);
    }
  }
  Gui *gui = new Gui(number, channel, offset, top);
  QPopupMenu *filePopup = new QPopupMenu(top); 
  QPopupMenu *aboutMenu = new QPopupMenu(top);
  top->menuBar()->insertItem("&File", filePopup);
  top->menuBar()->insertSeparator(); top->menuBar()->insertItem("&About", aboutMenu); 
  filePopup->insertItem("&Quit", qApp, SLOT(quit()));
  aboutMenu->insertItem("About QMidiControl", gui, SLOT(displayAbout())); 
  top->setCentralWidget(gui); 
  top->show();
  qApp->setMainWidget(top); 
  return qApp->exec(); 
}
