#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qlabel.h>
#include <qslider.h> 
#include <qhbox.h>
#include <qvbox.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qstrlist.h>
#include <qhgroupbox.h>
#include <qvgroupbox.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qregexp.h>
#include "midimap.h"
#include "mapwidget.h"

MapWidget::MapWidget(MidiMap *p_midiMap, int portCount, QWidget *parent, const char *name) : QVBox(parent, name) {

  setMargin(5);
  setSpacing(10);
  QHBox *ioBox = new QHBox(this);
  QVGroupBox *inBox = new QVGroupBox("Event Input", ioBox);
  QVGroupBox *outBox = new QVGroupBox("Event Output", ioBox);
  midiMap = p_midiMap;
  QHBox *typeInBox = new QHBox(inBox);
  QLabel *typeInLabel = new QLabel("Type:", typeInBox);
  typeInHighlight = 0;
  typeIn = new QComboBox(typeInBox);
  QObject::connect(typeIn, SIGNAL(highlighted(int)), this, SLOT(updateTypeIn(int)));
  QHBox *typeOutBox = new QHBox(outBox);
  QLabel *typeOutLabel = new QLabel("Type:", typeOutBox);
  typeOut = new QComboBox(typeOutBox);
  QObject::connect(typeOut, SIGNAL(highlighted(int)), this, SLOT(updateTypeOut(int)));
  QStrList *typeNames = new QStrList(true);
  typeNames->append("Note");    
  typeNames->append("Controller");    
  typeNames->append("Pitchbend");    
  typeNames->append("Program Change");    
  typeIn->insertStrList(typeNames);
  typeOut->insertStrList(typeNames);

  QHBox *spinInContainer = new QHBox(inBox);
  QVBox *spinInLabel = new QVBox(spinInContainer);
  QVBox *spinInSpin1 = new QVBox(spinInContainer);
  QVBox *spinInSpin2 = new QVBox(spinInContainer);
  QLabel *chInLabel = new QLabel("Channel:", spinInLabel);
  chIn[0] = new QSpinBox(0, 15, 1, spinInSpin1);
  chIn[1] = new QSpinBox(0, 15, 1, spinInSpin2);
  QObject::connect(chIn[0], SIGNAL(valueChanged(int)), this, SLOT(updateChIn(int)));
  QObject::connect(chIn[1], SIGNAL(valueChanged(int)), this, SLOT(updateChIn(int)));
  QHBox *chIndexOutBox = new QHBox(outBox);
  QVBox *chIndexLabelBox = new QVBox(chIndexOutBox);
  QVBox *chIndexComboBox = new QVBox(chIndexOutBox);
  QVBox *chIndexSpinBox = new QVBox(chIndexOutBox);
  QLabel *chOutLabel = new QLabel("Channel: ", chIndexLabelBox);
  chOutMode = new QComboBox(chIndexComboBox);
  QObject::connect(chOutMode, SIGNAL(highlighted(int)), this, SLOT(updateChOutMode(int)));
  chOut = new QSpinBox(-15, 15, 1, chIndexSpinBox);
  chOut->setValue(0);
  QObject::connect(chOut, SIGNAL(valueChanged(int)), this, SLOT(updateChOut(int)));
  QStrList *chOutModeNames = new QStrList(true);
  chOutModeNames->append("Offset");    
  chOutModeNames->append("Reverse, Offset");    
  chOutModeNames->append("Fixed");    
  chOutMode->insertStrList(chOutModeNames);
        
  indexInLabel = new QLabel("Note:", spinInLabel);
  indexIn[0] = new QSpinBox(0, 127, 1, spinInSpin1);
  indexIn[1] = new QSpinBox(0, 127, 1, spinInSpin2);
  QObject::connect(indexIn[0], SIGNAL(valueChanged(int)), this, SLOT(updateIndexIn(int)));
  QObject::connect(indexIn[1], SIGNAL(valueChanged(int)), this, SLOT(updateIndexIn(int)));
  indexOutLabel = new QLabel("Note: ", chIndexLabelBox);
  oldIndexOutMode = 0;
  updateOldIndexOutMode = true;
  indexOutMode = new QComboBox(chIndexComboBox);
  QObject::connect(indexOutMode, SIGNAL(highlighted(int)), this, SLOT(updateIndexOutMode(int)));
  indexOut = new QSpinBox(-127, 127, 1, chIndexSpinBox);
  indexOut->setValue(0);
  QObject::connect(indexOut, SIGNAL(valueChanged(int)), this, SLOT(updateIndexOut(int)));
  QStrList *indexOutModeNames = new QStrList(true);
  indexOutModeNames->append("Offset");       
  indexOutModeNames->append("Reverse, Offset");            
  indexOutModeNames->append("Fixed");      
  indexOutMode->insertStrList(indexOutModeNames);     

  rangeInLabel = new QLabel("Velocity:", spinInLabel);
  rangeIn[0] = new QSpinBox(0, 127, 1, spinInSpin1);
  rangeIn[1] = new QSpinBox(0, 127, 1, spinInSpin2);
  QObject::connect(rangeIn[0], SIGNAL(valueChanged(int)), this, SLOT(updateRangeIn(int)));
  QObject::connect(rangeIn[1], SIGNAL(valueChanged(int)), this, SLOT(updateRangeIn(int)));
  QHBox *rangeOutBox = new QHBox(outBox);
  rangeOutLabel = new QLabel("Velocity:", rangeOutBox);
  rangeOut[0] = new QSpinBox(0, 127, 1, rangeOutBox);
  rangeOut[1] = new QSpinBox(0, 127, 1, rangeOutBox);
  QObject::connect(rangeOut[0], SIGNAL(valueChanged(int)), this, SLOT(updateRangeOut(int)));
  QObject::connect(rangeOut[1], SIGNAL(valueChanged(int)), this, SLOT(updateRangeOut(int)));

  QHBox *portBox = new QHBox(this);
  new QWidget(portBox); 
  QLabel *portLabel = new QLabel("Output to ALSA Port: ", portBox);
  portOut = new QSpinBox(0, portCount - 1, 1, portBox);
  QObject::connect(portOut, SIGNAL(valueChanged(int)), this, SLOT(updatePortOut(int)));
}

MapWidget::~MapWidget() {
  
}

MidiMap *MapWidget::getMidiMap() {

  return (midiMap);
}

void MapWidget::updateTypeIn(int index) {

  typeInHighlight = index;
  midiMap->typeIn = (eventType)index;
  switch (index) {
    case 0:
      indexInLabel->setText("Note:");
      rangeInLabel->setText("Velocity:");
      rangeIn[0]->setMinValue(0);
      rangeIn[1]->setMinValue(0);
      rangeIn[0]->setMaxValue(127);
      rangeIn[1]->setMaxValue(127);
      indexIn[0]->setEnabled(true);
      indexIn[1]->setEnabled(true);
      break;
    case 1:
      indexInLabel->setText("Controller:");
      rangeInLabel->setText("Value:");
      rangeIn[0]->setMinValue(0);
      rangeIn[1]->setMinValue(0);
      rangeIn[0]->setMaxValue(127);
      rangeIn[1]->setMaxValue(127);
      indexIn[0]->setEnabled(true);
      indexIn[1]->setEnabled(true);
      break;
    case 2:
      indexInLabel->setText(" ");
      rangeInLabel->setText("Pitch:");
      rangeIn[0]->setMinValue(-8192);
      rangeIn[1]->setMinValue(-8192);
      rangeIn[0]->setMaxValue(8192);
      rangeIn[1]->setMaxValue(8192);
      indexIn[0]->setDisabled(true);
      indexIn[1]->setDisabled(true);
      break;    
    case 3:
      indexInLabel->setText(" ");
      rangeInLabel->setText("Value:");
      rangeIn[0]->setMinValue(0);
      rangeIn[1]->setMinValue(0);
      rangeIn[0]->setMaxValue(127);
      rangeIn[1]->setMaxValue(127);
      indexIn[0]->setDisabled(true);
      indexIn[1]->setDisabled(true);
      break;    
  }
  updateTypeOut(-1);
}

void MapWidget::updateTypeOut(int index) {

  if (index < 0) {
    index = typeOut->currentItem();
  }
  midiMap->typeOut = (eventType)index;
  updateOldIndexOutMode = false;
  switch (index) {
    case 0:
      switch(typeInHighlight) {
        case 0:
        case 1:
          indexOutLabel->setText("Note:");
          rangeOutLabel->setText("Velocity:");
          rangeOut[0]->setEnabled(true);
          rangeOut[1]->setEnabled(true);
          indexOut->setEnabled(true);
          indexOutMode->setEnabled(true);
          indexOutMode->setCurrentItem(oldIndexOutMode);
          break;
        case 2:
          indexOutLabel->setText("Velocity:");
          rangeOutLabel->setText("Note:");
          rangeOut[0]->setEnabled(true);
          rangeOut[1]->setEnabled(true);
          indexOut->setEnabled(true);
          indexOutMode->setDisabled(true);
          indexOutMode->setCurrentItem(2);
          break;
        case 3:  
          indexOutLabel->setText("Velocity:");
          rangeOutLabel->setText("Note:");
          rangeOut[0]->setEnabled(true);
          rangeOut[1]->setEnabled(true);
          indexOut->setEnabled(true);
          indexOutMode->setDisabled(true);
          indexOutMode->setCurrentItem(2);
          break;
      }  
      break;
    case 1:
      indexOutLabel->setText("Controller:");
      rangeOutLabel->setText("Value:");
      rangeOut[0]->setEnabled(true);
      rangeOut[1]->setEnabled(true);
      rangeOut[0]->setMinValue(0);
      rangeOut[1]->setMinValue(0);
      rangeOut[0]->setMaxValue(127);
      rangeOut[1]->setMaxValue(127);
      indexOut->setEnabled(true);
      switch(typeInHighlight) {
        case 0:
        case 1:
          indexOutMode->setEnabled(true);
          indexOutMode->setCurrentItem(oldIndexOutMode);
          break;
        case 2:
        case 3:
          indexOutMode->setDisabled(true);
          indexOutMode->setCurrentItem(2);
          break;  
      }  
      break;
    case 2:
      indexOutLabel->setText(" ");
      rangeOutLabel->setText("Pitch:");
      rangeOut[0]->setEnabled(true);
      rangeOut[1]->setEnabled(true);
      rangeOut[0]->setMinValue(-8192);
      rangeOut[1]->setMinValue(-8192);
      rangeOut[0]->setMaxValue(8192);
      rangeOut[1]->setMaxValue(8192);
      indexOut->setDisabled(true);
      indexOutMode->setDisabled(true);
      indexOutMode->setCurrentItem(2);
      break;    
    case 3:
      switch(typeInHighlight) {
        case 0:
          indexOut->setEnabled(true);
          indexOutMode->setEnabled(true);
          rangeOutLabel->setText(" ");
          rangeOut[0]->setDisabled(true);
          rangeOut[1]->setDisabled(true);
          break;
        case 1: 
        case 2:
        case 3:                    
          indexOutLabel->setText(" ");
          rangeOutLabel->setText("Value:");
          rangeOut[0]->setEnabled(true);
          rangeOut[1]->setEnabled(true);
          rangeOut[0]->setMinValue(0);
          rangeOut[1]->setMinValue(0);
          rangeOut[0]->setMaxValue(127);
          rangeOut[1]->setMaxValue(127);
          indexOut->setDisabled(true);
          indexOutMode->setCurrentItem(oldIndexOutMode);
          indexOutMode->setDisabled(true);
          break;    
      }    
  }
  updateOldIndexOutMode = true;
}

void MapWidget::updateChOutMode(int index) {
  
  midiMap->chOutMode = (outModeType)index;
}

void MapWidget::updateIndexOutMode(int index) {

  midiMap->indexOutMode = (outModeType)index; 
  if (updateOldIndexOutMode) {
    oldIndexOutMode = index;
  }  
}  

void MapWidget::updateChIn(int value) {

  if (chIn[0] == sender()) {
    midiMap->chIn[0] = value; 
  } else {
    midiMap->chIn[1] = value;
  }  
}

void MapWidget::updateChOut(int value) {

  midiMap->chOut = value;
}

void MapWidget::updateIndexIn(int value) {

  if (indexIn[0] == sender()) {
    midiMap->indexIn[0] = value; 
  } else {
    midiMap->indexIn[1] = value;
  }  
}

void MapWidget::updateIndexOut(int value) {

  midiMap->indexOut = value;
}

void MapWidget::updateRangeIn(int value) { 

  if (rangeIn[0] == sender()) {
    midiMap->rangeIn[0] = value; 
  } else {
    midiMap->rangeIn[1] = value;
  }  
}

void MapWidget::updateRangeOut(int value) {

  if (rangeOut[0] == sender()) {
    midiMap->rangeOut[0] = value; 
  } else {
    midiMap->rangeOut[1] = value;
  }  
}

void MapWidget::updatePortOut(int value) { 

  midiMap->portOut = value;
}
                  
void MapWidget::writeMap(QFile *f) {

  QTextStream mapText(f);
  
  mapText << midiMap->typeIn << " " << (int)midiMap->typeOut << "\n";
  mapText << midiMap->chIn[0] << " " << midiMap->chIn[1] << " " << midiMap->chOut << "\n";
  mapText << midiMap->indexIn[0] << " " << midiMap->indexIn[1] << " " << midiMap->indexOut << "\n";
  mapText << midiMap->rangeIn[0] << " " << midiMap->rangeIn[1] << " ";
  mapText << midiMap->rangeOut[0] << " " << midiMap->rangeOut[1] << "\n";
  mapText << (int)midiMap->chOutMode << " " << (int)midiMap->indexOutMode << "\n";
  mapText << midiMap->portOut << "\n";
}                                      

void MapWidget::readMap(QFile *f) {

  QString qs, qs2;
  QTextStream mapText(f);
  QRegExp sep(" ");
  
  qs = mapText.readLine();
  qs2 = qs.section(sep, 0, 0); 
  typeIn->setCurrentItem(qs2.toInt());
  qs2 = qs.section(sep, 1, 1);
  typeOut->setCurrentItem(qs2.toInt());
  qs = mapText.readLine();
  qs2 = qs.section(sep, 0, 0); 
  chIn[0]->setValue(qs2.toInt());
  qs2 = qs.section(sep, 1, 1); 
  chIn[1]->setValue(qs2.toInt());
  qs2 = qs.section(sep, 2, 2);
  chOut->setValue(qs2.toInt());
  qs = mapText.readLine();
  qs2 = qs.section(sep, 0, 0); 
  indexIn[0]->setValue(qs2.toInt());
  qs2 = qs.section(sep, 1, 1); 
  indexIn[1]->setValue(qs2.toInt());
  qs2 = qs.section(sep, 2, 2);
  indexOut->setValue(qs2.toInt());
  qs = mapText.readLine();
  qs2 = qs.section(sep, 0, 0); 
  rangeIn[0]->setValue(qs2.toInt());
  qs2 = qs.section(sep, 1, 1); 
  rangeIn[1]->setValue(qs2.toInt());
  qs2 = qs.section(sep, 2, 2);
  rangeOut[0]->setValue(qs2.toInt());
  qs2 = qs.section(sep, 3, 3);
  rangeOut[1]->setValue(qs2.toInt());
  qs = mapText.readLine();
  qs2 = qs.section(sep, 0, 0); 
  chOutMode->setCurrentItem(qs2.toInt());
  qs2 = qs.section(sep, 1, 1); 
  indexOutMode->setCurrentItem(qs2.toInt());
  qs = mapText.readLine();
  qs2 = qs.section(sep, 0, 0); 
  portOut->setValue(qs2.toInt());
}                                      

void MapWidget::setTypeIn(int index) {

  typeIn->setCurrentItem(index); 
}

void MapWidget::setTypeOut(int index) {

  typeOut->setCurrentItem(index); 
}

void MapWidget::setChOutMode(int index) {
  
  chOutMode->setCurrentItem(index);
}

void MapWidget::setIndexOutMode(int index) {

  indexOutMode->setCurrentItem(index); 
}  

void MapWidget::setChIn(int index, int value) {

  chIn[index]->setValue(value);
}

void MapWidget::setChOut(int value) {

  chOut->setValue(value);
}

void MapWidget::setIndexIn(int index, int value) {

  indexIn[index]->setValue(value); 
}

void MapWidget::setIndexOut(int value) {

  indexOut->setValue(value);
}

void MapWidget::setRangeIn(int index, int value) { 

  rangeIn[index]->setValue(value);
}

void MapWidget::setRangeOut(int index, int value) { 

  rangeOut[index]->setValue(value);
}

void MapWidget::setPortOut(int value) { 

  portOut->setValue(value);
}
