#line 2 "scan_netlist.cpp"

#line 4 "scan_netlist.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE netlist_restart(netlist_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int netlist_leng;

extern FILE *netlist_in, *netlist_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE netlist_lex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-netlist_lineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < netlist_leng; ++yyl )\
                    if ( netlist_text[yyl] == '\n' )\
                        --netlist_lineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up netlist_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up netlist_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via netlist_restart()), so that the user can continue scanning by
	 * just pointing netlist_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when netlist_text is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int netlist_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow netlist_wrap()'s to do buffer switches
 * instead of setting up a fresh netlist_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void netlist_restart (FILE *input_file  );
void netlist__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE netlist__create_buffer (FILE *file,int size  );
void netlist__delete_buffer (YY_BUFFER_STATE b  );
void netlist__flush_buffer (YY_BUFFER_STATE b  );
void netlist_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void netlist_pop_buffer_state (void );

static void netlist_ensure_buffer_stack (void );
static void netlist__load_buffer_state (void );
static void netlist__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER netlist__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE netlist__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE netlist__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE netlist__scan_bytes (yyconst char *bytes,int len  );

void *netlist_alloc (yy_size_t  );
void *netlist_realloc (void *,yy_size_t  );
void netlist_free (void *  );

#define yy_new_buffer netlist__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        netlist_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            netlist__create_buffer(netlist_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        netlist_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            netlist__create_buffer(netlist_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define netlist_wrap() 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *netlist_in = (FILE *) 0, *netlist_out = (FILE *) 0;

typedef int yy_state_type;

extern int netlist_lineno;

int netlist_lineno = 1;

extern char *netlist_text;
#define yytext_ptr netlist_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up netlist_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	netlist_leng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 46
#define YY_END_OF_BUFFER 47
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[215] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   47,   21,
       18,   17,   21,   20,   19,   21,   14,    7,   15,   13,
       16,    1,    5,    5,    1,    1,    5,   11,   21,   12,
        5,    5,    1,   21,   22,   23,   22,   27,   26,   25,
       27,   24,   27,   27,    7,   13,    1,    5,    1,    1,
        5,   11,   12,    5,    5,    1,   27,   45,   18,   44,
       45,   37,   28,   45,   45,   28,   45,   39,   38,   35,
       45,   36,   41,   45,   40,   45,   17,    0,    7,    8,
        0,    7,    0,    0,    0,    9,    0,    0,    5,    0,
        5,    1,    1,    5,    1,    5,   18,    0,    1,    0,

        5,    0,   23,   25,    0,    5,    1,    1,    5,    1,
        5,    1,    0,    5,   44,   31,   33,    0,   43,   39,
       39,    0,   39,    0,   39,    0,   30,   32,   29,    0,
       41,   40,    0,   40,   40,   41,   34,    0,    8,    0,
        0,    0,    7,    0,    9,    5,   10,    2,    5,    1,
        5,    5,    6,    5,    5,    1,    5,    5,    0,   42,
        0,    0,   39,   39,   41,   40,    0,   40,   41,   40,
        8,    0,    0,    7,    0,    9,    0,    5,    0,    5,
        5,    5,    0,   39,   40,   41,   40,   41,    0,   40,
        0,    8,    0,    3,    0,    0,    9,    0,    5,    5,

        0,   40,   40,   40,    8,    0,    0,    0,    9,   40,
       40,    0,    4,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    1,    9,   10,   11,    9,
        9,    9,   12,   13,   12,   14,    9,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   16,   17,   18,
       19,   20,    9,    1,   21,   22,   23,   24,   25,   26,
       27,   28,   23,   23,   29,   23,   30,   23,   31,   23,
       23,   23,   32,   33,   23,   34,   35,   23,   23,   23,
       36,   37,   38,    9,   23,    1,   39,   23,   23,   40,

       41,   42,   23,   43,   44,   44,   45,   23,   46,   47,
       23,   48,   49,   23,   50,   23,   51,   23,   23,   23,
       23,   52,   53,   54,   55,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[56] =
    {   0,
        1,    2,    3,    3,    4,    1,    1,    1,    1,    1,
        1,    1,    1,    5,    6,    1,    1,    1,    7,    1,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    1,    1,    1,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    1,    1,    8
    } ;

static yyconst flex_int16_t yy_base[226] =
    {   0,
        0,    0,   53,   55,   59,    0,  114,    0,  644,  707,
      707,  707,  640,  707,  707,  156,  170,  162,  707,  707,
      707,  176,  177,  178,  226,  196,  200,  707,  185,  707,
      202,  215,    0,    0,  707,  707,  639,  707,  707,  707,
      638,  707,  194,  624,  221,  707,  624,  623,  263,  159,
      170,  707,  707,  204,  208,    0,    0,  707,  707,  707,
      633,  616,  707,  624,  622,  707,  617,  312,  707,  612,
      611,  608,  237,  246,  362,  571,  707,  608,  255,  249,
      266,  263,  581,  575,  229,  259,  281,    0,  301,    0,
      314,  316,  327,  329,  364,  366,  707,  615,  561,  583,

      401,  532,  707,  707,    0,  556,  555,  185,  239,  536,
      179,  502,  530,  297,  707,  707,  707,  529,  707,  359,
      350,  510,    0,  290,  707,  499,  707,  707,  707,    0,
      409,  441,  505,  260,  416,  417,  707,  494,  423,  332,
      458,  478,  381,  469,  426,  442,  707,  471,  477,    0,
      492,  487,  707,  464,  279,    0,  489,  438,  461,  707,
      375,  455,  430,  388,  508,  707,  411,  532,  524,  583,
      434,  382,  402,  451,  453,  483,  412,  574,  390,  527,
      504,  309,  384,  383,  342,  589,  530,  591,  371,  335,
      417,  367,  590,  452,  450,  355,  347,  325,  490,  341,

      321,  575,  607,  609,  295,  615,  261,  272,  266,  264,
      251,  219,  707,  707,  653,  660,  667,  670,  676,  683,
      226,  690,  206,  698,  180
    } ;

static yyconst flex_int16_t yy_def[226] =
    {   0,
      214,    1,  215,  215,  214,    5,  214,    7,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  216,  216,  216,  216,  216,  216,  214,  214,  214,
      216,  216,   25,  217,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  218,  218,  218,  218,
      218,  214,  214,  218,  218,   49,  217,  214,  214,  214,
      214,  214,  214,  214,  219,  214,  214,  214,  214,  214,
      214,  214,  220,  214,  220,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  221,  216,  222,
      216,  216,  216,  216,  216,  216,  214,  214,   25,  221,

      216,  217,  214,  214,  223,  218,  218,  218,  218,  218,
      218,   49,  223,  218,  214,  214,  214,  224,  214,   68,
      120,  214,   68,  214,  214,  214,  214,  214,  214,  225,
      220,  214,  225,   75,  220,  220,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  221,  214,  216,  216,   25,
      221,  101,  214,  223,  218,   49,  223,  218,  224,  214,
      214,  214,  121,  214,  225,  214,  214,  214,  220,  220,
      214,  214,  214,  214,  214,  214,  214,  151,  214,  101,
      223,  218,  214,  121,  214,  225,  225,  225,  214,   75,
      214,  214,  214,  214,  214,  214,  214,  214,  151,  223,

      214,  168,  225,  132,  214,  214,  214,  214,  214,  204,
      204,  214,  214,    0,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214
    } ;

static yyconst flex_int16_t yy_nxt[763] =
    {   0,
       10,   11,   12,   13,   11,   10,   14,   15,   10,   10,
       10,   16,   10,   17,   18,   19,   20,   10,   21,   10,
       22,   23,   23,   23,   24,   22,   25,   26,   22,   25,
       27,   22,   25,   22,   22,   28,   29,   30,   25,   31,
       23,   25,   23,   32,   25,   33,   25,   25,   23,   22,
       25,   23,   34,   10,   10,   36,   37,   36,   37,   38,
       39,   40,   41,   39,   38,   42,   38,   38,   38,   38,
       43,   38,   44,   45,   38,   46,   38,   38,   38,   47,
       48,   48,   48,   48,   47,   49,   50,   47,   49,   51,
       47,   49,   47,   47,   52,   38,   53,   49,   54,   48,

       49,   48,   55,   49,   56,   49,   49,   48,   47,   49,
       48,   57,   38,   38,   58,   59,   60,   61,   59,   62,
       63,   58,   63,   64,   65,   63,   66,   67,   68,   63,
       69,   70,   71,   72,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   63,
       74,   63,   73,   73,   73,   73,   73,   75,   73,   73,
       73,   73,   73,   73,   73,   73,   58,   76,   58,   78,
       79,   81,  105,   84,   81,   78,   79,   87,   87,   87,
       87,   87,   87,  105,   82,  165,   85,   97,   98,   88,
       88,   88,  105,   83,   90,   90,   90,   87,  105,   80,

       87,   87,   85,   87,   87,   86,   87,   78,   79,   88,
      110,  154,  111,   88,   90,   88,   87,  105,   90,   87,
       90,  113,  114,   99,  110,  112,   91,   87,  100,  101,
       87,  146,   84,   90,   78,   79,  107,   80,   87,   88,
      142,   87,   96,  143,   90,   85,   92,   95,   97,   98,
      130,   92,  105,   93,   92,   90,   94,   92,  213,   92,
       92,   85,  138,  139,   86,  214,   84,   81,   78,   79,
       81,   92,  144,  145,   84,   92,  105,   82,  210,   85,
      209,  155,   87,  107,  169,   87,  209,  140,  107,   83,
      108,  107,  105,  109,  107,   85,  107,  107,   86,   90,

      169,  162,   87,  140,  163,   87,   86,  212,  107,  205,
      113,  114,  107,  121,   88,   87,  121,   87,   87,   90,
       87,  158,  105,  182,  107,  122,  123,   88,   87,   88,
       87,   87,   90,   87,   90,  210,  124,  158,  125,  205,
       88,  125,   88,  173,  125,   90,  174,   90,  130,  190,
      125,  126,  124,  125,  105,  200,  125,  125,  125,  125,
      148,  197,  125,  132,  214,   87,  132,   87,   87,  197,
       87,  149,  214,  120,  214,  133,  134,   88,   92,   88,
       90,  192,   90,  161,   90,  204,  183,  166,  135,  184,
      214,  135,   84,  179,  135,  143,  192,  184,  184,  161,

      135,  136,   87,  135,  192,   87,  135,  135,  135,  135,
       87,   95,  135,   87,  100,  101,  174,   87,   87,   90,
       87,   87,  130,  196,   86,  152,  197,   90,  198,  130,
      130,  205,  185,  125,   90,   90,  138,  139,  170,  144,
      145,  152,  132,   87,  163,  132,   87,  172,  171,  179,
      177,  105,  182,  206,  193,   88,  206,  193,  191,   90,
       90,  208,   84,  172,  209,  174,  177,  166,  194,  163,
      166,  119,   87,  166,  191,   87,  207,  105,   87,  166,
      167,   87,  166,  176,   88,  166,  166,  166,  166,   90,
       88,  166,  143,   87,   86,   90,   87,  176,  179,  175,

       88,  180,  105,  157,  199,   88,  151,  195,  171,   87,
       90,   89,   87,  181,  146,  198,  178,  105,  200,  168,
      164,  130,   92,  195,  120,   87,   90,   89,   87,  181,
      146,   87,  178,  132,   87,  189,  132,  130,  190,  160,
       88,  180,   90,  130,  157,  130,  168,  156,   90,  105,
       90,   89,  165,  165,  165,  165,  186,  165,  187,  165,
      165,  187,  165,  165,  187,  165,  165,   89,  105,  105,
      187,  188,  186,  187,  165,  165,  187,  187,  187,  187,
      165,  165,  187,  165,   87,  198,  153,   87,  199,  202,
       87,  193,   87,   87,  193,   87,  130,  151,  146,  165,

      201,   90,  130,  202,  130,  194,  150,   90,   87,   90,
      211,   87,  203,  211,  146,  165,  206,   97,   86,  206,
      130,  141,   82,  204,  137,   90,  129,  214,  135,  128,
      127,  120,  119,  117,  116,  115,  105,  105,   82,  207,
      104,  103,   77,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  187,   35,   35,   35,   35,   35,   35,   35,
       35,   89,  214,   89,   89,   89,   89,  102,  214,  214,
      102,  102,  102,  102,  106,  106,  118,  118,  214,  118,
      118,  118,  118,  118,  131,  214,  131,  131,  131,  131,
      147,  147,  147,  147,  147,  147,  214,  147,  159,  159,

      214,  159,  159,  159,  159,  159,    9,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214
    } ;

static yyconst flex_int16_t yy_chk[763] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,    3,    4,    4,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,

        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,   16,
       16,   17,   50,   18,   17,   18,   18,   22,   23,   24,
       22,   23,   24,   51,   17,  225,   18,   29,   29,   22,
       23,   24,  111,   17,   22,   23,   24,   26,  108,   16,

       26,   27,   18,   31,   27,   18,   31,   43,   43,   26,
       50,  223,   51,   27,   26,   31,   32,   54,   27,   32,
       31,   55,   55,   31,  111,   54,   24,   25,   32,   32,
       25,  221,   45,   32,   45,   45,  108,   43,   73,   25,
       85,   73,   27,   85,   25,   45,   25,   26,   74,   74,
       73,   25,  109,   25,   25,   73,   25,   25,  212,   25,
       25,   45,   80,   80,   45,  211,   79,   81,   79,   79,
       81,   25,   86,   86,   82,   25,   49,   82,  210,   79,
      209,  109,   87,   49,  134,   87,  208,   82,   49,   81,
       49,   49,  155,   49,   49,   79,   49,   49,   79,   87,

      134,  124,   89,   82,  124,   89,   82,  207,   49,  205,
      114,  114,   49,   68,   89,   91,   68,   92,   91,   89,
       92,  114,  182,  182,  155,   68,   68,   91,   93,   92,
       94,   93,   91,   94,   92,  201,   68,  114,   68,  198,
       93,   68,   94,  140,   68,   93,  140,   94,  190,  190,
       68,   68,   68,   68,  200,  200,   68,   68,   68,   68,
       91,  197,   68,   75,  121,   95,   75,   96,   95,  196,
       96,   94,  120,  120,  121,   75,   75,   95,   93,   96,
       75,  192,   95,  120,   96,  189,  161,  185,   75,  161,
      121,   75,  143,  172,   75,  143,  172,  184,  183,  120,

       75,   75,  101,   75,  179,  101,   75,   75,   75,   75,
      131,   96,   75,  131,  101,  101,  173,  135,  136,  101,
      135,  136,  131,  177,  143,  101,  177,  131,  191,  135,
      136,  191,  167,  164,  135,  136,  139,  139,  136,  145,
      145,  101,  132,  146,  163,  132,  146,  139,  171,  158,
      145,  158,  158,  194,  175,  146,  194,  175,  171,  132,
      146,  195,  174,  139,  195,  174,  145,  132,  175,  162,
      132,  159,  148,  132,  171,  148,  194,  154,  149,  132,
      132,  149,  132,  144,  148,  132,  132,  132,  132,  148,
      149,  132,  142,  151,  174,  149,  151,  176,  152,  141,

      152,  152,  157,  157,  199,  151,  151,  176,  138,  165,
      151,  152,  165,  157,  199,  181,  151,  181,  181,  133,
      126,  165,  149,  176,  122,  169,  165,  152,  169,  157,
      199,  187,  151,  168,  187,  169,  168,  169,  169,  118,
      180,  180,  169,  187,  113,  168,  168,  112,  187,  110,
      168,  180,  168,  168,  168,  168,  168,  168,  168,  168,
      168,  168,  168,  168,  168,  168,  168,  180,  107,  106,
      168,  168,  168,  168,  168,  168,  168,  168,  168,  168,
      168,  168,  168,  168,  170,  178,  102,  170,  178,  202,
      186,  193,  188,  186,  193,  188,  170,  100,  178,  202,

      186,  170,  186,  186,  188,  193,   99,  186,  203,  188,
      204,  203,  188,  204,  178,  202,  206,   98,   84,  206,
      203,   83,   78,  204,   76,  203,   72,  204,  170,   71,
       70,   67,   65,   64,   62,   61,   48,   47,   44,  206,
       41,   37,   13,    9,    0,    0,    0,    0,    0,    0,
        0,    0,  203,  215,  215,  215,  215,  215,  215,  215,
      215,  216,    0,  216,  216,  216,  216,  217,    0,    0,
      217,  217,  217,  217,  218,  218,  219,  219,    0,  219,
      219,  219,  219,  219,  220,    0,  220,  220,  220,  220,
      222,  222,  222,  222,  222,  222,    0,  222,  224,  224,

        0,  224,  224,  224,  224,  224,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[47] =
    {   0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
    0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 1, 0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int netlist__flex_debug;
int netlist__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *netlist_text;
#line 1 "scan_netlist.l"
/* -*-c-*- */
#line 4 "scan_netlist.l"
/*
 * scan_netlist.l - scanner for the Qucs netlist
 *
 * Copyright (C) 2003, 2004, 2005, 2006, 2007 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 *
 * $Id: scan_netlist.l,v 1.23 2007/09/23 17:33:58 ela Exp $
 *
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef __MINGW32__
#include <io.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "logging.h"
#include "equation.h"
#include "check_netlist.h"
#include "tokens_netlist.h"

#if !HAVE_STRCHR
# define strchr  index
# define strrchr rindex
#endif

static double netlist_evaluate_scale (double val, char * scale) {
  double factor = 1.0;
  while (isspace (scale[0])) scale++;
  switch (scale[0]) {
  case 'T': factor = 1e+12; break;
  case 'G': factor = 1e+09; break;
  case 'M': factor = 1e+06; break;
  case 'k': factor = 1e+03; break;
  case 'm': factor = 1e-03; break;
  case 'u': factor = 1e-06; break;
  case 'n': factor = 1e-09; break;
  case 'p': factor = 1e-12; break;
  case 'f': factor = 1e-15; break;
  case 'a': factor = 1e-18; break;
  case 'd':
    if (scale[1] == 'B') {
      val = pow (10.0, val / 10.0);
      if (scale[2] == 'm') factor = 1e-03;
    }
    break;
  }
  return val * factor;
}


#line 797 "scan_netlist.cpp"

#define INITIAL 0
#define COMMENT 1
#define STR 2
#define EQN 3

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int netlist_wrap (void );
#else
extern int netlist_wrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( netlist_text, netlist_leng, 1, netlist_out )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( netlist_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( netlist_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, netlist_in))==0 && ferror(netlist_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(netlist_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int netlist_lex (void);

#define YY_DECL int netlist_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after netlist_text and netlist_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 118 "scan_netlist.l"


#line 946 "scan_netlist.cpp"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! netlist_in )
			netlist_in = stdin;

		if ( ! netlist_out )
			netlist_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			netlist_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				netlist__create_buffer(netlist_in,YY_BUF_SIZE );
		}

		netlist__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of netlist_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 215 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 707 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < netlist_leng; ++yyl )
				if ( netlist_text[yyl] == '\n' )
					   
    netlist_lineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 120 "scan_netlist.l"
{ /* identify scale and/or unit */
    netlist_lval.str = strdup (netlist_text);
    return ScaleOrUnit;
  }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 124 "scan_netlist.l"
{ /* special equation case */
    BEGIN(EQN);
    return Eqn;
  }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 128 "scan_netlist.l"
{
    /* subcircuit definition begins */
    return DefSub;
  }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 132 "scan_netlist.l"
{
    /* subcircuit definition ends */
    return EndSub;
  }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 136 "scan_netlist.l"
{ /* identify identifier */
    netlist_lval.ident = strdup (netlist_text);
    return Identifier;
  }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 140 "scan_netlist.l"
{ /* identify file reference */
    char * p = strrchr (netlist_text, '}'); *p = '\0';
    netlist_lval.ident = strdup (&netlist_text[1]);
    return Identifier;
  }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 145 "scan_netlist.l"
{ /* identify (signed) real float */
    netlist_lval.d = strtod (netlist_text, NULL);
    return REAL;
  }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 149 "scan_netlist.l"
{ /* identify (signed) imaginary float */
    if (netlist_text[0] == 'i' || netlist_text[0] == 'j')
      netlist_text[0] = (netlist_text[1] == '\0') ? '1' : '0';
    else
      netlist_text[1] = '0';
    netlist_lval.d = strtod (netlist_text, NULL);
    return IMAG;
  }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 157 "scan_netlist.l"
{ /* identify complete (signed) complex number */
    int i = 0;
    while (netlist_text[i] != 'i' && netlist_text[i] != 'j') i++;
    netlist_text[i] = netlist_text[i - 1];
    netlist_text[i - 1] = '\0';
    netlist_lval.c.r = strtod (netlist_text, NULL);
    netlist_lval.c.i = strtod (&netlist_text[i], NULL);
    return COMPLEX;
  }
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 166 "scan_netlist.l"
{  /* identify 'identifier =' assign */
    int len = netlist_leng - 3;
    while (isspace (netlist_text[len])) len--;
    netlist_lval.ident = (char *) calloc (len + 2, 1);
    memcpy (netlist_lval.ident, netlist_text, len + 1);
    yyless (netlist_leng - 1); /* push back last character */
    return Assign; 
  }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 175 "scan_netlist.l"
{ /* special token for the value list */ return '['; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 176 "scan_netlist.l"
{ /* special token for the value list */ return ']'; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 177 "scan_netlist.l"
{ /* special token for the value list */ return ';'; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 179 "scan_netlist.l"
{ /* pass the '.' to the parser */ return '.'; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 180 "scan_netlist.l"
{ /* pass the ':' to the parser */ return ':'; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 181 "scan_netlist.l"
{ /* pass the '=' to the parser */ return '='; }
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 182 "scan_netlist.l"
{ /* detect end of line */ return Eol; }
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 184 "scan_netlist.l"
/* skip spaces and the trailing '\' */
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 186 "scan_netlist.l"
{ /* leave these characters */
    BEGIN(COMMENT);
  }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 189 "scan_netlist.l"
{ /* string constant starts here */
    BEGIN(STR);  
    return '"';
  }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 193 "scan_netlist.l"
{ /* any other character in invalid */
    logprint (LOG_ERROR, 
	      "line %d: syntax error, unrecognized character: `%s'\n", 
	      netlist_lineno, netlist_text);
    return InvalidCharacter;
  }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 200 "scan_netlist.l"
{ /* skip any character in here */ }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 201 "scan_netlist.l"
{ BEGIN(INITIAL); /* skipping ends here */ }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 203 "scan_netlist.l"
{ /* string constant ends here */
    BEGIN(INITIAL); 
    return '"';
  }
	YY_BREAK
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 207 "scan_netlist.l"
{ /* string in a single line only */
    logprint (LOG_ERROR, 
	      "line %d: syntax error, unterminated string constant\n",
	      netlist_lineno);
    return Eol;
  }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 213 "scan_netlist.l"
/* skip spaces */
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 215 "scan_netlist.l"
{ /* any other character is invalid */
    logprint (LOG_ERROR, 
	      "line %d: syntax error, unrecognized character: `%s'\n", 
	      netlist_lineno, netlist_text);
    return InvalidCharacter;
  }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 222 "scan_netlist.l"
{ /* return operators unchanged */
    return netlist_text[0];
  }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 226 "scan_netlist.l"
{ return GreaterOrEqual; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 227 "scan_netlist.l"
{ return LessOrEqual; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 228 "scan_netlist.l"
{ return NotEqual; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 229 "scan_netlist.l"
{ return Equal; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 230 "scan_netlist.l"
{ return And; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 231 "scan_netlist.l"
{ return Or; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 232 "scan_netlist.l"
{ return Less; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 233 "scan_netlist.l"
{ return Greater; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 234 "scan_netlist.l"
{ return Not; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 236 "scan_netlist.l"
{ /* special tokens for vectors / matrices */
    return netlist_text[0];
  }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 240 "scan_netlist.l"
{ /* identify unsigned real float */
    char * endptr = NULL;
    netlist_lval.d = strtod (netlist_text, &endptr);
    netlist_lval.d = netlist_evaluate_scale (netlist_lval.d, endptr);
    return REAL;
  }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 246 "scan_netlist.l"
{ /* identify unsigned imaginary float */
    if (netlist_text[0] == 'i' || netlist_text[0] == 'j')
      netlist_text[0] = (netlist_text[1] == '\0') ? '1' : '0';
    else
      netlist_text[1] = '0';
    char * endptr = NULL;
    netlist_lval.d = strtod (netlist_text, &endptr);
    netlist_lval.d = netlist_evaluate_scale (netlist_lval.d, endptr);
    return IMAG;
  }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 256 "scan_netlist.l"
{ /* identify identifier */
    netlist_lval.ident = strdup (netlist_text);
    return Identifier;
  }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 260 "scan_netlist.l"
{
    netlist_lval.chr = netlist_text[1];
    return Character;
  }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 264 "scan_netlist.l"
{
    netlist_lval.str = strdup (&netlist_text[1]);
    netlist_lval.str[strlen (netlist_lval.str) - 1] = '\0';
    return STRING;
  }
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 269 "scan_netlist.l"
{ /* detect end of line */ BEGIN(INITIAL); return Eol; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 271 "scan_netlist.l"
{ /* any other character in invalid */
    logprint (LOG_ERROR, 
	      "line %d: syntax error, unrecognized character: `%s'\n", 
	      netlist_lineno, netlist_text);
    return InvalidCharacter;
  }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 278 "scan_netlist.l"
ECHO;
	YY_BREAK
#line 1375 "scan_netlist.cpp"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(STR):
case YY_STATE_EOF(EQN):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed netlist_in at a new source and called
			 * netlist_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = netlist_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( netlist_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * netlist_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of netlist_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					netlist_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			netlist_restart(netlist_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 215 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 215 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 214);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					netlist_restart(netlist_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( netlist_wrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve netlist_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		   
    netlist_lineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void netlist_restart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        netlist_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            netlist__create_buffer(netlist_in,YY_BUF_SIZE );
	}

	netlist__init_buffer(YY_CURRENT_BUFFER,input_file );
	netlist__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void netlist__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		netlist_pop_buffer_state();
	 *		netlist_push_buffer_state(new_buffer);
     */
	netlist_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	netlist__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (netlist_wrap()) processing, but the only time this flag
	 * is looked at is after netlist_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void netlist__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	netlist_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE netlist__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) netlist_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in netlist__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) netlist_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in netlist__create_buffer()" );

	b->yy_is_our_buffer = 1;

	netlist__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with netlist__create_buffer()
 * 
 */
    void netlist__delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		netlist_free((void *) b->yy_ch_buf  );

	netlist_free((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a netlist_restart() or at EOF.
 */
    static void netlist__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	netlist__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then netlist__init_buffer was _probably_
     * called from netlist_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void netlist__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		netlist__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void netlist_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	netlist_ensure_buffer_stack();

	/* This block is copied from netlist__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from netlist__switch_to_buffer. */
	netlist__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void netlist_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	netlist__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		netlist__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void netlist_ensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)netlist_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)netlist_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE netlist__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) netlist_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in netlist__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	netlist__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to netlist_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       netlist__scan_bytes() instead.
 */
YY_BUFFER_STATE netlist__scan_string (yyconst char * yystr )
{
    
	return netlist__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to netlist_lex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE netlist__scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) netlist_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in netlist__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = netlist__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in netlist__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up netlist_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		netlist_text[netlist_leng] = (yy_hold_char); \
		(yy_c_buf_p) = netlist_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		netlist_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int netlist_get_lineno  (void)
{
        
    return netlist_lineno;
}

/** Get the input stream.
 * 
 */
FILE *netlist_get_in  (void)
{
        return netlist_in;
}

/** Get the output stream.
 * 
 */
FILE *netlist_get_out  (void)
{
        return netlist_out;
}

/** Get the length of the current token.
 * 
 */
int netlist_get_leng  (void)
{
        return netlist_leng;
}

/** Get the current token.
 * 
 */

char *netlist_get_text  (void)
{
        return netlist_text;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void netlist_set_lineno (int  line_number )
{
    
    netlist_lineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see netlist__switch_to_buffer
 */
void netlist_set_in (FILE *  in_str )
{
        netlist_in = in_str ;
}

void netlist_set_out (FILE *  out_str )
{
        netlist_out = out_str ;
}

int netlist_get_debug  (void)
{
        return netlist__flex_debug;
}

void netlist_set_debug (int  bdebug )
{
        netlist__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from netlist_lex_destroy(), so don't allocate here.
     */

    /* We do not touch netlist_lineno unless the option is enabled. */
    netlist_lineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    netlist_in = stdin;
    netlist_out = stdout;
#else
    netlist_in = (FILE *) 0;
    netlist_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * netlist_lex_init()
     */
    return 0;
}

/* netlist_lex_destroy is for both reentrant and non-reentrant scanners. */
int netlist_lex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		netlist__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		netlist_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	netlist_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * netlist_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *netlist_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *netlist_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void netlist_free (void * ptr )
{
	free( (char *) ptr );	/* see netlist_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 278 "scan_netlist.l"



