/****************************************************************************
** $Id: qprocess.cpp,v 1.4 2002/11/27 12:59:17 dermichel Exp $
**
** Implementation of QProcess class
**
** Created : 20000905
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef USE_QT3

#include <stdio.h>
#include <stdlib.h>

#include "qprocess.h"

#include <qapplication.h>


QProcessBackport::QProcessBackport( QObject *parent, const char *name )
    : QObject( parent, name ), ioRedirection( FALSE ), notifyOnExit( FALSE ),
    wroteToStdinConnected( FALSE )
{
  init();
}

QProcessBackport::QProcessBackport( const QString& arg0, QObject *parent, const char *name )
    : QObject( parent, name ), ioRedirection( FALSE ), notifyOnExit( FALSE ),
    wroteToStdinConnected( FALSE )
{
  init();
  addArgument( arg0 );
}

QProcessBackport::QProcessBackport( const QStringList& args, QObject *parent, const char *name )
    : QObject( parent, name ), ioRedirection( FALSE ), notifyOnExit( FALSE ),
    wroteToStdinConnected( FALSE )
{
  init();
  setArguments( args );
}

QStringList QProcessBackport::arguments() const
{
  return _arguments;
}

void QProcessBackport::setArguments( const QStringList& args )
{
  _arguments = args;
}

void QProcessBackport::addArgument( const QString& arg )
{
  _arguments.append( arg );
}

QDir QProcessBackport::workingDirectory() const
{
  return workingDir;
}

void QProcessBackport::setWorkingDirectory( const QDir& dir )
{
  workingDir = dir;
}

bool QProcessBackport::normalExit() const
{
  // isRunning() has the side effect that it determines the exit status!
  if ( isRunning() )
    return FALSE;
  return exitNormal;
}

int QProcessBackport::exitStatus() const
{
  // isRunning() has the side effect that it determines the exit status!
  if ( isRunning() )
    return 0;
  return exitStat;
}

QByteArray QProcessBackport::readStdout()
{
  QByteArray buf = bufStdout;
  bufStdout.resize( 0 );
  return buf;
}

QByteArray QProcessBackport::readStderr()
{
  QByteArray buf = bufStderr;
  bufStderr.resize( 0 );
  return buf;
}

bool QProcessBackport::launch( const QByteArray& buf )
{
  if ( start() )
  {
    connect( this, SIGNAL(wroteToStdin()),
             this, SLOT(closeStdinLaunch()) );
    writeToStdin( buf );
    return TRUE;
  }
  else
  {
    return FALSE;
  }
}

bool QProcessBackport::launch( const QString& buf )
{
  if ( start() )
  {
    connect( this, SIGNAL(wroteToStdin()),
             this, SLOT(closeStdinLaunch()) );
    writeToStdin( buf );
    return TRUE;
  }
  else
  {
    return FALSE;
  }
}

void QProcessBackport::closeStdinLaunch()
{
    disconnect( this, SIGNAL(wroteToStdin()),
                this, SLOT(closeStdinLaunch()) );
    closeStdin();
}

void QProcessBackport::writeToStdin( const QString& buf )
{
  QByteArray tmp = buf.local8Bit();
  tmp.resize( buf.length() );
  writeToStdin( tmp );
}

void QProcessBackport::connectNotify( const char * signal )
{
  if ( !ioRedirection )
    if ( qstrcmp( signal, SIGNAL(readyReadStdout()) )==0 ||
         qstrcmp( signal, SIGNAL(readyReadStderr()) )==0)
    {
      setIoRedirection( TRUE );
      return;
    }
  if ( !notifyOnExit && qstrcmp( signal, SIGNAL(processExited()) )==0 )
  {
    setNotifyOnExit( TRUE );
    return;
  }
  if ( !wroteToStdinConnected && qstrcmp( signal, SIGNAL(wroteToStdin()) )==0 )
  {
    setWroteStdinConnected( TRUE );
    return;
  }
}

void QProcessBackport::disconnectNotify( const char * )
{
  if ( ioRedirection &&
       receivers( SIGNAL(readyReadStdout()) ) ==0 &&
       receivers( SIGNAL(readyReadStderr()) ) ==0)
  {
    setIoRedirection( FALSE );
  }
  if ( notifyOnExit && receivers( SIGNAL(processExited()) ) == 0 )
  {
    setNotifyOnExit( FALSE );
  }
  if ( wroteToStdinConnected && receivers( SIGNAL(wroteToStdin()) ) == 0 )
  {
    setWroteStdinConnected( FALSE );
  }
}
void QProcessBackport::clearArguments()
{
    _arguments.clear();
}

#endif // USE_QT3
