/***************************************************************************
                          normalizedialog.cpp  -  description
                             -------------------
    begin                : Wed Jan 23 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "normalizedialog.h"

#include <math.h>

#include <qapplication.h>
#include <qcheckbox.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qvbox.h>

NormalizeDialog::NormalizeDialog(int preview_size,QImage* image,QWidget* parent)
             :ImageFilterDialog(preview_size,image,parent)
{
  initControls();
}
NormalizeDialog::~NormalizeDialog()
{
}
/** No descriptions */
void NormalizeDialog::initControls()
{
  showContinousUpdate(false);
  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Normalize"));
  setCaption(tr("Normalize"));
  //brightness
  new QLabel(tr("No settings available"),vb);
  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool NormalizeDialog::apply(QImage* image,bool emit_progress)
{
  bool has_alpha;
  int* histogram,threshold_intensity,y;
  int gray_value;
  int* normalize_map;
  int i,intensity,x;
  unsigned int high,low;
  int old_depth;

  if(!image) return false;
  if(image->isNull() || image->depth()<8) return false;

  QImage im = image->copy();
  old_depth = image->depth();

  if(im.depth() < 32)
    im = im.convertDepth(32);

  has_alpha = im.hasAlphaBuffer();
  /*
    Allocate histogram and normalize map.
  */
  histogram= new int [256];
  normalize_map= new int [256];
  /*
    Form histogram.
  */
  for (i=0; i <= 255; i++)
    histogram[i]=0;
  for (y=0; y < (int) im.height(); y++)
  {
    for (x=0; x < (int) im.width(); x++)
    {
      gray_value = qGray(im.pixel(x,y));
      histogram[gray_value]++;
    }
  }
  /*
    Find the histogram boundaries by locating the 1 percent levels.
  */
  threshold_intensity=(im.width()*im.height())/100;
  intensity=0;
  for (low=0; low < 255; low++)
  {
    intensity+=histogram[low];
    if (intensity > threshold_intensity)
      break;
  }
  intensity=0;
  for (high=255; high != 0; high--)
  {
    intensity+=histogram[high];
    if (intensity > threshold_intensity)
      break;
  }
  if (low == high)
  {
    /*
      Unreasonable contrast;  use zero threshold to determine boundaries.
    */
    threshold_intensity=0;
    intensity=0;
    for (low=0; low < 255; low++)
    {
      intensity+=histogram[low];
      if (intensity > threshold_intensity)
        break;
    }
    intensity=0;
    for (high=255; high != 0; high--)
    {
      intensity+=histogram[high];
      if (intensity > threshold_intensity)
        break;
    }
    if (low == high)
      return(false);  /* zero span bound */
  }
  /*
    Stretch the histogram to create the normalized image mapping.
  */
  for (i=0; i <= 255; i++)
    if (i < (int) low)
      normalize_map[i]=0;
    else
      if (i > (int) high)
        normalize_map[i]=255;
      else
        normalize_map[i]=(255-1)*(i-low)/(high-low);
// Normalize the image.
//If there's a colortable, calculate those colors.
//If there's an alpha buffer, leave it untouched
  QRgb rgb;
  for (y=0; y < (int) im.height(); y++)
  {
    for (x=0; x < (int) im.width(); x++)
    {
      rgb = im.pixel(x,y);
      if(has_alpha)
      {
        im.setPixel(x,y,qRgba(normalize_map[qRed(rgb)],
                                  normalize_map[qGreen(rgb)],
                                  normalize_map[qBlue(rgb)],
                                  qAlpha(rgb)));
      }
      else
      {
        im.setPixel(x,y,qRgb(normalize_map[qRed(rgb)],
                                 normalize_map[qGreen(rgb)],
                                 normalize_map[qBlue(rgb)]));
      }
    }
  }
  delete [] normalize_map;
  delete [] histogram;
  if(old_depth != im.depth())
    *image = im.convertDepth(old_depth);
  else
    *image = im;
  return true;
}
