/***************************************************************************
                          scaledialog.cpp  -  description
                             -------------------
    begin                : Sun May 5 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "scaledialog.h"

#include "quiteinsane/qdoublespinbox.h"
#include "quiteinsane/qxmlconfig.h"

#include <math.h>

#include <qapplication.h>
#include <qcheckbox.h>
#include <qcolordialog.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qvbox.h>

ScaleDialog::ScaleDialog(int preview_size,QImage* image,QWidget* parent)
            :ImageFilterDialog(preview_size,image,parent)
{
  mMaxSize = preview_size;
  initControls();
}
ScaleDialog::~ScaleDialog()
{
}
/** No descriptions */
void ScaleDialog::initControls()
{
  bool aspect = xmlConfig->boolValue("FILTER_SCALE_KEEP_ASPECT",true);
  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Scale"));
  setCaption(tr("Scale"));
  //horizontal
  QHBox* hboxh = new QHBox(vb);
  QLabel* hlabel = new QLabel(tr("Width (pixel)"),hboxh);
  hboxh->setSpacing(3);
  mpScaleHSpin = new QSpinBox(hboxh);
  mpScaleHSpin->setRange(1,20000);
  mpScaleHSpin->setValue(100);
  hboxh->setStretchFactor(hlabel,1);
  //vertical
  QHBox* hboxv = new QHBox(vb);
  QLabel* vlabel = new QLabel(tr("Height (pixel)"),hboxv);
  hboxv->setSpacing(3);
  mpScaleVSpin = new QSpinBox(hboxv);
  mpScaleVSpin->setRange(1,20000);
  mpScaleVSpin->setValue(100);
  hboxv->setStretchFactor(vlabel,1);
  //horizontal scalefactor
  QHBox* hfboxh = new QHBox(vb);
  QLabel* hflabel = new QLabel(tr("Factor X"),hfboxh);
  hfboxh->setSpacing(3);
  mpScaleHDoubleSpin = new QDoubleSpinBox(hfboxh);
  mpScaleHDoubleSpin->setRange(1,INT_MAX);
  mpScaleHDoubleSpin->setValue(100);
  hfboxh->setStretchFactor(hflabel,1);
  //vertical scalefactor
  QHBox* hfboxv = new QHBox(vb);
  QLabel* vflabel = new QLabel(tr("Factor Y"),hfboxv);
  hboxv->setSpacing(3);
  mpScaleVDoubleSpin = new QDoubleSpinBox(hfboxv);
  mpScaleVDoubleSpin->setRange(1,INT_MAX);
  mpScaleVDoubleSpin->setValue(100);
  hfboxv->setStretchFactor(vflabel,1);
  //aspect ratio
  mpAspectCheckBox = new QCheckBox(tr("Keep aspect ratio"),vb);
  mpAspectCheckBox->setChecked(aspect);
  //aspect ratio
  mpResetButton = new QPushButton(tr("Reset"),vb);
  //dummy
  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);

  connect(mpScaleHSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotScaleHChanged(int)));
  connect(mpScaleVSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotScaleVChanged(int)));
  connect(mpScaleHDoubleSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotScaleFactorHChanged(int)));
  connect(mpScaleVDoubleSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotScaleFactorVChanged(int)));
  connect(mpAspectCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotAspect(bool)));
  connect(mpResetButton,SIGNAL(clicked()),
          this,SLOT(slotReset()));
  showContinousUpdate(false);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool ScaleDialog::apply(QImage* image,bool emit_progress)
{
  int w,h;

  if(!image)
    return false;
  w = mpScaleHSpin->value();
  h = mpScaleVSpin->value();
  if(image == previewImage())
  {
    //in this case, we are only interested in the aspect ratio
    //if "keep aspect ratio" is selected, we do nothing
    if(mpAspectCheckBox->isChecked())
      return true;
    int nw,nh;
    if(w > h)
    {
      nw = mMaxSize;
      nh = int((double(mMaxSize)*double(h))/double(w));
    }
    else
    {
      nh = mMaxSize;
      nw = int((double(mMaxSize)*double(w))/double(h));
    }
    if(nh < 1)
      nh = 1;
    if(nw < 1)
      nw = 1;
    *image = image->smoothScale(nw,nh);
  }
  *image = image->smoothScale(w,h);
  return true;
}
/**  */
void ScaleDialog::slotScaleHChanged(int width)
{
  int w,h;
  int w_orig,h_orig;
  double sf;

  if(!originalImage())
    return;
  w = width;
  h = mpScaleVSpin->value();;
  if(mpAspectCheckBox->isChecked())
  {
    mpScaleVSpin->blockSignals(true);
    w_orig = originalImage()->width();
    h_orig = originalImage()->height();
    sf = double(w)/double(w_orig);
    h = int(double(h_orig)*sf);
    if(h < 1)
    {
      mpScaleVSpin->setValue(1);
      h = 1;
      sf = 1.0/double(h_orig);
      w = int(double(w_orig) * sf);
      mpScaleHSpin->blockSignals(true);
      mpScaleHSpin->setValue(w);
      mpScaleHSpin->blockSignals(false);
    }
    else if(h > 20000)
    {
      mpScaleVSpin->setValue(20000);
      h = 20000;
      sf = 20000.0/double(h_orig);
      w = int(double(w_orig) * sf);
      mpScaleHSpin->blockSignals(true);
      mpScaleHSpin->setValue(w);
      mpScaleHSpin->blockSignals(false);
    }
    else
      mpScaleVSpin->setValue(h);
    mpScaleHDoubleSpin->blockSignals(true);
    mpScaleHDoubleSpin->setValue(int(sf*100.0));
    mpScaleHDoubleSpin->blockSignals(false);
    mpScaleVDoubleSpin->blockSignals(true);
    mpScaleVDoubleSpin->setValue(int(sf*100.0));
    mpScaleVDoubleSpin->blockSignals(false);
    mpScaleVSpin->blockSignals(false);
  }
  else
  {
    sf = double(width)/double(originalImage()->width());
    mpScaleHDoubleSpin->blockSignals(true);
    mpScaleHDoubleSpin->setValue(int(sf*100.0));
    mpScaleHDoubleSpin->blockSignals(false);
  }
  updatePreview();
}
/**  */
void ScaleDialog::slotScaleVChanged(int height)
{
  int w,h;
  int w_orig,h_orig;
  double sf;

  h = height;
  w = mpScaleHSpin->value();;
  if(!originalImage())
    return;
  if(mpAspectCheckBox->isChecked())
  {
    mpScaleHSpin->blockSignals(true);
    w_orig = originalImage()->width();
    h_orig = originalImage()->height();
    sf = double(h)/double(h_orig);
    w = int(double(w_orig)*sf);
    if(w < 1)
    {
      mpScaleHSpin->setValue(1);
      w = 1;
      sf = 1.0/double(w_orig);
      h = int(double(h_orig) * sf);
      mpScaleVSpin->blockSignals(true);
      mpScaleVSpin->setValue(w);
      mpScaleVSpin->blockSignals(false);
    }
    else if(w > 20000)
    {
      mpScaleHSpin->setValue(20000);
      w = 20000;
      sf = 20000.0/double(h_orig);
      h = int(double(h_orig) * sf);
      mpScaleVSpin->blockSignals(true);
      mpScaleVSpin->setValue(h);
      mpScaleVSpin->blockSignals(false);
    }
    else
      mpScaleHSpin->setValue(w);
    mpScaleVDoubleSpin->blockSignals(true);
    mpScaleVDoubleSpin->setValue(int(sf*100.0));
    mpScaleVDoubleSpin->blockSignals(false);
    mpScaleHDoubleSpin->blockSignals(true);
    mpScaleHDoubleSpin->setValue(int(sf*100.0));
    mpScaleHDoubleSpin->blockSignals(false);
    mpScaleHSpin->blockSignals(false);
  }
  else
  {
    sf = double(height)/double(originalImage()->height());
    mpScaleVDoubleSpin->blockSignals(true);
    mpScaleVDoubleSpin->setValue(int(sf*100.0));
    mpScaleVDoubleSpin->blockSignals(false);
  }

  updatePreview();
}
/**  */
void ScaleDialog::slotScaleFactorHChanged(int fh)
{
  int w;
  int w_orig;
  double sf;

  if(!originalImage())
    return;
  w_orig = originalImage()->width();
  sf = double(fh)/100.0;
  w = int(double(w_orig) * sf);
  mpScaleHSpin->setValue(w);
}
/**  */
void ScaleDialog::slotScaleFactorVChanged(int fv)
{
  int h;
  int h_orig;
  double sf;

  if(!originalImage())
    return;
  h_orig = originalImage()->height();
  sf = double(fv)/100.0;
  h = int(double(h_orig) * sf);
  mpScaleVSpin->setValue(h);
}
/**  */
void ScaleDialog::slotAspect(bool state)
{
  if(state)
    slotScaleHChanged(mpScaleHSpin->value());
  updatePreview();
}
/** No descriptions */
void ScaleDialog::setImage(QImage* image)
{
  ImageFilterDialog::setImage(image);
  //set values
  if(image)
  {
    slotReset();
  }
}
/** No descriptions */
void ScaleDialog::saveConfig()
{
  xmlConfig->setBoolValue("FILTER_SCALE_KEEP_ASPECT",
                         mpAspectCheckBox->isChecked());
}
/** No descriptions */
void ScaleDialog::slotReset()
{
  mpScaleVSpin->blockSignals(true);
  mpScaleHSpin->blockSignals(true);
  mpScaleVDoubleSpin->blockSignals(true);
  mpScaleHDoubleSpin->blockSignals(true);

  mpScaleVSpin->setValue(originalImage()->height());
  mpScaleHSpin->setValue(originalImage()->width());
  mpScaleVDoubleSpin->setValue(100);
  mpScaleHDoubleSpin->setValue(100);

  mpScaleVSpin->blockSignals(false);
  mpScaleHSpin->blockSignals(false);
  mpScaleVDoubleSpin->blockSignals(false);
  mpScaleHDoubleSpin->blockSignals(false);
  updatePreview();
}
