/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Mar 17 2002
    copyright            : (C) 2002 by Michael Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/
//28.02.2003: applied patch from Aurelien Jarno <aurelien@aurel32.net>
//            set resolution for scanned image correctly

#include "config.h"

#include "qdevicesettings.h"
#include "qimageioext.h"
#include "qscanner.h"
#include "qsanestatusmessage.h"
#include "qscandialog.h"
#include "qscannersetupdlg.h"
#include "qxmlconfig.h"

extern "C"
{
#include <libgimp/gimp.h>
}
#include <qapplication.h>
#include <qcolor.h>
#include <qdir.h>
#include <qdom.h>
#include <qfileinfo.h>
#include <qimage.h>
#include <qmap.h>
#include <qwidget.h>

#include <stdlib.h>

#ifndef VERSION
#define VERSION "0.3"
#endif


extern "C"
{
static void query_proc(void);
#ifdef USE_GIMP1
static void run_proc(gchar* name,
                     gint nparams,
                     GimpParam* param,
                     gint* nreturn_vals,
                     GimpParam** return_vals);
#else
static void run_proc(const gchar* name,
                     gint nparams,
                     const GimpParam* param,
                     gint* nreturn_vals,
                     GimpParam** return_vals);
#endif
}

int copy_to_gimp(QImage& image);

GimpPlugInInfo PLUG_IN_INFO =
{
  NULL,
  NULL,
  query_proc,
  run_proc
};

//used to pass special command line arguments to QApplication
int qt_argc;
char* qt_argv[2];

void qisMessageHandler(QtMsgType type, const char *msg )
{
  //simply ignore all messages
}

int main(int argc, char **argv )
{
  int result;
  QString qs;
  QString appname;

  new QXmlConfig();
  xmlConfig->setVersion(VERSION);
  xmlConfig->setFilePath(QDir::homeDirPath()+
                     "/.quiteinsane_gimp_plugin/quiteinsane_config.xml");
  xmlConfig->setCreator("QuiteInsane GIMP Plugin");

  qs = QDir::homeDirPath()+"/.quiteinsane_gimp_plugin/";
  QDir qd(qs);
  if(!qd.exists())
  {
    //try to create it
    qd.mkdir(qs);
  }
  xmlConfig->readConfigFile();
  qs = xmlConfig->stringValue("STYLE",QString::null);
  qt_argc = 0;
  qt_argv[0] = 0;
  qt_argv[0] = 0;
  if(argv[0] != NULL)
  {
    qt_argv[0] = strdup(argv[0]);
    ++qt_argc;
    if(!qs.isEmpty())
    {
      qt_argv[1] = strdup(qs.latin1());
      ++qt_argc;
    }
  }
//install the message handler, if the the environment variable
//DEBUG_QUITEINSANE_GIMPPLUGIN isn't set

  const char* env_v = getenv("DEBUG_QUITEINSANE_GIMPPLUGIN");
  if(env_v == NULL)
    qInstallMsgHandler(qisMessageHandler);

  QApplication app(qt_argc,qt_argv);


#ifdef USE_GIMP1
  result = gimp_main(argc, argv);
#else
 result = gimp_main(&PLUG_IN_INFO,argc, argv);
#endif 
  return 0;
}

/** No descriptions */
void loadLastSettings(QScanner* scanner)
{
//try to load the settings file
  QMap <QString,QString> option_map;
  QDomDocument doc;
  QString last_dev_settings_name;
  QString qs;
  QString devname = scanner->name();
  doc.clear();

  last_dev_settings_name = scanner->deviceSettingsName();

  QFile f( xmlConfig->absConfDirPath()+"devicesettings.xml" );
  if (f.open( IO_ReadOnly ) )
  {
    doc.setContent( &f );
    f.close();
  }
//The name of such a setting is unique for a given device.
  if(!doc.isNull())
  {//it's a setting
    //We search the specific entry in the xml file.
    QDomElement docElem = doc.documentElement();
    if(docElem.tagName() == "QuiteInsane_device_settings")
    {
      //Ok, now try to find the device settings
      QDomNode n = docElem.firstChild();
      while( !n.isNull() )
      {
        QDomElement e = n.toElement(); // try to convert the node to an element.
        if( !e.isNull() )
        { // the node was really an element.
          if(e.tagName() == "sane_device")
          {
            qs = e.attribute("username");
            //Search the device settings.
            if((last_dev_settings_name == e.attribute("name"))   &&
               (qs == "Last settings"))
            {
              //We found  the entry.
              QDomNodeList dl = n.childNodes();
              for(unsigned int cnt=0;cnt<dl.count();cnt++)
              {
                QDomElement e2 = dl.item(cnt).toElement();
                if(e2.tagName() == "sane_option")
                {
                  option_map.insert(e2.attribute("name"),
                                   e2.attribute("value"));
                }
              }
              break;
            }
          }
        }
        n = n.nextSibling();
      }
    }
  }
  if(!option_map.isEmpty())
  {
    scanner->setOptionsByName(option_map);
  }
}

static void scan(int mode)
{
  //mode == 0: scan with last device in use
  //mode == 1: display device selection dialog
  QString dev;
  dev = xmlConfig->stringValue("LAST_DEVICE",QString::null);
  QScanner* scanner = new QScanner();
  if((mode == 0) && !dev.isEmpty())
  {
    scanner->setDeviceName(dev);
    if(!scanner->openDevice())
    {
      if(QScanner::msAuthorizationCancelled)
      {
        delete scanner;
        return;
      }
      QSaneStatusMessage status_msg(scanner->saneStatus(),0);
      status_msg.exec();
    }
    else
    {
      //we using the last device; set vendor and model
      scanner->setVendor(xmlConfig->stringValue("LAST_DEVICE_VENDOR",QString::null));
      scanner->setModel(xmlConfig->stringValue("LAST_DEVICE_MODEL",QString::null));
    }
  }
  if(!scanner->isOpen())//either mode 1 or error while opening previous device
  {
    QScannerSetupDlg* ssd = new QScannerSetupDlg(scanner,0);
    if(ssd->exec())
    {
      dev = ssd->device();
      scanner->setDeviceName(dev);
      if(!scanner->openDevice())
      {
        if(QScanner::msAuthorizationCancelled)
        {
          delete scanner;
          delete ssd;
          return;
        }
        QSaneStatusMessage status_msg(scanner->saneStatus(),0);
        status_msg.exec();
        delete scanner;
        delete ssd;
        return;
      }
    }
    else
    {
      delete scanner;
      delete ssd;
      return;
    }
  }
  loadLastSettings(scanner);
  QScanDialog* scan_dlg;
  scan_dlg = new QScanDialog(scanner,0);
  scan_dlg->enableMultiSelection(true);
  qApp->setMainWidget(scan_dlg);
  scan_dlg->show();
  qApp->exec();
  //save configuration
  xmlConfig->writeConfigFile();
}

extern "C"
{
static void query_proc(void)
{
  static GimpParamDef args[] =
  {
    {GIMP_PDB_INT32, (gchar*)"run_mode", (gchar*)"Interactive, non-interactive"},
  };
  static GimpParamDef *return_vals = NULL;
  static int nargs = sizeof(args) / sizeof(args[0]);
  static int nreturn_vals = 0;
  char menu_path[1024];
  char name[1024];

  //Select Device
  //When selected, the device selection dialog gets shown. If the user
  //selected a device, it's opened and the scan dialog gets shown.
  sprintf(name,"%s","QuiteInsane-Select");
  sprintf(menu_path,"%s","<Toolbox>/File/Acquire/QuiteInsane/Select Device...");
  gimp_install_procedure(name,
                         "SANE Frontend",
                         "Interface to scanners supported by SANE",
                         "Michael Herder",
                         "(C)",
                         "31.10.2002",
                         menu_path,
                         0,
                         GIMP_EXTENSION,
                         nargs, nreturn_vals,
                         args, return_vals);
  //Scan
  //Try to scan with the last device in use; if the device isn't available, then
  //the device selection dialog is shown first.
  sprintf(name,"%s","QuiteInsane-Scan");
  sprintf(menu_path,"%s","<Toolbox>/File/Acquire/QuiteInsane/Scan...");
  gimp_install_procedure(name,
                         "SANE Frontend",
                         "Interface to scanners supported by SANE",
                         "Michael Herder",
                         "(C)",
                         "31.10.2002",
                         menu_path,
                         0,
                         GIMP_EXTENSION,
                         nargs, nreturn_vals,
                         args, return_vals);
}

#ifdef USE_GIMP1
static void run_proc(gchar* name,
                     gint nparams,
                     GimpParam* param,
                     gint* nreturn_vals,
                     GimpParam** return_vals)
#else
static void run_proc(const gchar* name,
                     gint nparams,
                     const GimpParam* param,
                     gint* nreturn_vals,
                     GimpParam** return_vals)
#endif
{
  static GimpParam values[2];
#ifdef USE_GIMP1
  GimpRunModeType run_mode;
#else
  GimpPDBArgType run_mode;
#endif
  int nargs;
  int mode = 0;
#ifdef USE_GIMP1
  run_mode = (GimpRunModeType) param->data.d_int32;
#else
  run_mode = (GimpPDBArgType) param->data.d_int32;
#endif
  *nreturn_vals = 1;
  *return_vals = values;

  values[0].type = GIMP_PDB_STATUS;
  values[0].data.d_status = GIMP_PDB_CALLING_ERROR;
  if(strcmp(name,"QuiteInsane-Scan") == 0)
    mode = 0;
  else
    mode = 1;
  nargs = 0;
  switch (run_mode)
  {
    case GIMP_RUN_INTERACTIVE:
      scan(mode);
      values[0].data.d_status = GIMP_PDB_SUCCESS;
      break;

    case GIMP_RUN_NONINTERACTIVE:
      break;

    case GIMP_RUN_WITH_LAST_VALS:
      break;

    default:
      break;
  }
}
}

int copy_to_gimp(QImage& image)
{
  int is_rgb = 0;
  int x,y;
  int remaining;
  size_t tile_size;
  GimpImageBaseType image_type = GIMP_GRAY;
  GimpImageType drawable_type = GIMP_GRAY_IMAGE;
  gint32 layer_ID;
  gint32 image_ID;
  GimpDrawable *drawable;
  guchar *tile;
  GimpPixelRgn region;
  unsigned int tile_offset = 0;

  tile_size = image.width() * gimp_tile_height();
  if(image.depth() == 32)
  {
    is_rgb = 1;
    tile_size *= 3;
    image_type    = GIMP_RGB;
    drawable_type = GIMP_RGB_IMAGE;
  }

  image_ID = gimp_image_new(image.width(),image.height(),image_type);
  layer_ID = gimp_layer_new(image_ID,"Background",image.width(),image.height(),
                            drawable_type, 100.0, GIMP_NORMAL_MODE);
  gimp_image_set_resolution(image_ID,
                           int(double(image.dotsPerMeterX()) * 2.54 / 100.0),
                           int(double(image.dotsPerMeterY()) * 2.54 / 100.0));
  gimp_image_add_layer(image_ID, layer_ID, 0);
  drawable = gimp_drawable_get(layer_ID);
  gimp_pixel_rgn_init(&region, drawable, 0, 0, drawable->width, drawable->height, TRUE, FALSE);
  tile = g_new(guchar, tile_size);
  x=0;
  y=0;
  for(y = 0; y < image.height(); y++)
  {
    for(x = 0; x < image.width(); x++)
    {
      QRgb rgb = image.pixel(x,y);
      if(is_rgb == 1)
      {
        tile[tile_offset] = (guchar)qRed(rgb);
        ++tile_offset;
        tile[tile_offset] = (guchar)qGreen(rgb);
        ++tile_offset;
        tile[tile_offset] = (guchar)qBlue(rgb);
        ++tile_offset;
      }
      else
      {
        tile[tile_offset] = (guchar)qGray(rgb);
        ++tile_offset;
      }
    }
    int tile_height = gimp_tile_height();
    if ((y+1) % tile_height == 0)
    {
      gimp_pixel_rgn_set_rect(&region, tile,0,(y+1) - tile_height,image.width(),tile_height);
      tile_offset = 0;
    }
  }
  remaining = image.height() % gimp_tile_height();

  if (remaining)
  {
    gimp_pixel_rgn_set_rect(&region, tile, 0, image.height() - remaining,
                            image.width(), remaining);
  }

  gimp_drawable_flush(drawable);
  gimp_display_new(image_ID);
  gimp_drawable_detach(drawable);
  g_free(tile);
  tile = 0;
 return 0;
}
