#!/bin/csh -fex
#
# Run rtcontrib to compute contributing images
#

# Number of processors available:
set NP=1

# Tregenza data file
set TREGDATF=tregsamp.dat

# View to render:
set vw="-vf wide.vf -x 1024 -y 1024"
set res=`vwrays -d $vw`

# First, create images corresponding to sources & directions

if (! -d src_cont) then
oconv -f model.mat sky.rad model.rad > model$$.oct
mkillum -dr 0 -ab 0 model$$.oct < sources.rad \
	| oconv -i model$$.oct - > smodel$$.oct
rm -f model$$.oct
mkdir src_cont
vwrays -ff $vw \
	| rtcontrib $res -ffc -n $NP -f bins.cal \
	-b win_bin -bn 102 \
	-o src_cont/west_win%03d.hdr -m west_win_ill \
	-o src_cont/cent_win%03d.hdr -m cent_win_ill \
	-o src_cont/east_win%03d.hdr -m east_win_ill \
	-b sky_bin -bn 102 \
	-o src_cont/pipe0_%03d.hdr -m pipe0_ill \
	-o src_cont/pipe1_%03d.hdr -m pipe1_ill \
	-o src_cont/pipe2_%03d.hdr -m pipe2_ill \
	-o src_cont/pipe3_%03d.hdr -m pipe3_ill \
	-dr 0 -ab 2 smodel$$.oct
rm -f smodel$$.oct
time
endif

# Next, create source-daylight coefficients

if (! -d src_dc) then
oconv model.mat '\!xform -I glows.rad' model.rad > smodel$$.oct
mkdir src_dc
set i=500
while ($i > 0)
rcalc -of -e 'YOFF:-1.7' -e 'Dx=-$4;Dy=-$5;Dz=-$6' \
	-e "xrand=.5+29*rand($i+recno*PI)+if(-Dy,YOFF*Dz/Dy,0)" \
	-e "zrand=21+2.7*rand($i-recno/PI)+if(-Dy,YOFF*Dx/Dy,0)" \
	-e '$1=xrand;$2=YOFF;$3=zrand;$4=Dx;$5=Dy;$6=Dz' \
		$TREGDATF \
	| rtcontrib -h -ff -V -f bins.cal -lr -16 \
	-b win_bin -bn 102 \
	-o "\!rcalc -if3 -of -e "\''$1=(.265*$1+.670*$2+.065*$3)*78.3'\'" | total -if102 -64 -m > src_dc/0west_win.dat" -m west_win_glow \
	-o "\!rcalc -if3 -of -e "\''$1=(.265*$1+.670*$2+.065*$3)*78.3'\'" | total -if102 -64 -m > src_dc/0cent_win.dat" -m cent_win_glow \
	-o "\!rcalc -if3 -of -e "\''$1=(.265*$1+.670*$2+.065*$3)*78.3'\'" | total -if102 -64 -m > src_dc/0east_win.dat" -m east_win_glow \
	-b sky_bin -bn 102 \
	-o "\!rcalc -if3 -of -e "\''$1=(.265*$1+.670*$2+.065*$3)*78.3'\'" | total -if102 -64 -m > src_dc/0pipe0.dat" -m pipe0_glow \
	-o "\!rcalc -if3 -of -e "\''$1=(.265*$1+.670*$2+.065*$3)*78.3'\'" | total -if102 -64 -m > src_dc/0pipe1.dat" -m pipe1_glow \
	-o "\!rcalc -if3 -of -e "\''$1=(.265*$1+.670*$2+.065*$3)*78.3'\'" | total -if102 -64 -m > src_dc/0pipe2.dat" -m pipe2_glow \
	-o "\!rcalc -if3 -of -e "\''$1=(.265*$1+.670*$2+.065*$3)*78.3'\'" | total -if102 -64 -m > src_dc/0pipe3.dat" -m pipe3_glow \
	-dr 0 -ab 1 smodel$$.oct
	foreach s ({west,cent,east}_win pipe{0,1,2,3})
		if (! -f src_dc/0$s.dat) continue
		if (-f src_dc/$s.dat) then
			mv src_dc/{,1}$s.dat
			rlam src_dc/{1,0}$s.dat \
				| rcalc -f sumbins.cal \
				> src_dc/$s.dat
			rm -f src_dc/{0,1}$s.dat
		else
			sed 's/$/	1/' src_dc/0$s.dat > src_dc/$s.dat
			rm -f src_dc/0$s.dat
		endif
	end
@ i--
end
rm -f smodel$$.oct
time
endif
