#include "rcui.h"

#include <engine/engine.h>
#include <engine/debug.h>

RcEngine *RC_engine;
RCUI_params ui_params;
RCUI_stores ui_stores;

void RCUI_init (void)
{  
  g_assert ( RC_engine );
  ui_params.col_selected = FALSE;
  ui_params.insert_mode = RCUI_INSERT_END;
  ui_params.saveas = NULL;
  ui_params.angle_unit = rc_engine_get_angleunit( RC_engine );
  RCUI_create_lists();
}

int
main (int argc, char *argv[])
{
  GtkWidget *main_window;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);

/*  rc_debug_add_state( RC_DBG_ENGINE );
  rc_debug_add_state( RC_DBG_TOPLEVEL );
*/
  
  RC_engine = rc_engine_new();
  rc_engine_set_streams( RC_engine, NULL, NULL );
	
  rc_engine_load_state( RC_engine );

  RCUI_init();
  RCUI_load_state (ui_stores.mainw_store);

  main_window = create_main_window ();
  gtk_widget_show (main_window);
    

  gtk_main ();
  
  RCUI_save_state (ui_stores.mainw_store);
  rc_engine_save_state( RC_engine );
  rc_engine_delete( RC_engine );

  return 0;
}

