#include "private/qrichtext_p.h"

static void textEditMoveToAnchor(QTextEdit *edit, const QString &name)
{
    if ( name.isEmpty() )
	return;
    edit->sync();
    QTextCursor l_cursor( edit->document());
    QTextParagraph* last = edit->document()->lastParagraph();
    for (;;) {
	QTextStringChar* c = l_cursor.paragraph()->at( l_cursor.index() );
	if( c->isAnchor() ) {
	    QString a = c->anchorName();
	    fprintf(stderr, "QTextEdit::scrollToAnchor: anchor nm [%s]\n",
		    (const char *)a.ascii());
	    if ( a == name ||
		 (a.contains( '#' ) && 
		  QStringList::split( '#', a ).contains( name ) ) ) {
		
		*(edit->textCursor())  = l_cursor;
		edit->ensureCursorVisible();
		break;
	    }
	}
	if ( l_cursor.paragraph() == last && l_cursor.atParagEnd()  )
	    break;
	l_cursor.gotoNextLetter();
    }
}
