
# sf convention:
#    status: 1 = active
#    status: 3 = hidden

class PackageVO:
    def __init__(self, packagename=None, packageid=None, status=None, fullaccess=None):
        self.packagename = packagename
        self.packageid = packageid
        self.status = status
        self.fullaccess = fullaccess

    def copy(self):
        return PackageVO(self.packagename,
                         self.packageid,
                         self.status,
                         self.fullaccess)

    def __repr__(self):
        return "PackageVO: <%s - %s - %s - %s>" % (self.packagename,
                                                   self.packageid,
                                                   self.status,
                                                   self.fullaccess)


    def __cmp__(self, other):
        if self.projectname < other.projectname: return -1
        elif self.projectname == other.projectname: return 0
        else: return 1
        

    def __eq__(self, cmp):
        if self.packagename == cmp.packagename \
           and self.packageid == cmp.packageid \
           and self.status == cmp.status:
            return True
        else:
            return False

    def __hash__(self):
        return hash("%s:%s" % (self.packagename, self.packageid))

    def setPackageName(self, packagename):
        self.packagename = packagename

    def setPackageId(self, packageid):
        self.packageid = packageid

    def setPackageStatus(self, status):
        self.status = status

    def setFullAccess(self, fullaccess):
        self.fullaccess = fullaccess
        
    def getPackageName(self):
        return self.packagename

    def getPackageId(self):
        return self.packageid

    def getPackageStatus(self):
        return self.status

    def getFullAccess(self):
        return self.fullaccess

