from qt import *
from aboutDialogBA import AboutDialogBA
from version import VERSION



message = """




ReleaseForge version: %s


http://releaseforge.sourceforge.net
 
Developed By: Phil Schwartz
phil_schwartz@users.sourceforge.net


  
Logo designed by: Curtis Taylor
curtistee@users.sourceforge.net


ReleaseForge is licensed according to the GPL


Other projects by Phil Schwartz:

Kodos - A Regular Expression Debugger
http://kodos.sourceforge.net

DenyHosts - Thwarts SSH server attacks
http://denyhosts.sourceforge.net


Scratchy - Apache log parser and report generator
http://scratchy.sourceforge.net


FAQtor - The easy way to generate FAQs
http://faqtor.sourceforge.net



""" % VERSION



class AboutDialog(AboutDialogBA):
    def __init__(self, parent):
        AboutDialogBA.__init__(self)
        msg = self.center_message()

        self.messageTextBrowser.setText(msg)

        self.num_paragraphs = self.messageTextBrowser.paragraphs()
        self.paragraph = 4 # skip passed blank lines, initially
        self.timer = QTimer(self)
        self.connect(self.timer, SIGNAL("timeout()"),
                     self.update_message)
        self.timer.start(1000, False)


    def center_message(self):
        lines = message.splitlines()
        #w = self.messageTextBrowser.width()
        w = 50
        centered = []
        for line in lines:
            centered.append(line.center(w).rstrip())
        return '\n'.join(centered)


    def update_message(self):
        if self.paragraph >= self.num_paragraphs - 1:
            self.paragraph = 0
        else:
            self.paragraph += 1
            
        self.messageTextBrowser.setCursorPosition(self.paragraph, 0)
    






