from qt import *
from qttable import *
from freshmeatSetupBA import FreshmeatSetupBA
from help import Help
import logging
from fm import FM
try:
    # python2.4
    set = set
except:
    # python2.3 compatibility
    from sets import Set
    set = Set
    
debug = logging.getLogger("freshmeatSetup").debug

COL_FM_PROJECT = 0
COL_SF_PROJECT = 1

CHOOSE = "Choose..."

class FreshmeatSetup(FreshmeatSetupBA):
    def __init__(self, parent, data_path, projects, sf_projects):
        FreshmeatSetupBA.__init__(self, parent)
        self.parent = parent
        self.data_path = data_path
        self.projects = projects
        self.projects_dict = {}
        self.sf_projects = sf_projects
        self.sf_projects_dict = self.__get_sf_projects_dict()
        self.projectTable.setColumnReadOnly(COL_FM_PROJECT, True)

        self.populateTable()

        self.show()
        

    def populateTable(self):
        for fm_vo in self.projects:
            project_name = fm_vo.getProjectName()
            self.projects_dict[project_name] = fm_vo
            self.__addProject(fm_vo)
            
        self.__resizeColumn(COL_FM_PROJECT)
        self.__resizeColumn(COL_SF_PROJECT)
        

    def __get_sf_projects_dict(self):
        d = {}
        for p in self.sf_projects:
            d[p.getProjectName()] = p.getGroupId()
        return d
    
    def __resizeColumn(self, colnum):
        self.projectTable.adjustColumn(colnum)
        width = self.projectTable.columnWidth(colnum)
        self.projectTable.setColumnWidth(colnum, width + 5)


    def __getProjectComboData(self):
        keys = [vo.getProjectName() for vo in self.sf_projects]
        keys.sort()
        strlist = QStringList()
        strlist.append(CHOOSE)
        for key in keys:
            strlist.append(key)
        return strlist   


    def __addProject(self, fm_project_vo):
        rownum = self.projectTable.numRows()
        project_name = fm_project_vo.getProjectName()
        self.projectTable.setNumRows(rownum + 1)

        self.projectTable.setText(rownum, COL_FM_PROJECT, project_name)

        sf_combo_data = self.__getProjectComboData()
        sf_combo = QComboTableItem(self.projectTable,
                                   sf_combo_data)
        
        sf_combo.setCurrentItem(fm_project_vo.getSFProjectName())
            
        self.projectTable.setItem(rownum, COL_SF_PROJECT, sf_combo)

            
    def help(self):
        self._help = Help(self, "freshmeat_setup.html")


    def accept(self):
        # for each fm proj ... check sf proj value
        # if sfp = Choose... -> set fm proj.groupid to ""
        # else: find groupid associated with sfp and set fm proj.groupid accordingly
        # save fm projects

        rownum = self.projectTable.numRows()

        projects = set() # set containing fm project vo's
        sf_proj_names = set() # ensure that a SF proj is only used once
        
        for i in range(rownum):
            fm_proj_name = str(self.projectTable.text(i, COL_FM_PROJECT))
            debug("Freshmeat project name: %s", fm_proj_name)

            fm_proj_vo = self.projects_dict.get(fm_proj_name)
            
            sf_combo = self.projectTable.item(i, COL_SF_PROJECT)
            sf_project_name = str(sf_combo.currentText())
            if sf_project_name == CHOOSE:
                group_id = ""
                sf_project_name = ""              
            else:
                group_id = self.sf_projects_dict.get(sf_project_name, "")
                if sf_project_name in sf_proj_names:
                    QMessageBox.warning(self,
                                        "Duplicate Sourceforge project",
                                        "You have linked %s to more than one\n"
                                        "Freshmeat project.\n\n"
                                        "If this was not intentional then you\n"
                                        "should update your settings.\n"
                                        % sf_project_name)

                sf_proj_names.add(sf_project_name)

            fm_proj_vo.setGroupId(group_id)
            fm_proj_vo.setSFProjectName(sf_project_name)
            projects.add(fm_proj_vo)
        
        fm = FM(self.data_path)
        fm.save_projects(projects)
        self.projects = projects
        self.parent.emit(PYSIGNAL("fm_settings_changed()"), (projects, ))

        FreshmeatSetupBA.accept(self)


