# This -*- perl -*- script builds and installs rat/ncat for Windows

#!perl
require 5.004;
#use strict;
use Config;
use File::Basename qw(basename dirname);

#--- Configuration section ---

my @programs_to_install = qw(ncat ncat_report rat ncat_config snarf);
my @docs_to_install     = qw(doc/rat.txt doc/rat.html doc/ncat.txt doc/ncat.html doc/ncat_report.txt doc/ncat_report.html rscg.pdf);
my @libs_to_install	= qw(lib/NCAT.pm);
my @etc_to_install	= qw(etc/ncat.conf etc/README.WIN32.txt etc/GPL.txt etc/FAQ.txt etc/NSA_NOTICE.txt etc/RELEASE-NOTES.txt etc/ncat.conf.MASTER);
my @contrib_to_install	= qw();

#--- End Configuration - You should not have to change anything below this line

# Declaration
my (
    $opt_interactive,	$opt_version,
    $opt_verbose,	$opt_help,
    $instprefix,	$opt_ratlib,
    $progname,		$instdir,
    $targetdir,		$program,
    $document,		$docbasename,
    ) = ('', '', '', '', '', '', '', '', '', '', '', '');
my (@instdirs, @syscmd,
   ) = ((), ());

@instdirs = ("lib", "etc", "bin", "t", "doc", "contrib");
#test for Windows
unless ($Config{'osname'} =~ /MSWin/) {
    &Usage('This program is used for ActiveState Windows installs only');
}

#default values
$progname      = $0;
$progname      =~ s,.*/,,;    # only basename left in progname


print "Checking for IO::Handle............";
eval {
    require IO::Handle
    #File::stat->VERSION('2.00');
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
IO::Handle is required from the base libraries to check config locations.
Something may be amiss with your installation of perl.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for File::Copy............";
eval {
    require File::Copy;
    Getopt::Long->VERSION('2.00');
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
File::Copy is a base Perl module; something may be amiss with your
installation as this.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Getopt::Long..........";
eval {
    require Getopt::Long;
    Getopt::Long->VERSION('2.00');
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
Getopt::Long is a base Perl module; something may be amiss with your
installation as this is needed to handle the options passed on the
command line.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Net::Telnet...........";                                                                                         
eval {
    require Net::Telnet
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
Net::Telnet is required to use snarf.  See the file doc/INSTALL.WIN32 for
installation instructions.  Use the file winmake-nosnarf.PL if you wish to
use RAT without the ability to use snarf.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}   

print "Checking for Net::Telnet::Cisco....";                                                                                        

eval {
    require Net::Telnet::Cisco
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
Net::Telnet::Cisco is required to use snarf.  See the file doc/INSTALL.WIN32 for 
installation instructions.  Use the file winmake-nosnarf.PL if you wish to
use RAT without the ability to use snarf.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}



# Libraries exist, continue.

use Getopt::Long;
use IO::Handle;
use File::Stat;
use File::Copy;

GetOptions(
           'interactive|i',	\$opt_interactive,
	   'version|V',    	\$opt_version,
	   'verbose|v', 	\$opt_verbose,
	   'help|h', 		\$opt_help,
	  )
    or &Usage('');

&Version if $opt_version;
&Usage("") if ($opt_help);
&Usage("") if (!@ARGV && !$opt_interactive);

if ($opt_interactive) {
  # User has asked for an interactive installation, ask for the install
  # prefix
  print "\n\n";
  print <<EOT;
RAT needs an installation home (e.g. c:\\rat).  Enter the full path for the
installation of RAT.

EOT
  print 'e.x. "C:\\rat" : ';
  $instprefix = <STDIN>;
  chomp $instprefix;
} else {
  $instprefix = @ARGV[0];
}


print "\nUsing prefix directory \"$instprefix\".\n\n";


# Create the directory structure
unless (-d $instprefix) {
  print "\nDirectory $instprefix does not exist, creating....";
  if(mkdir $instprefix) {
    print "success\n";
  } else {
    print "failed\n";
    print "ERROR: $!\n";
    exit(2);
  }
} else {
  print "\nTarget $instprefix exists.  Continuing.\n";
}
foreach $instdir (@instdirs) {
  $targetdir = '';
  $targetdir = "$instprefix/$instdir";
  unless (-d $targetdir) {
    print "Directory $targetdir does not exist, creating....";
    if (mkdir $targetdir) {
      print "success\n";
    } else {
      print "failed\n";
      print "ERROR: $!\n";
      exit(2);
    }
  } else {
    print "Target $targetdir exists.  Continuing.\n";
  }
}


# Set environment variables
$ENV{'PREFIX'} = "$instprefix";
if ($opt_verbose) { print "Setting ENV PREFIX to $instprefix\n"; }
$ENV{'INSTALLSITELIB'} = "$instprefix/lib";
if ($opt_verbose) { print "Setting ENV INSTALLSITELIB to $instprefix/lib\n"; }

# Build executables with substitutions
foreach $program (@programs_to_install) {
  @syscmd = ("perl", "bin/$program\.PL");
  system(@syscmd) == 0 
    or die "system @syscmd failed: $?";
}

# Copy the files to the correct destinations
# In the Unix Makefile.PL, we do not copy the HTML files into the /doc directory
# I think we should do so in Windows, as documentation in Windows should live in
# the relative directory where the programs are, as opposed to Unix and MANDIR
foreach $program (@programs_to_install) {
  print "Copying $program to $instprefix/bin/$program...";
  unless(copy("bin/$program", "$instprefix/bin/$program")) {
    print " failed.\n";
    print "Cannot copy bin/$program to $instprefix/bin/$program: $!";
    exit(3);
  } else {
    print " success.\n";
  }
}

foreach $document (@docs_to_install) {
  print "Copying $document to $instprefix/$document...";
  unless(copy("$document", "$instprefix/$document")) {
    print " failed.\n";
    print "Cannot copy $document to $instprefix/$document: $!";
    exit(3);
  } else {
    print " success.\n";
  }
}

foreach $library (@libs_to_install) {
  print "Copying $library to $instprefix/$library...";
  unless(copy("$library", "$instprefix/$library")) {
    print " failed.\n";
    print "Cannot copy $library to $instprefix/$library: $!";
    exit(4);
  } else {
    print " success.\n";
  }
}

foreach $etcfile (@etc_to_install) {
  print "Copying $etcfile to $instprefix/$etcfile...";
  unless(copy("$etcfile", "$instprefix/$etcfile")) {
    print " failed.\n";
    print "Cannot copy $etcfile to $instprefix/$etcfile: $!";
    exit(5);
  } else {
    print " success.\n";
  }
}

foreach $contribfile (@contrib_to_install) {
  print "Copying $contribfile to $instprefix/$contribfile...";
  unless(copy("$contribfile", "$instprefix/$contribfile")) {
    print " failed.\n";
    print "Cannot copy $contribfile to $instprefix/$contribfile: $!";
    exit(6);
  } else {
    print " success.\n";
  }
}



print "\n\nInstallation Complete!  See $instprefix/etc/README.WIN32.txt for";
print "help in getting\nstarted using RAT.\n";


sub Version {
    print STDERR "This is $progname version 1.0\n";
    print STDERR "\n\n";
    print STDERR "Copyright 2002, George M. Jones\n";
    print STDERR "\n";
    print STDERR "This program is free software; you can redistribute it and/or\n";
    print STDERR "modify it under the same terms as Perl itself.\n";
    exit(0);
}


sub Usage {
  my($msg) = @_;

  select(STDERR);
  autoflush STDERR 1;

  print STDERR "$progname: $msg\n" unless ($msg eq "");
  print "Usage:\n";
  print "  $progname [options] | x:\\install\\directory\n";
  print "    -i, --interactive\n";
  print "    -h, --help\n";  
  print "    -V, --version\n";
  print "    -v, --verbose\n";

  exit(1);
}
# $Id: winmake.PL,v 1.6 2002/03/14 16:39:35 gmj Exp $
