/*
 * acl_getname.c: Getname functions for the CAP module
 *
 * Author and Copyright (C) 1999-2005 Amon Ott (ao@rsbac.org)
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License as
 *      published by the Free Software Foundation, version 2.
 *
 * Last modified 27/05/2005.
 */

#include <rsbac/getname.h>
#include <rsbac/cap_getname.h>
#include <rsbac/helpers.h>
#include <rsbac/error.h>

#ifdef __KERNEL__
#include <linux/sched.h>
#include <linux/string.h>
#include <rsbac/rkmem.h>
#include <rsbac/debug.h>
#include <rsbac/aci.h>
#else
#include <string.h>
#endif

#ifdef __KERNEL__
#ifdef CONFIG_RSBAC_CAP_LOG_MISSING
void rsbac_cap_log_missing_cap(int cap)
{
	char *tmp;
	union rsbac_target_id_t i_tid;
	union rsbac_attribute_value_t i_attr_val1;

#if 0 && LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
	if (cap == CAP_SYS_ADMIN)
		return;
#endif

	i_tid.process = current->pid;
	if (rsbac_get_attr(CAP,
			   T_PROCESS,
			   i_tid, A_max_caps_user, &i_attr_val1, FALSE)) {
		rsbac_ds_get_error("rsbac_cap_log_missing_cap()",
				   A_max_caps_user);
	} else {
		if (!(i_attr_val1.max_caps_user & (1 << cap))) {
			tmp = rsbac_kmalloc(RSBAC_MAXNAMELEN);
			if (tmp) {
				get_cap_name(tmp, cap);
				rsbac_pr_debug(aef, "capable(): pid %u(%.15s), "
					       "uid %u: missing user max_cap %s!\n",
					       current->pid, current->comm,
					       current->uid, tmp);
				rsbac_kfree(tmp);
			}
		}
	}
	if (rsbac_get_attr(CAP,
			   T_PROCESS,
			   i_tid,
			   A_max_caps_program, &i_attr_val1, FALSE)) {
		rsbac_ds_get_error("rsbac_cap_log_missing_cap()",
				   A_max_caps_program);
	} else {
		if (!(i_attr_val1.max_caps_program & (1 << cap))) {
			tmp = rsbac_kmalloc(RSBAC_MAXNAMELEN);
			if (tmp) {
				get_cap_name(tmp, cap);
				rsbac_pr_debug(aef, "capable(): pid %u(%.15s), uid %u: "
					       "missing program max_cap %s!\n",
					       current->pid, current->comm,
					       current->uid, tmp);
				rsbac_kfree(tmp);
			}
		}
	}
}
#endif
#endif
