/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file PrefsPage.hxx
    \author Romain BONDUE
    \date 19/07/2006
    \warning This file should only be included from PrefsPage.h */
inline nsGUI::CPrefsPage::operator ::GtkWidget* () throw()
{
    return GTK_WIDGET (m_pTable);

} // operator ::GtkWidget*()


inline nsGUI::CPrefsPage::operator const ::GtkWidget* () const throw()
{
    return GTK_WIDGET (m_pTable);

} // operator ::GtkWidget*()


inline bool nsGUI::CPrefsPage::StartMinimized () const throw()
{
    return ::gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
                                                    (m_pStartMinimizedButton));

} // StartMinimized()


inline void nsGUI::CPrefsPage::StartMinimized (bool B) throw()
{
    ::gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
                                                (m_pStartMinimizedButton), B);

} // StartMinimized()


inline void nsGUI::CPrefsPage::AddChangeInterfaceCallBack
                                    (::GCallback CallBack, void* pData) throw()
{
    ::g_signal_connect_swapped (G_OBJECT (m_pChangeInterface), "clicked",
                                CallBack, pData);

} // AddChangeInterfaceCallBack()


inline void nsGUI::CPrefsPage::AddRootModeChangedCallBack
                                    (::GCallback CallBack, void* pData) throw()
{
    ::g_signal_connect_swapped (G_OBJECT (m_pRootModeButton), "toggled",
                                CallBack, pData);

} // AddRootModeChanged()


inline void nsGUI::CPrefsPage::SetRootMode (bool B) throw()
{
    ::gtk_toggle_button_set_active (m_pRootModeButton, B);

} // SetRootMode()


inline void nsGUI::CPrefsPage::AddAutoLeaveRootModeCallBack
                                    (::GCallback CallBack, void* pData) throw()
{
    ::g_signal_connect_swapped (G_OBJECT (m_pLeaveRootModeBox), "changed",
                                CallBack, pData);

} // AddAutoLeaveRootModeCallBack()


inline void nsGUI::CPrefsPage::AddRateChangedCallBack (::GCallback CallBack,
                                                       void* pData) throw()
{
    ::g_signal_connect_swapped (G_OBJECT (m_pRatesBox), "changed", CallBack,
                                pData);

} // AddRateChangedCallBack()


inline bool nsGUI::CPrefsPage::DisplayTrayIcon () const throw()
{
    return ::gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
                                                        (m_pTrayIconButton));

} // DisplayTrayIcon()


inline unsigned nsGUI::CPrefsPage::GetSelectedRateIndex () const throw()
{
    return ::gtk_combo_box_get_active (m_pRatesBox);

} // GetSelectedRateIndex()


inline void nsGUI::CPrefsPage::SetRateIndex (unsigned Index) throw()
{
    ::gtk_combo_box_set_active (m_pRatesBox, Index);

} // SetRateIndex()


inline void nsGUI::CPrefsPage::DisplayTrayIcon (bool B) throw()
{
    ::gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (m_pTrayIconButton), B);

} // DisplayTrayIcon()


inline void nsGUI::CPrefsPage::AddTrayIconButtonCallBack (::GCallback CallBack,
                                                          void* pData) throw()
{
    ::g_signal_connect_swapped (G_OBJECT (m_pTrayIconButton), "clicked",
                                CallBack, pData);

} // AddTrayIconButtonCallBack()


inline void nsGUI::CPrefsPage::AddIfaceStatusChangeCallBack
                                    (::GCallback CallBack, void* pData) throw()
{
    ::g_signal_connect_swapped (G_OBJECT (m_pIfaceStatusButton), "toggled",
                                CallBack, pData);

} // AddIfaceStatusChangeCallBack()


inline void nsGUI::CPrefsPage::IfaceStatus (bool Status) throw()
{
    ::gtk_toggle_button_set_active (m_pIfaceStatusButton, Status);

} // IfaceStatus()


inline bool nsGUI::CPrefsPage::IfaceStatus () const throw()
{
    return ::gtk_toggle_button_get_active (m_pIfaceStatusButton);

} // IfaceStatus()


inline void nsGUI::CPrefsPage::IfaceLabel (const std::string& Label) throw()
{
    ::gtk_label_set_text (m_pIfaceLabel, Label.c_str());

} // IfaceLabel()


inline std::string nsGUI::CPrefsPage::IfaceLabel () const throw()
{
    return ::gtk_label_get_text (m_pIfaceLabel);

} // IfaceLabel()
