/*
 * dump.cpp
 *  dump base class
 * 
 *  Copyright (C) 2004,2005 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *   
 *  Author(s): Michael Holzheu
 */

#include "dump.h"

int debug   = 0;

void 
s390TodToTimeval(uint64_t todval, struct timeval *xtime)
{
	/* adjust todclock to 1970 */
	todval -= 0x8126d60e46000000LL - (0x3c26700LL * 1000000 * 4096);

	todval >>= 12;
	xtime->tv_sec  = todval / 1000000;
	xtime->tv_usec = todval % 1000000;
}

Dump::Dump(const char *filename)
{
	fh = fopen(filename, "r+");
	if(!fh){
		throw(DumpErrnoException("Open dump file failed!"));
	}
}

Dump::~Dump(void)
{
	if(fh){
		fclose(fh);
	}
}

void 
ProgressBar::initProgress(void)
{
	progressPercentage = -1;
}

void 
ProgressBar::displayProgress(uint64_t value, uint64_t maxValue)
{
	int j;
	printf("%6lld of %6lld |", (long long)value, (long long)maxValue);
	if(progressPercentage != (int)(value*100/maxValue))
	{
		/* percent value has changed */
		progressPercentage = (value*100/maxValue);
		for (j=1; j<=progressPercentage/2; j++)
			printf("#");
		for (j=progressPercentage/2+1; j<=50; j++)
			printf("-");
		printf("| %3d%%  ", progressPercentage);
	}
	printf("\r");
	fflush(stdout);
}
