/*
 * dump.h
 *  dump base class
 * 
 *  Copyright (C) 2004,2005 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *   
 *  Author(s): Michael Holzheu
 */

#ifndef DUMP_H
#define DUMP_H

#include <stdio.h>
#include <stdint.h>
#include <sys/time.h>
#include <errno.h>
#include <string.h>

extern int debug;

class DumpException
{
public:
	DumpException(void){
		msg[0] = 0;
		errorCode = 0;
	}
	DumpException(char* m){
		sprintf(msg,"%s",m);
		errorCode = 0;
	}
	
	const char * what() const {return msg;}
	int code() const {return errorCode;}
protected:
	char msg[200];
	int  errorCode;
};

class DumpErrnoException : public DumpException
{
public:
	DumpErrnoException(char* m) {
		sprintf(msg,"%s (%s)",m,strerror(errno));
		errorCode = errno;
	}
};

class Dump
{
public:
	Dump(const char* filename);
	Dump(void) : fh(0)
	{}
	virtual ~Dump(void);
	typedef enum {DT_VM32, DT_VM64, DT_VM64_BIG, DT_LKCD32,DT_LKCD64, 
			DT_UNKNOWN} DumpType;
	
	virtual void readMem(char* buf, int size) = 0;
	virtual int  seekMem(uint64_t offset) = 0;
	virtual uint64_t getMemSize(void) const = 0;
	virtual struct timeval getDumpTime(void) const = 0;
protected:
	FILE*   fh;
};

class ProgressBar
{
public:
	ProgressBar(void) {progressPercentage = -1;}
	void initProgress(void);
	void displayProgress(uint64_t value, uint64_t maxValue);
private:
	int progressPercentage;
};

void s390TodToTimeval(uint64_t todval, struct timeval *xtime);

#endif /* DUMP_H */

